+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-10-05T10:09:00-04:00"
lastmod = "2017-10-06T11:06:00-04:00"
preamble = "This year's [Festival Verdi](http://www.teatroregioparma.it/Default.en-Us.aspx) is in full swing, paying its annual homage to Giuseppe Verdi in events large and small to various venues in Busseto and Parma - two Italian cities that make up \"the Verdi homeland\". Their mainstage events include productions of Verdi's *Stiffelio*, *Jérusalem*, *Falstaff* and *La traviata*, and their ongoing [AroundVerdi](http://teatroregioparma.it/Categorie/default.en-Us.aspx?idCategoria=103) and [VerdiYoung](http://teatroregioparma.it/Categorie/default.en-Us.aspx?idCategoria=102) offer events dedicated to young - and very young - audiences, complementing the performances of Verdi's infamous body of work. This year, the Festival is also making an extra nod to Arturo Toscanini in the 150th anniversary of his birth.\n\nWe spoke with Anna Maria Meo, General Director of the Festival, about the onstage and community line-up running through **October 22nd**. For full details, [click here.](http://www.teatroregioparma.it/Default.en-Us.aspx)\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507213142132/2017-10-05---26-Teatro-Giuseppe-Verdi-di----Busseto%2C-Verdi-Monument-ph-Roberto-Ricci.jpg.jpg"
publishDate = "2017-10-06T11:06:00-04:00"
related_articles = ["articles/falstaff-he-saidshe-said.md","articles/in-review-stiffelio.md","articles/in-review-il-trovatore-at-oper-frankfurt.md"]
short_description = "&quot;The Festival Verdi was inaugurated in 2001, one hundred years after Verdi&#039;s death. Since then, extraordinarily talented artists have performed here, including Bruno Bartoletti, Riccardo Chailly, Daniele Gatti, Lorin Maazel, Zubin Mehta, Riccardo Muti, Daniel Oren, Antonio Pappano and Yuri Temirkanov.&quot;"
slug = "verdi-at-204-toscanini-at-150-the-2017-festival-verdi"
title = "Verdi at 204, Toscanini at 150: the 2017 Festival Verdi"
+++

## How have you chosen this year's line-up for the Festival Verdi?

With 4 new productions in 3 different venues, 2 orchestras, 2 choirs, more than 40 artists, young singers and established soloists, Festival Verdi 2017 has more music and performance to offer than ever before. And then there's the destination of Verdi's homeland to complete the
experience.

With great enthusiasm we have dedicated this year's Festival to another great figure in the world of music; our famous fellow citizen who was born and trained in Parma and who, in his youth, was a cellist in our theatre: Arturo Toscanini. This year we celebrate 150 years since his birth and 60 years since his death.

## What is Verdi Off?

Since Festival Verdi is a festival for everyone to discover and experience the music of Verdi, we have created many additional free events that include concerts, exhibitions, art installations, dj-sets, discussions, movies, and more. The diversity and creativity are endless. Always rooted in Verdi but a "jumping off" point for new approaches and new interpretations. There’s even a dedicated [Facebook page](https://www.facebook.com/pg/verdioff/about/?ref=page_internal) and a separate listing on our [website](http://www.teatroregioparma.it/Categorie/Default.en-Us.aspx?idCategoria=104).

A few examples of what Verdi Off has to offer this year:
<ul class="nospace">

<li> Brilliant Waltz - A light installation designed by the artist C999 turns the Pilotta Courtyard into a great ballroom under the stars
<li> Every day, at 1pm, a Verdi aria is sung from the windows of the Ridotto del Teatro Regio
<li> Spontaneously, Verdi's music is performed in the streets and in the art sites of the region
<li> Photographer Roberto Ricci becomes a public storyteller
<li> Music and dancing to accompany the sunrise in the public park much loved of the city
<li> Liturgical music performed by musicians and singers from Conservatory of Music "Arrigo Boito" of Parma
<li> Marching bands in the different town districts
<li> Concerts in private homes by students of Conservatorio di Musica "Arrigo Boito"
<li> A treasure hunt on the theme of Verdi, for kids from 7 to 10 years old

</ul>

In addition to Verdi Off, we continue with AroundVerdi and VerdiYoung. The former is dedicated to young people and to the blending of expressive genres and language to stimulate new reflections on the music of Verdi. The latter is designed for young children, with shows, projects and teaching laboratories, as well as fun musical activities, aimed at instilling and deepening their appreciation of the Maestro and his works.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507213227896/2017-10-05---Verdi-Off---Notte-verdiana_ph----Annalisa-Andolina.jpg.jpg)
<figcaption>Verdi Off's Notte verdiana. Photo: Annalisa Andolina.</figcaption>
</figure>

## What sort of connection exists between the Festival and the communities in Parma and Busseto?

The region that we call "the Verdi homeland" began celebrating the great composer in 1913, the centenary of his birth. That year, there was a double celebration: in Parma under the direction of Cleofonte Campanini, and in Busseto under the already legendary baton of Arturo Toscanini. In 1951, on the 50 th anniversary of Verdi's death, operas and concerts brought some of the greatest artists of their day to Parma. The Verdi Festival began in 1989 and offered a month-long celebration rich in operas, concerts. 

The Festival Verdi was inaugurated in 2001, one hundred years after Verdi's death. Since then, extraordinarily talented artists have performed here, including Bruno Bartoletti, Riccardo Chailly, Daniele Gatti, Lorin Maazel, Zubin Mehta, Riccardo Muti, Daniel Oren, Antonio Pappano and Yuri Temirkanov.

Each autumn, around Giuseppe Verdi's birthday on October 10th, his two hometowns of Parma and Busseto resonate with unique colours and fragrances that speak to our collective imagination, the Festival Verdi comes to life: a full month of music, opera, exhibitions and conferences to celebrate the great Maestro.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507213254341/2017-10-05---Teatro-Farnese-photo-Roberto----Ricci.jpg.jpg)
<figcaption>The Teatro Farnese di Parma. Photo: Roberto Ricci.</figcaption>
</figure>

## Are there any events on this year's Festival line-up that you're particularly excited about?

Absolutely everything! Opening Festival Verdi with the rarely performed *Jerusalem* was sensational and there's so much to experience between now and October 22nd. One distinctive aspect of Festival Verdi, which benefits music lovers, scholars and everyone in general, is the creation of the Verdi Scientific Committee. Lead by Professor Francesco Izzo, the current director of the music department at Southampton University, the Committee supports the programming choices from the vast repertoire of Verdi.

The first step is the adoption of critical editions for three of the four operas in this year's program, one of which is in the final phase of completion and will be performed for the first time. With a critical edition, we hear Verdi's music as he intended the music to be
performed. No other opera music festival is dedicated to such a complete and authentic experience.
