+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-02-06T20:45:00+00:00"
lastmod = "2017-02-07T23:56:00+00:00"
preamble = "With its mission to \"give opera an exciting face lift,\" [Vera Causa Opera](/scene/companies/vera-causa-opera/) is a company based in Ontario's Waterloo region that dedicated to doing away with the old, in favour of what makes opera accessible and free from intimidation. VCO performs new works and adapts old ones, and they keep their ticket prices low ($10 for regular admission, $5 for [VCO members](http://www.vcopera.ca/membership), and free for students). They even post videos of their [past productions online](http://www.vcopera.ca/past-shows).\n\nVCO's next production is Mozart's *Don Giovanni* on **Mard 23, 7pm** at the Kitchener Public Library, and **March 24, 7pm** at the Cambridge Centre for the Arts. We spoke with Dylan Langan, composer, conductor, and Artistic Director of Vera Causa Opera, about how his company offers \"opera for all.\"\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486417554467/2017-02-07---VCO.jpg.jpg"
primary_image_credit = "Image courtesy of Vera Causa Opera."
publishDate = "2017-02-07T14:38:00+00:00"
related_articles = ["articles/michelle-telford.md","articles/kristine-dandavino-on-oshawa-opera.md"]
related_companies = ["scene/companies/vera-causa-opera.md"]
short_description = "&quot;Accessible opera is opera which allows the viewer to have a direct connection with the work, and allows for performers that would otherwise not be able to partake in the production to be a significant part of it. The fact of the matter is there are things which hinder a direct connection to traditional opera. For us, we tailor our operas to suit the average person and in some ways take off the rose-coloured glasses.&quot;"
slug = "vera-causa-opera-opera-for-all"
title = "Vera Causa Opera: &quot;Opera for all.&quot;"
+++

## Can you tell us a bit about Vera Causa's mission and history?

Vera Causa Opera is an innovative opera company in the Region of Waterloo, Ontario, Canada which is making opera more enjoyable, affordable, and accessible for all. We achieve these goals through the adaptation of old operas and the composition of new ones! This initiative is carried out through education in schools, camps, and integrating local performers and professionals into VCO productions, in doing so creating a new and inviting operatic environment. 

Basically, VCO is opera for all. 

I first got the idea for VCO when I wrote my first opera, [*Rise of the Roaches*](https://www.youtube.com/watch?v=rvUnLpWerpo). I had been continually hearing about how students were not getting opportunities in the school operas, and so I wanted to write a fun opera that everyone could understand, and enjoy being a part of. Of course, the first problem I ran into was that there were no avenues to have it premiered. The school couldn't, and it would have taken at least a year for another organization to mount it, provided they were crazy enough to take on an opera about a battle between cockroaches and humans. Instead, I decided to get a band of students together (9 leads and full chorus) and make the premiere a reality. I joined forces with a similar student-led orchestra and together we premiered the work. That was one of the most positive rehearsal experiences I’ve ever had. It proved to me that not only could we present new, enjoyable, and accessible opera, but we could have a blast doing it!

The first formal Vera Causa Opera show was [*The Death of Maria*](https://www.youtube.com/watch?v=sraWYTW3Lvc&feature=youtu.be) in November of 2015. Following the positive experience of *Rise of the Roaches*, I decided that it was time to formalize this project into an organization. Thus VCO was created, an organization which is dedicated to giving opportunities to deserving young professionals of all sorts, providing them with a positive, collaborative, and professional environment in which to hone their skills. We wholeheartedly believe in making opera more enjoyable, affordable, and accessible to everyone. That means $10 tickets (free for students), putting on new opera, and adapting old operas for a new kind of audience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486418205550/2017-02-07---VCO---River-singing-loud.jpg.jpg)<figcaption>Photo courtesy of Vera Causa Opera.</figcaption>
</figure>

## What does it mean for opera to be "accessible"? How does Vera Causa advocate this?

Accessible opera is opera which allows the viewer to have a direct connection with the work, and allows for performers that would otherwise not be able to partake in the production to be a significant part of it. The fact of the matter is there are things which hinder a direct connection to traditional opera. For us, we tailor our operas to suit the average person and in some ways take off the rose-coloured glasses. We insist upon the utmost clarity and transparency in our productions. This means:

**Goodbye, recitative!** Recitative has and continues to be a burden and a hindrance on the average listener. By singing text, you are heightening it and elaborating it. This elaboration obscures the conveyance of the words and furthermore the story. When recitative is replaced with dialogue, the text truly comes first. Funny enough, that’s what everyone who stresses the importance of recitative is after- clarity of text. The success of dialogue as a recitative replacement can be seen in both operetta and musical theatre.

**Ye Shall Use the New Tongue.** The stories of opera are fantastic. That's why we love opera - you get a great story, and then you get some great singing/music on top of that. The above clarity of text via dialogue can only be achieved with language that is both familiar and attractive to the modern patron. This fact means going back to the core of the text, translating everything word for word in English, and from these translations extrapolating a new kind of dialogue, one which conveys the sentiments and plot devices of the texts, but also refrains from embellishing or construing the story. Simply put: it's 2017, and we need language that reflects that. If we want to emphasize an idea or sentiment, there’s a musical number for that.

**Goodbye, subtitles!** Subtitles eliminate a direct connection altogether. When you have to look elsewhere for a translation and furthermore context, you are disengaged from the production. Our English dialogue takes care of both translation and context, and thus when the performers start singing, always in the original language of the work, the audience can sit back and be completely engaged and connected with the performance.

**Adios, boring music!** Not all the music within opera is fantastic - some of it is dull. At VCO we vouch for the idea that you do not need to hear every bar of an opera. In keeping with the above ideas, we put extensive time into parsing and cutting the score so that, between music and dialogue, we have a fluid product. We cut a lot of music. This way, when singers do sing, the selections are dynamic and critical to heighten the emotion of the scene. Opera loses its lust when it drags on, and on, and on... Instead, we ensure that our operas are 1.5-2 hours. The lively, modern combination of dialogue and carefully-chosen music revitalizes opera.

As for accessibility in regards to performers, the reduction in the amount of musical material certainly goes a long way in making their role/part far easier to combat. I will go to great lengths to ensure that a role/part is right for a performer, whether that means cutting a repeat, writing an *ossia*, or even making singing roles speaking ones. Adaptation of this nature means that anyone from any level of musical experience can take part in our shows. They may not be playing the leading tenor (we still need that!), but they will certainly be a vibrant and active part of our production. Thanks to these efforts, our operas are a blast on both sides of the curtain.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486418326163/2017-02-07---Midori-Marsh-River-Guard-Peter-Brooks-Rachel-Ginther-in-Vera-Causa-Opera-Production-of-Echo.jpg.jpg)
<figcaption>Midori Marsh, River Guard, Peter Brooks, and Rachel Ginther in Vera Causa opera's production of *Echo*.</figcaption>
</figure>

## How does Vera Causa fit into the musical/theatrical scene in Kitchener-Waterloo?

Vera Causa Opera fits quite nicely! We are also part of the Cambridge scene, so for us it's a real pleasure to be able to perform and service each city. As for how we fit, we love what other arts organizations are doing in these regions, and they are enjoying what we do too. For me, that's a healthy scene, and one that we love being a part of!


<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486418134628/2017-02-07---Vera-Causa.jpg.jpg)
<figcaption>Dylan Langan, Artistic Director of Vera Causa Opera.</figcaption>
</figure>

## Why have you chosen *Don Giovanni* for your next show?

It's a fantastic opera! Beyond the typical reasons for selection (great story, dynamic characters, fantastic music) we chose *Don Giovanni* because we wanted to try a larger production. This means we will have a larger cast than usual and a large chorus. For us, a larger show means more opportunities for people in the community, as well as for young professionals of all kinds. 

Mozart, musically speaking, is already very accessible. For me, as Artistic Director, I know the show will be a hit with our audience. We have an incredible cast and orchestra lined-up, and I mean incredible. When you have so many brilliant minds like theirs in one room, you know it will be not only a great opera, but a good time too.

>Vera Causa Opera's production of Don Giovanni happens March 23, 7pm, at the Kitchener Public Library, and March 24th, 7pm at the Cambridge Centre for the Arts. For details, [click here](http://www.vcopera.ca/this-season), and greab [tickets here](https://www.ticketscene.ca/events/16879/).
