+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-10-28T12:49:00-04:00"
lastmod = "2018-10-28T16:16:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540745177708/sqAbsentGrace.jpg.jpg"
primary_image_credit = "Carley DeFranco in Opera Bites, Boston Opera Collaborative, 2018. Photo: Dan Busler."
publishDate = "2018-10-28T12:49:00-04:00"
related_companies = ["scene/companies/boston-opera-collaborative.md"]
short_description = "Of course no wife would be spurred to murder her husband based on fortune cookie fortunes, but here it happens, and in exactly the kind of over-the-top manner that only opera can pull off. It was a joyous way to end the first half of the program."
slug = "varied-opera-bites-delivers-interesting-delectable-morsels"
title = "Varied Opera Bites delivers interesting &amp; delectable morsels"
+++

Opera is frequently known as an art form infamous for its protracted length. In a sense, the art form almost operates on it; as a former music professor of mine once observed, if it takes a minute to speak it, it can usually take up to ten to set it to music, owing to the way the music needs room to speak on its own. So what, then, is a composer to do if they only have ten minutes to tell a story in music? As it turns out, quite a bit, and this is something that the [Boston Opera Collaborative](/scene/companies/boston-opera-collaborative/) set out to prove with its *Opera Bites* program, its fourth annual staging of a series of ten-minute operas.

Programming multiple operas in one night is often a thematic challenge, but as anyone who has played in an orchestral concert can tell you, the rules change when you have to perform three works, never mind seven. Performing seven different operas in one evening requires running the gamut of tones and moods; thankfully, these opera bites spanned a wide range of topics, and no two operas covered exactly the same territory. This kept the evening fresh, and it kept the audience on its toes in the best way possible. It also does not hurt that these stories are all taken from short plays; no doubt, the fact that they appeared in short form before opera has helped the theatricality of these pieces immensely.

The evening began with *Midsummer*, in which composer and librettist Scott Wheeler used the fairies from *A Midsummer Night's Dream* to explore existential questions on what happens when people stop believing in gods. It is fairly easy to see what he was going for here, but alas, the libretto as it appears here is so scattered and unfocused it has difficulty finding a tone. I also did not like the way it brushes off Puck's sexual improprieties (and I should note, all of the other characters are women!) with "it was existential dread that drove him to do it". His behavior here is absolutely inexcusable, and in the era of #MeToo that is the worst kind of misguided narrative framing that could have been employed. Still, that does not mean there was nothing of merit: Wheeler demonstrates some wonderful English prosody, and he showcases some brilliant ensemble writing whenever more than one singer has to sing at a time. His humor with the female characters was also really good, and his comic timing with the music was also quite good.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540744848311/Midsummer.jpg.jpg)
<figcaption>l-r: Megan Bisceglia, Ann Fogler, Rebecca Krouner, and Celeste Godin in *Midsummer*, *Opera Bites*, Boston Opera Collaborative, 2018. Photo: Dan Busler.</figcaption>
</figure>

Then the show moved on to *The Battle of Bull Run Always Makes Me Cry*, a short opera in which a woman describes a date to her two friends. Here, composer Jonathan Bailey Holland made perhaps what is the best use of musicalization of the night; he chose to have the woman's date speak through the entire opera rather than sing. While such decisions can get into dicey territory as far as opera goes, here this creative decision played perfectly into the opera's depiction of the man talking about a Civil War battle as if it were, in the words of the female characters, a lecture. It left the music for the quick-witted chattering of its female characters, and while this was set well it was the musical turn towards the sweet that capped off the opera really well. When the music turned sweet with the thematic elements, it capped the opera off beautifully.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540744856610/TheBattleofBullRunAlwaysMakesMeCry.jpg.jpg)
<figcaption>l-r: Alyssa Hensel, Carina DiGianfilippo, and Rebecca Krouner in *The Battle of Bull Run Always Makes Me Cry*, *Opera Bites*, Boston Opera Collaborative, 2018. Photo: Dan Busler.</figcaption>
</figure>

This was followed by perhaps the most surreal opera of the bunch in *Absent Grace*. (Disclaimer: I am a former student of *Absent Grace*'s composer, Marti Epstein.) Epstein's music for *Absent Grace* also demonstrated a keen dramatic eye; through much of the whole, the accompanimental parts seemed to meander, as if lost. While it could be hard for people to get into, its effectiveness is two-fold. First, it fits in with the surreal tone of Claudia Barnett's libretto, which is extremely dream-like in that it plays with whether or not the man and woman do know each other. And then, in the denoument, in which the titular Grace forgives the only other character, it finally finds clarity in an absolutely beautiful moment of a melodic line tripled at the octave. It was one of the highlights of the evening, and provided the most dramatic gut punch of the night.

Following that up in the same half of the program is a daunting task, but composer Eva Conley Kendrick and librettist Mark Harvey Levine more than delivered with *Misfortune*, a comedy of errors about a man whose foreboding (and oddly specific) fortune cookie fortunes just keep getting more and more extreme as time goes on. *Misfortune* is a near flawless comedy of errorsl just when you think the work can't possibly get any crazier, it gets crazier. Its true brilliance, however, is leaning on the medium. Of course no wife would be spurred to murder her husband based on fortune cookie fortunes, but here it happens, and in exactly the kind of over-the-top manner that only opera can pull off. It was a joyous way to end the first half of the program.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540744975370/Misfortune.jpg.jpg)
<figcaption>l-r: Mitch MitzDaniel, Emily Harmon, and Stephanie Hollenberg in *Misfortune*, *Opera Bites*, Boston Opera Collaborative, 2018. Photo: Dan Busler.</figcaption>
</figure>

It was a much-needed palate cleanser, for then Act II opened with *Sunshine Girl*, a short opera about two sisters that are separated during civilian evacuations of London during the Blitz. The varying experiences the girls have (and their subsequent reactions to them) is rather excellently conveyed by composer Sam Wilson in the way he set these characters' tessituras as the opera progresses, and in the end it was rather effecting. However, it could have perhaps done with either expanding it into a full-length opera or trimming the libretto, because it did drag towards the beginning.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540745000945/SunshineGirl.jpg.jpg)
<figcaption>l-r: Alyssa Hensel and Tamara Marsan-Ryan in *Sunshine Girl*, *Opera Bites*, Boston Opera Collaborative, 2018. Photo: Dan Busler.</figcaption>
</figure>

This was then followed by *Steve*. The premise of this opera is that a woman encounters a man who just happens to be the reincarnation of the dog she recently put down. Aside from the fact that the female character accepts this with unrealistic speed (even for an opera that only lasts ten minutes!), they then fall in love. I am certain that composer/librettist Rachel J. Peters entered this with the most innocent of intentions; however, I *greatly* question the wisdom of having a reincarnated dog and his owner both sing libretto along the lines of "I always wanted this" when they are engaging in distinctly human romantic gestures while the words are set in ways that are, in essence, an operatic love duet. The show does contain some genuinely clever humor and the music is not unpleasant, but the effect of that "love duet" was enough to leave me severely disquieted.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540745029519/Steve.jpg.jpg)
<figcaption>l-r: Wes Hunter and Jennifer Caraluzzi in *Steve*, *Opera Bites*, Boston Opera Collaborative, 2018. Photo: Dan Busler.</figcaption>
</figure>

Luckily, *A Case of Anxiety* was able to wash it down with a premise that reads like the family film Luis Buñuel never made: a man keeps dying due to silly household accidents, and each time he keeps coming back to life fretting about the chance he could die. Tony Solitro's music is appropriately light on its feet (even if the orchestration felt a little too heavy at times), and the libretto was quick-witted in the best way. Perhaps it could have done without one particular episode revolving around pirates, but it was still a very entertaining opera all around.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540745054268/ACaseofAnxiety.jpg.jpg)
<figcaption>clockwise from left: Celeste Godin, Andrew Miller, and Ethan DePuy (front) in *A Case of Anxiety*, *Opera Bites*, Boston Opera Collaborative, 2018. Photo: Dan Busler.</figcaption>
</figure>

If I have left out any references to the cast and the staging, well, all of the cast members were absolutely excellent. To go into a quantifiable list across all of the operas would take far too long, but suffice to say that all of the singer-actors that ran around the stage had impeccable comic timing and exquisite pathos depending on the needs of each individual opera, and barring the one aforementioned misstep in *Steve* the direction was excellent. They all also showed impeccable command of their instruments, and the great thing is that no one singer really stood out more than the other. Also helping was an extremely simple set which implied a lot with very little, and was also appropriate for how quick the scene changes between operas needed to be.

Overall, the *Opera Bites* program was quite successful. Each of the different bites had something different to offer, and it was a delight to watch how they unfolded. At this point in the Boston Opera Collaborative's history, this is their fourth time they have done this. If luck is on our side, we will be seeing many more of these *Opera Bites* in the years to come, and I for one cannot wait to see what is in store for future installments.

>Next up for Boston Opera Collaborative in *The Scarlet Ibis*, January 2019. For details, [click here.](https://www.bostonoperacollaborative.org/scarlet-ibis-jan-19)
