+++
author = ["authors/melissa-ratcliff.md"]
categories = "Review"
date = "2023-10-26T05:00:00+01:00"
lastmod = "2023-10-26T05:0:00+01:00"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1698325681/sqVO_The_Magic_Flute_-_Kirsten_MacKinnon_and_Owen_McCausland_-_Emily_Cooper_Photography.jpg"
primary_image_credit = "Kirsten MacKinnon as Pamina and Owen McCausland as Tamino in Vancouver Opera's production of The Magic Flute, 2023. Photo: Emily Cooper Photography."
publishDate = "2023-10-26T00:00:00+01:00"
related_articles = ["articles/die-zauberflote-at-roh.md", "articles/a-refreshing-gateway-drug-the-magic-flute-at-o17.md", "articles/talking-with-singers-audrey-luna.md"]
related_companies = ["scene/companies/vancouver-opera.md"]
related_people = ["scene/people/audrey-luna.md", "scene/people/owen-mccausland.md", "scene/people/roger-honeywell.md", "scene/people/clarence-frazer.md", "scene/people/kirsten-mackinnon.md", "scene/people/stephanie-tritchew.md"]
short_description = "Vocally breathtaking, with phenomenal control, [MacKinnon] would effortlessly float high notes above the orchestra, and then tackle larger passages with incredible vocal strength and size. An absolute force of nature who brought the house down."
slug = "vancouver-operas-glittery-magic-flute"
title = "Vancouver Opera's glittery Magic Flute"

+++
To start the 2023-24 season, [Vancouver Opera](/scene/companies/vancouver-opera/) opens with a whimsical, glittery production of _The Magic Flute_. Staged as a play-within-a-play, this production features both original elements from the 18th century original productions, and a ton of modern elements. 

Opening the show as a wooden stage built into an 18th-century Nobleman's garden, the cast gathers as audience to the show, who are gradually taken offstage to get into costume and perform their roles.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1698325682/VO_The_Magic_Flute_full_stage_-_Emily_Cooper_Photography.jpg){{% /md %}}

<figcaption>The full cast of Vancouver Opera's production of The Magic Flute, 2023. Photo: Emily Cooper Photography.</figcaption>  
</figure>

Starting the show is tenor [Owen McCausland](/scene/people/owen-mccausland/) as Tamino, being chased by a man in a charmingly cheesy three-headed foam dragon costume. McCausland was very sincere in his portrayal of the prince, playing the straight man against the occasionally (and intentionally) campy setup of the show. Vocally he was strong and clear, navigating a challenging role with great strength and endurance. 

His less-than-courageous counterpart Papageno was played by baritone [Clarence Frazer](/scene/people/clarence-frazer/). Definitely playing the comedian to Tamino's straight man, Frazer leaned into the ridiculous comedy of the role, the physicality, being dragged through this adventure very much against his will. It was endlessly funny, and his comedic timing got laughs from even the most seemingly mundane dialogue.

The Three Ladies -- [Melody Courage](https://www.melodycourage.com/), [Stephanie Tritchew](/spotlight-on-stephanie-tritchew/) and [Emma Parkinson](/scene/people/emma-parkinson/) -- were vocally superb. These roles can be very difficult to blend in a big hall, but the harmonies came out clearly even in the lowest registers. As the Queen of the Night, [Audrey Luna](/talking-with-singers-audrey-luna/) struggled with some of the more difficult passages in a notoriously difficult role, but her presence was menacing and threatening throughout.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1698325682/VO_The_Magic_Flute_-_Tamino_with_the_3_Ladys_-_Emily_Cooper_Photography.jpg){{% /md %}}

<figcaption>Owen McCausland (Tamino) with Melody Courage, Stephanie Tritchew, and Emma Parkison (Three Ladies) in Vancouver Opera's production of The Magic Flute, 2023. Photo: Emily Cooper Photography.</figcaption>  
</figure>

The villains in this production (Three Ladies, Queen of the Night and Monostatos) were a bit anachronistic to the 18th-century setting, being dressed in unusual BDSM outfits of metal studded leather corsets, whips, shiny knee-high leather boots, and leather trench coats. Monostatos in particular was dressed in black leather and a turban. Perhaps not the most appropriate choice for a villainous character who's mired with a very racist history. 

The ill-fated princess Pamina was played by soprano [Kirsten MacKinnon](/scene/people/kirsten-mackinnon/), who was by far and away the standout of the entire show. Vocally breathtaking, with phenomenal control, she would effortlessly float high notes above the orchestra, and then tackle larger passages with incredible vocal strength and size. An absolute force of nature who brought the house down. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1698325681/VO_The_Magic_Flute_-_Audrey_Luna_as_The_Queen_of_the_Night_with_Kirsten_MacKinnon_-_Emily_Cooper_Photography.jpg){{% /md %}}

<figcaption>Audrey Luna (Queen of the Night) and Kirsten  in Vancouver Opera's production of The Magic Flute, 2023. Photo: Emily Cooper Photography.</figcaption>  
</figure>

The Three Spirits Audrey Gao, Vasilisa Kvitka Velasquez Kuzyk and Sara Hadjuk were absolutely lovely. Another section of opera that is difficult to blend well, especially from such young singers, these three were precise, lovely, and their presence on wheeled horse toys was charming.

A special mention needs to go to some of the smaller roles -- the two Priests played by baritone Alan Corbishley and tenor Martin Renner Wallace, as well as the two Armed Men played by tenor Sergio Augusto and baritone Henry Chen -- were phenomenal, vocally brilliant and with great stage presence. It is wonderful that VO has cast so many local singers in this production, and they have truly impressed everyone with their exceptional talent. Their addition has brought a new level of excitement and brilliance to the performances, and we can't wait to see and hear more from them in leading roles. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1698325682/VO_The_Magic_Flute_-_Kirsten_MacKinnon-Clarence_Frazer-Roger_Honeywell_-_Emily_Cooper_Photography.jpg){{% /md %}}

<figcaption>Clarence Frazer (Papageno), Roger Honeywell (Monostatos), and Kirsten MacKinnon (Pamina) in Vancouver Opera's production of The Magic Flute, 2023. Photo: Emily Cooper Photography.</figcaption>  
</figure>

In addition to the unusual costuming choices, there were some unusual directorial choices that made it confusing if the "play within a play" was still taking place, whether it was happening in the past, or modern day. The trials by fire were painted fires surrounded by actors in bright orange glitter capes, which the pair walked through, then blue glitter dresses for the trial by water, with giant umbrellas covered with glitter streamers. In addition, long after the wooden stage disappeared, actors were removing their costumes onstage, or participating in the action of the show with their original 18th-century dress. The production seemed to need some element to unify the modern and period elements that never came.

Nevertheless, the period elements were spectacular. The wooden stage operated by crank flies, the painted scenery, the painted doors, and even an exact replica Queen of the Night backdrop from the 1815 production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1698326851/VO_The_Magic_Flute_-_Owen_McCausland_-_Emily_Cooper_Photography.jpg){{% /md %}}

<figcaption>Owen McCausland (Tamino, centre) in Vancouver Opera's production of The Magic Flute, 2023. Photo: Emily Cooper Photography.</figcaption>  
</figure>

The VO Orchestra, under the direction of Tania Miller was excellent. Especially the principal flautist Brenda Fedoruk, who added a lot of flair and colour to the magical flute's solos, including an adorable Easter Egg of _Eine kleine Nachtmusik_! Very charming and fun!
