+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-05-15T18:30:00+01:00"
lastmod = "2016-05-16T13:00:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463346845215/2016-05-16---AtG-Cozy-Darryl-Block.jpg.jpg"
primary_image_credit = "Cairan Ryan as Don L. Fonzo in Against the Grain Theatre's A Little Too Cozy. Photo: Darryl Block."
publishDate = "2016-05-16T11:04:00+01:00"
related_articles = ["articles/from-don-juan-to-unclejohn.md","articles/aria-umezawa-opera-5s-die-fledermaus-with-surprises.md","articles/the-future-of-opera-is-indie.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/opera-5.md"]
related_people = ["scene/people/joel-ivany.md","scene/people/aria-umezawa.md"]
short_description = "Does this point to a subtle, non-malicious, yet inherent slight towards libretti, and by extension, librettists? If opera is the spectacular melding of music and text, why does the former seem more sacred than the latter? And finally, is an updated libretto to the tune of un-updated music a fundamentally incomplete idea?"
slug = "updating-operas-why-stop-at-the-libretto"
title = "Updating operas: why stop at the libretto?"
+++

[Against the Grain Theatre](/scene/companies/against-the-grain-theatre/) has earned itself some more great press, following the opening of their *A Little Too Cozy*. It's based on Mozart's *Così fan tutte*, the third of Artistic Director [Joel Ivany](/scene/people/joel-ivany/)'s "transladaptations" of the Mozart/Da Ponte operas, which means that he rewrote the libretto into an English version of the original story and set it in the present day.

People have been translating opera libretti for as long as the operas have been around, and in recent decades, it's become a refreshing practice to take translation one step further, and to update the stories as well. Ivany isn't the only one playing with old texts; [Aria Umezawa](/scene/people/aria-umezawa/) of [Opera 5](/scene/companies/opera-5/) is set to unveil her new libretto and script for [*Die Fledermaus*](/aria-umezawa-opera-5s-die-fledermaus-with-surprises/), to go with a contemporary take on another of opera's go-to classics. "No one says 'if you please, Madame, my poor aunt is terribly ill' anymore," [she says](/aria-umezawa-opera-5s-die-fledermaus-with-surprises/) of Adele's famous fake excuse to get out of work and go to a great party instead. 

With the latest round of discussion about updating the weird and often century-specific stories found in our favourite operas ([what's a factotum, anyway?](http://store.schmopera.com/collections/hoodies/products/what-the-is-a-factotum-hoodie)), a vague, recurring question has reared its head in a more concrete way. Would opera circles be as warm and inspired if instead of just updating the words, they got creative with the music, too?lan

When Italian or German become English, it's no small change to the original version of the opera. The rhythm and meter of the music, the inflection of various words, even the choice of beautiful vowels placed strategically on beautiful notes - almost none of it can withstand the process of text translation. It's hard to argue that there's a sliding scale of "accuracy" when a libretto is translated, especially into English. Frankly, it's a black-and-white issue; a translation that honours the time and location of the original story does as much musical "damage" as a text that's also updated. All bets are off as soon as the language is changed, and perhaps that's part of why audiences warm so easily to contemporary tellings of these stories.

It's not uncommon to scale down orchestration from 60 players to 5 or 10, and even that can be a point of contention for the more hardcore fans of big, famous operas. But the possibility of altering the music to the same degree as the text seems so taboo that it's not even discussed in the planning stages of a "transladaptation"-type production. Perhaps the musical equivalent of translating and updating an opera libretto is a complete and total change in orchestration. If Don Giovanni's little black book of conquered women can become an iPad showing "Uncle John's" very active Tinder account, why can't an orchestra of violins and flutes become a band of electric guitars and drumkits?

It's a fair prediction that opera fans who hear *La bohème* reimagined by a DJ, or *Die Fledermaus* played by a Hammond organ, would be outraged. If "outraged" is too strong a word, then "miffed" might do better. Or what if the music were largely re-written, which is exactly what happens when a libretto is updated? The bones of the original story may stay intact, but the details are entirely different. What if the familiar melodies of *The Magic Flute* or *Don Giovanni* stayed intact, but the underlying harmonies were messed with, in the name of being consistent with updating an opera? Wouldn't a few Jason-Robert-Brown-inspired chords add some contemporary sounds to the very 18th-century sounds of Mozart?

The double standard is funny. Great operas are entirely inspired by the text; Da Ponte was Mozart's source material, yet making huge alterations to his carefully crafted words is much easier for opera folks to swallow than messing with Mozart's music.

Does this point to a subtle, non-malicious, yet inherent slight towards libretti, and by extension, librettists? If opera is the spectacular melding of music and text, why does the former seem more sacred than the latter? And finally, is an updated libretto to the tune of un-updated music a fundamentally incomplete idea? Do all these questions suggest that shows like *Rent* and *Miss Saigon* are the more organic contemporary versions of *La bohème* and *Madama Butterfly*?

We say this all with trepidation; the music of Verdi and Puccini and Handel really is spectacular, and there are elements of their operas that really are timeless. We're not necessarily sold on the idea of hearing jazzed-up Mozart or popified Donizetti; at least, not until we get a taste of the experiment. 

And really, if someone hears the tune of "Per pietà" sung to some words they can get behind, in a language they understand without looking up to a surtitle box, perhaps it's the perfect stepping stone between a listener's assuming that opera is inaccessible and unentertaining, and their sudden interest in seeing a *Così fan tutte* set in the 18th century.
