+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = 2020-08-24T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Alex Ho's _Untold_ is available for [online viewing](https://youtu.be/OOqLBSu4Rc4) until 1 September. To support Tangram, the suggested donation is £5."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1598312986/media/2020/08/sqUntold_qz3rpf.jpg"
primary_image_credit = "Alex Ho's opera Untold, photographed by Zen Grisdale. "
related_articles = []
related_companies = []
related_people = ["scene/people/keith-pun.md"]
short_description = "This was a piece that did not feel as though it existed musically as a complete score but more so in the gathering of people together, in the physicality of the performance space, and in the unknowable magic that occurs in the moment of performance itself."
slug = "untold-a-collaborative-tale-of-pride-and-grace"
title = "Untold: a collaborative tale of pride and grace"
youtube_url = ""

+++
This week I had the privilege of watching a live stream event featuring composer Alex Ho's newest "Anti-opera", [_Untold_](https://youtu.be/OOqLBSu4Rc4), which is the latest output from [Tangram](https://www.tangramsound.com/ye-xian-a-story-untold.html), a newly formed artist collective whose aim is to celebrate Chinese culture through the performance of both Chinese and Western music while highlighting issues of transnational Chinese identity.

"Anti-opera" in that, though it included all of the main components of traditional opera – voice, text, music, dance, and theatre – these were subverted to create something that remained purposefully nebulous, refusing to be slotted into any one genre.

The piece was co-directed by Alex Ho and Julia Cheng, who also choreographed and performed the main role of Ye Xian. It was initially performed and recorded in November 2019 at Hackney Round Chapel, an ideal venue for this unlikely tale; told in the round, the action swirls endlessly around a centre point on stage. The performers made use of all available space with the instruments placed at the very edges of the performance space and the performers weaving through the audience in and out of the central space. The staging of this piece had a very organic flow to it which gave the impression it was being created before our eyes though undoubtedly, it was very thoroughly rehearsed. It is this spontaneity or at least, the impression of spontaneity that makes live theatre so exciting to watch.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1598313290/media/2020/08/Untold-1_bt6coj.jpg){{% /md %}}

<figcaption>Alex Ho's opera Untold, photographed by Zen Grisdale.</figcaption>

</figure>

_Untold_ featured a small ensemble with each performer pulling double duty. Countertenor [Keith Pun](/scene/people/keith-pun/) played the roles of the Fish and the King, Daniel Shao was on flute, Reylon Yount on Yangqin, and Beibei Wang was on percussion. In addition to playing their instruments, Shao, Yount, and Wang also stepped into the roles of the two stepbrothers and stepmother, respectively. This required the instrumentalists to move seamlessly from their instruments to the stage to dance their roles, as they took on their various characters in what felt like the true spirit of collaboration and teamwork.

Slippery and fragmented, this piece kept the audience in its grasp as the story unfolded bit by bit. The story, in essence, is the fairy-tale of _Cinderella_, though it differs quite a bit from the version we have come to know and love in the West, and actually predates it by about eight-hundred years. Set in the 9th-century Tang Dynasty, the tale recounts the story of Ye Xian, who lives a life of servitude to her stepfamily. She is beautifully transformed out of her poverty by the spirit of a fish she had befriended, which allows her to attend the yearly courting festival. There in her disguise, she meets the King, who becomes enamoured with her. When she departs in haste, leaving a golden shoe behind, he searches endlessly for the woman who fits the shoe, but she is never heard from again.

> Pun has a haunting and rich sound, and he made use of his entire register with seeming ease.

Interspersed between the telling of this story, which is first narrated by each of the performers in turn and then enacted through dance, are miniature stories from the performers who each share an experience concerning Chinese identity. These moments were heartfelt, honest, and woven together seamlessly with the action of the piece. The performers were not acting, but connecting with their audience in a very real way. Instead of finding this format jarring and taking me out of the action, I quite enjoyed its deconstructionist take on the traditionally formatted opera or theatre piece. Storytelling is the most ancient of artforms. It is shared across all cultures on the planet and resonates with us all in a very deep way. It was used in a very effective way within this piece.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1598313279/media/2020/08/Untold-2_uxhoct.jpg){{% /md %}}

<figcaption>Alex Ho's opera Untold, photographed by Richard Moore.</figcaption>

</figure>

Strangely and quite excitingly, this was a piece that did not feel as though it existed musically as a complete score but more so in the gathering of people together, in the physicality of the performance space, and in the unknowable magic that occurs in the moment of performance itself.

Because of this, the music did not necessarily feel like the most important aspect of the piece, and instead was one small part of a greater whole. The colours of the Eastern instruments blended with the Western created a rich tapestry, in which each instrument was given its own solo opportunities as they each took on a distinctive character, and therefore a crucial role in the storytelling.

> It was the sharing of a story that was told quietly and unobtrusively with pride and grace.

The majority of the singing was done by counter tenor Keith Pun, who had a lengthy aria in his role as the King where he searches for his beloved Ye Xian. Pun has a haunting and rich sound, and he made use of his entire register with seeming ease. He delivered an expressive and moving performance. Though minimal, the text was not always clear throughout, though it didn’t really feel necessary as the true storytelling was in beautiful fluid movements of the performers. That being said, I would have liked to see more control within the movements and more specificity in the expressions for clarity of narrative. Dance, however, is a beautifully expressive artform and paired with singing that matches gesture, it allowed for the emotions of the characters to be felt more deeply.

The overall feeling in this piece was one of welcome, of invitation and of celebration. It was an opportunity for a window into a culture that is not my own. It was the sharing of a story that was told quietly and unobtrusively with pride and grace.