+++
author = ["authors/michael-zarathuscook.md"]
categories = "Review"
date = "2018-11-24T11:54:00-05:00"
lastmod = "2018-11-24T12:25:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543078379541/sqBOUND510.jpg.jpg"
primary_image_credit = "Miriam Khalil in BOUND v. 2, Against the Grain Theatre, 2018. Photo: Darryl Block Photography."
publishDate = "2018-11-24T11:54:00-05:00"
related_articles = ["articles/atgbound-a-shocking-immediate-connection.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md"]
related_people = ["scene/people/miriam-khalil.md","scene/people/andrew-haji.md","scene/people/david-trudgen.md","scene/people/christopher-mokrzewski.md","scene/people/joel-ivany.md","scene/people/justin-welsh.md"]
short_description = "Kevin Lau&#039;s reconstruction of a variety of extracts from Handel&#039;s vast catalog of compositions struck a tottering balance between showcasing one of the most celebrated composers of the classical repertoire in its original form — and enticing a modern audience with the experimental synth-tracks, glitches and contortions available to the digital soundscape."
slug = "unraveling-bound-v2-second-time-is-also-a-charm"
title = "Unraveling BOUND v.2: Second time is (also) a charm"
+++

"I think opera is sexy now" — was the tail-end of the response I got from a friend who I had invited to see *BOUND v.2* (on Nov. 20th) but her schedule wouldn't let. What she really meant: I'm just realizing now that opera can be new and exciting, challenging, at the very edge of the envelope of artistic exploration on stage, unpredictable, cathartic even, politically informed and in certain instances, politically active — though I think prefer her choice of words. 

And I think she would have enjoyed, for some of those reasons, *BOUND v.2*  the latest project by Against the Grain Theatre staged at The Great Hall, from November 19th-21st. It was the second instalment in a three-year workshop/development project — albeit, from the individual performances by the four singers to the vibrant urgency of the chamber orchestra (conducted boisterously by Topher Mokrzewski) this was a production that felt very much at the height of its creative development. 

Kevin Lau's reconstruction of a variety of extracts from Handel's vast catalog of compositions struck a tottering balance between showcasing one of the most celebrated composers of the classical repertoire in its original form — and enticing a modern audience with the experimental synth-tracks, glitches and contortions available to the digital soundscape. Sound designer Acote's integration of digital and acoustic sounds and Martha Burns' voice-overs are as well commendable. Ultimately it was around the orchestra that my attention was anchored to the most; the orchestration was unpredictable all throughout: not only in anticipation of "where Handel ends and Lau begins" (according to librettist Joel Ivany) but whether the orchestra will take up the cause of the distraught detainee with a gentle and sympathetic accompaniment or strike the mock-heroic pose of the domineering State with the caterwaul of sound that occasionally erupted from the percussion section (a multivarious bag of tricks under the control of Nikki Joshi). 

New and exciting, yes. Challenging, somewhat. Pushing the envelope of the kind of characters and questions of identity that we are used to seeing on the operatic stage: absolutely. In the slice of silence between the Topher's final gesture and the splatter of applause from a standing ovation, I found myself cheering silently: More! much more of that — and I suspect that to be the majority sentiment echoing through Longboat Hall. And there will indeed be more when *BOUND v.3* is staged sometime next year. There is of course room for growth — that is the creative concept being explored here — but much of that growth will hopefully be in the scope of production as much as creative content. 

<figure data-type=image>
![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543078390466/BOUND134.jpg.jpg)
<figcaption>(l-r) Andrew Haji, Miriam Khalil, Topher Mokrzewski, Justin Welsh, and David Trudgen in *BOUND v.2*, Against the Grain Theatre, 2018. Photo: Darryl Block Photography.</figcaption>
</figure>

## Politics…OH! NO!

Political activism is often an easy fruit on a low hanging branch when it comes to designating the moral content of a production — and *BOUND v.2* leaps above that low bar with the eerie anonymity and all-pervasive presence of an apolitical entity referred to as "The State". The performance began right from the moment you walked through the doors, I was greeted by an usher with "Welcome to The State" — and perhaps was too dumbfounded to retort with anything more than "brilliant stuff, thank you" as I took from her a program that was designed like a passport (the creative brainchild of editorial manager Amanda Hadi and graphic designer Eitan Zohar). As there was no political party or country to identify as The State, the production rose above the ranks of mere current events. Which it needs to in order to maintain cohesion throughout its three-year production arc. The libretto was nevertheless pertinent to the more disconcerting headlines of our current events: the forgone policy of separating migrant families and false reports of "incoming hordes of caravans" by the current American president, to name a few. One couldn't get away either with dismissing these stories as yet another critique of American politics alone. The story of Noor Haddad (sung with an impassionately intimate soprano by Miriam Khalil), a journalist detained in France for refusing to remove her hijab is not the image of France being actively advertised by the current French president — whose efforts just earned his country the top spot on Monocle Magazine's Soft Power rankings. 

Much of the rise of nationalistic sentiments across Europe and North America can be attributed to what many view as an attempt to rescue what is left of the concept of the nation state, with its stringent and discriminating immigration policies, and its divisive rhetoric fueled by suspicion and insecurities of the majority demographic. Each of the characters in *BOUND v.2* is a case study of real life victims of legislated paranoia. None of them pose a credible threat to The State, but all of their reasons for detention have a basis for legal justification by The State. With no credible legal resistance, these characters resort to protest via lamentative arias, each one sung with the same fervent resolution as a defendant's final plea in a courtroom.

<figure data-type=image>
![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543078397294/BOUND163.jpg.jpg)
<figcaption>Andrew Haji in *BOUND v.2*, Against the Grain Theatre, 2018. Photo: Darryl Block Photography.</figcaption>
</figure>

## A self-assured countertenor

"This is not society<br>
Will you treat me <br>
as a person." - Naveen Dewan, *BOUND v.2*

Naveen Dewan (tenor, Andrew Haji), is a doctor from India being detained on account of suspicions regarding the nature of this stay in America. His words were the first in the production and Haji's resonating tenor was a point of reference for the rest of the evening. His tone was measured and his supplications modests, in contrast to his counterpart, Kelly Davidson, at the other end of the stage. Davidson is a transgender man detained for failure to identify as the registered gender on his government papers, and was sung by countertenor David Trudgen whose acting performance was the strong arm of the show. He was in character from the moment he descended the stairs to take his seat at the far right of the stage and stayed therein till the aforementioned standing ovation. His brows were furrowed and contorted throughout, tugging at our attention with his restlessness and nervous fidgeting. There was a brief moment of readjustment needed on the audience's part after his first few notes, readjusting to hearing the countertenor used seriously — not as an alias or disguised identity but as a self-assured and valiantly transgender man. A sensitivity coach was employed from the 519 LGBTQ organization to help sharpen the accuracy of Trudgen's portrayal, a dedication to fair-representation which made his performance all the more believable. 

"I've been through everything!<br>
You can't define me!" - Kelly Davidson, *BOUND v.2*<br>

The libretto for the arias sung by Noor Haddad and Ahmed Habib's (a born-again Muslim, sung by baritone Justin Welsh) paled in comparison to those of Kelly Davidson and Naveen Dewan, and to the talents of Khalil and Welsh. Khalil's high points were found in the hair-raising union of the quartet singing together and when she sang briefly in Arabic—moments that do little to investigate the complexities of her character. The same can be said for Habib, whose baritone gave the quartet its volume and girth in its more impassioned moments, but the libretto of his arias were mostly one-dimensional confessions of faith. 

<figure data-type=image>
![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543078404288/BOUND620.jpg.jpg)
<figcaption>David Trudgen in *BOUND v.2*, Against the Grain Theatre, 2018. Photo: Darryl Block Photography.</figcaption>
</figure>

## In need of a bigger stage

—and a larger stage. Looking forward to *BOUND v.3*, production size is perhaps the biggest opportunity for growth. In a larger auditorium, on a larger stage, this production won't have to rely so much on its offstage gimmicks, that extended as far out as the posters on the bathroom stalls, to establish the atmosphere of its setting. The four characters are within arms-length of each other, a proximity which proves taxing on the imagination of the audience in order to see them as individuals in isolated detention. Despite the orchestra's vivid and cohesive performance, a larger wind (1: flute, oboe, bassoon and clarinet) and string (2 violins, viola, cello and double bass) section would have better incorporated the thunderous and at times awkward interjections from Joshi's busy percussive instruments. Jennifer Murphy was outstanding on violin, her performance emphasized the intimacy of the venue, and the orchestration would have been the better for writing a couple mini-cadenzas for her and the viola (Brenna Hardy-Kavanagh). A larger orchestra might also replace the piano recordings that accompanied some of Khalil and Haji's arias — it is always an awkward thing to watch so capable an orchestra sit silently still, listening to a recording. Transferring the content of that recording — vestigial fragments of piano accompaniments from *BOUND v.1* — to the principal violin would have been an opportunity to underscore the diegetic specialty of the orchestra. 

I spoke briefly with Joel Ivany (librettist and artistic director) after the show and he seemed fairly open to the suggestion of two more installations to the *BOUND* series. As the idea for the project was born in part as a consolation to the unexpected results of the American presidential election in November 2016, it might be just the perfect cadential conclusion to the series if it wrapped up in the last year of this president's administration. One more production in 2020 might also allow for an opportunity to find a bigger stage and orchestra that can make the most of this opera's depth of expression.

<figure data-type=image>
![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543078410719/BOUND659.jpg.jpg)
<figcaption>Justin Welsh in *BOUND v.2*, Against the Grain Theatre, 2018. Photo: Darryl Block Photography.</figcaption>
</figure>

## In summa summarum

When it comes to the expression of the intensities of emotion by the human voice, there is no artform more convincing than opera. Productions like *BOUND v.2* are vital for the introduction of the incomparable capacities of this artform to a new generation. Its combination of the old and new and eccentric (featuring an African talking drum, for example!) is the kind of reminder we need that opera is still evolving, capable of expressing the evermore complex and fragmented identities of our modernity, whilst showcasing the exhilarating virtuosic flourishes which the artform has honed for centuries. I'm coming around to agreeing with my no-show friend, opera is sexy — or in this case, new and exciting.
