+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-01-18T19:27:14+00:00"
disclaimer = ""
image_gallery = []
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1547839289/media/2019/01/sqIbis4.jpg"
primary_image_credit = "Scott Ballantine and Britt Brown in The Scarlet Ibis, Boston Opera Collaborative, 2019. Photo: Dan Busler."
related_articles = ["articles/varied-opera-bites-delivers-interesting-delectable-morsels.md", "articles/intimate-brewery-room-la-bohme-a-revelatory-triumph.md"]
related_companies = ["scene/companies/boston-opera-collaborative.md"]
related_people = ["scene/people/scott-ballantine.md", "scene/people/britt-brown.md", "scene/people/ann-fogler.md"]
short_description = "Unfortunately, Weisman's score does not always meet the standard that Cote sets. The issue is that Weisman's music is often relatively one-note if something of little dramatic import is going on."
slug = "uneven-scarlet-ibis-meditative-to-a-fault"
title = "Uneven Scarlet Ibis Meditative To A Fault"
youtube_url = ""

+++
One adage that is frequently stated in the world of opera is that all opera lives and dies on the strength of its libretto: after all, you can have the best music in the world and it will not matter if it does not support a libretto that lacks dramatic direction and characterization. It is rare that one finds the opposite problem where a strong libretto is serviced by middling music, after all, but when one does find this situation it can be a little bit of a bummer.

> The climactic thunderstorm scene's music is nothing short of spectacular once it finally gets going.

Thus, we turn to the Boston Opera Collaborative’s production of Stefan Weisman and David Cote's _The Scarlet Ibis_, a curious little opera based on James Hurst's widely-read short story about a boy and the younger brother he tries against all hope to make "normal". David Cote's libretto actually does an incredibly admirable job of adapting the story into opera: it is home to some of the strongest characterizations I've seen in recent opera, particularly in the two young boys at the heart of its story. The main character (simply titled "Brother" in the program) is a believably bratty young child, his relationship with his younger brother "Doodle" is beautifully set up, and the whole work is brimming with pathos and a warmth that only makes the story's tragic finale all the more heartbreaking. Overall, Cote does a wonderful job of giving composer Stefan Weisman a lot to work with in terms of setting this story to music.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547839783/media/2019/01/Ibis1.jpg){{% /md %}}

<figcaption>Scott Ballantine, Lucas Coura, and Ann Fogler in The Scarlet Ibis, Boston Opera Collaborative, 2019. Photo: Dan Busler.</figcaption>

</figure>

Unfortunately, Weisman's score does not always meet the standard that Cote sets. The issue is that Weisman's music is often relatively one-note if something of little dramatic import is going on. Perhaps the worst of this comes with Doodle's frequent soliloquizing in the second act: Doodle gets no less than three arias in this part of the show, and by the time we got to the third aria (sung right before the thunderstorm that ends the story) I found myself wondering when the show would move on to its denouement. The music also has a tendency to linger on relatively unimportant moments, such as at the top of the show when Brother, his father, and his aunt are all telling the mother to push as she is giving birth to Doodle: moments like that dragged on for far too long musically.

> The performance, at least, was top-notch from all the singers there.

This is a real shame, because when Weisman does get to the dramatically important moments, he shows that he can really deliver the drama, and these moments are all too plentiful to count. The moment when Brother first sees Doodle smiling is met with a quiet sense of wonder before erupting in unbridled joy. The moment when Brother manages to get Doodle to stand is incredibly triumphant on a musical level. The music manages to beautifully portray the joy on the adults' faces upon seeing Doodle walk. The climactic thunderstorm scene's music is nothing short of spectacular once it finally gets going, and Doodle's subsequent death and Brother's discovery of Doodle's body was handled in such a way that, while not exactly what I expected, fit the moment beautifully.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547839815/media/2019/01/Ibis2.jpg){{% /md %}}

<figcaption>Lucas Coura and Ann Fogler in The Scarlet Ibis, Boston Opera Collaborative, 2019. Photo: Dan Busler.</figcaption>

</figure>

But alas, the moments in the score that do work do kind of stand out like a sore thumb when compared to the grey morass of uniform sound worlds that some of the show's less dramatic moments inhabit. Perhaps a revision or two could have helped this tendency of the opera: as it is, some of the quieter moments seem to fall into the trap of being too boring.

> However, I am certain there is still a future for this odd aria: the moments of _The Scarlet Ibis_ that work are absolutely stunning, and the ending is nothing short of heartbreaking at the end of the day.

Of course, one can paper over such issues with clever staging, but alas, director Greg Smucker seems saddled with some decisions that did not entirely work out. For example, the opera opts to portray Doodle with a puppet handled by many of the people on stage. I am not entirely certain this was successful: he was primarily operated by the countertenor that played him, but occasionally some of the staging necessitated that he have the assistance of one of the other singers. This is certainly fair enough, but it did take me out of the moment when the singer playing the Father had to step in when it came time for the puppet to stand on his own two feet, and it really took me out of the moment considering that in the very next scene the father had to act surprised. Was the father really there? Or was he just there as a matter of practicality?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547839851/media/2019/01/Ibis3.jpg){{% /md %}}

<figcaption>Emily Harmon in The Scarlet Ibis, Boston Opera Collaborative, 2019. Photo: Dan Busler.</figcaption>

</figure>

It is difficult to say the show could have been done without the puppet, though, for the puppet had some really inventive staging surrounding it in Act II that could not be done with a human (especially not in Longy School of Music's concert hall!). For instance, Doodle has an aria in which he tells a lie where he has wings: the way the puppet flies around Brother lent a whimsy to the aria I think would have been lost otherwise. Additionally, the puppet was critical to the climactic tableau in which Ibis and Doodle became one in death, and the moment would not have been nearly as effective without the puppet. But, as with the music, this made the earlier, less effective uses of the puppet all the more noticeable: there perhaps is a way to work the puppet into the production more organically, but Smucker could not seem to find that way with the resources that he had.

The performance, at least, was top-notch from all the singers there. Of particular note, [Ann Fogler](/scene/people/ann-fogler/) truly stood out as the Brother: she conveyed the character's brattiness and desires in a way that played perfectly with how Cote paints the character, and her crystalline voice easily added to the character. Emily Harmon also provided a wonderful voice to Brother's superstitious Aunt: her tone color was perfect for the whole role, whether it be for her full hopeful use of the upper register, or the deep sounds of her low register for the more ominous parts of the role. [Scott Ballantine](/scene/people/scott-ballantine/) and [Britt Brown](/scene/people/britt-brown/) also made for warm parents just trying to do their best in a tough situation, providing warm characterization even if they did not get a ton to do. And of course, Lucas Coura's Doodle brought a pathos to the whole work, and his countertenor provided a child-like clarity to the world these characters inhabit. Now if only the chamber orchestra that accompanied them did not spend much of the work playing loudly enough that it drowned out the singers half the time (and especially poor Coura!)...

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1547839887/media/2019/01/Ibis5.jpg){{% /md %}}

<figcaption>Scott Ballantine, Lucas Coura, Britt Brown, and Ann Fogler in The Scarlet Ibis, Boston Opera Collaborative, 2019. Photo: Dan Busler.</figcaption>

</figure>

All of these issues ultimately added up to a night that was uneven and frequently felt slow and lumbering. A more consistent journey to the finish line would have made the show a much more satisfying watch: the overall effect of the show is merely good, when Cote's libretto likely could have put _Scarlet Ibis_ in a place as an undisputed classic of the operatic repertory. However, I am certain there is still a future for this odd aria: the moments of _The Scarlet Ibis_ that work are absolutely stunning, and the ending is nothing short of heartbreaking at the end of the day. And at the end of the day, Boston Opera Collaborative should be applauded for taking a chance on such a work, uneven as it is in the end.