+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-03-21T08:48:00-06:00"
lastmod = "2017-06-18T16:13:00-06:00"
preamble = "\"Why do I need to know set theory, or the history of Medieval polyphony, or Baroque dance notation, or Pythagorean tuning, or Schenkerian analysis, or whether or not Schubert was gay?\"\n\nMusicians aren't alone; with most professional disciplines that require a decent level of education, there's a chasm between what people learn in the classroom, and what they're asked to do in the workplace. Such is life. It's a mystery why some music students sigh and whinge over harmonic analysis assignments or piano skills assignment; the bored sounds often come with some quip about how they'd \"never use this outside of school\", because they'd heard that there was little demand for chord identification in the workplace.\n\nIt's true that \"school\", whatever that means to you, isn't for everyone. No formalized system of learning will fit all, and musicians perhaps have an advantage when it comes to examples of successful rebels of the education system. That's different than deeming a university course \"not practical\" or \"pointless\". It's a funny, bold thing to decide that you know that much about the topic, before finishing the course. Simply put, *you don't know what you don't know*.\n\nWe wanted to take the time to vouch for the value in some of the more irritating courses that are a part of most post-secondary music degrees:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1497823397269/2017-06-19---Music.jpg.jpg"
publishDate = "2016-03-22T03:45:00-06:00"
related_articles = ["articles/3-life-lessons-that-practice-rooms-can-teach-you.md","articles/3-ways-to-fight-boredom-at-the-opera.md","articles/nerding-out-why-you-should-definitely-care-what-key-your-aria-is-in.md"]
short_description = "It&#039;s true that &quot;school&quot;, whatever that means to you, isn&#039;t for everyone. No formalized system of learning will fit all, and musicians perhaps have an advantage when it comes to examples of successful rebels of the education system. That&#039;s different than deeming a university course &quot;not practical&quot; or &quot;pointless&quot;. It&#039;s a funny, bold thing to decide that you know that much about the topic, before finishing the course. Simply put, you don&#039;t know what you don&#039;t know."
slug = "undergrad-degrees-why-youll-use-that-theory-class-after-all"
title = "Undergrad degrees &amp; why you&#039;ll use that theory class after all"
+++

## Theory & analysis

Ah yes. Those classes that happen at 8am, twice a week, full of Bach and Roman numerals and homework assignments. Maybe it's difficult to make theory or analysis interesting, but young musicians, you all need to suck it up and pay attention. Why? Because when you have to memorize music quickly, or when your tuner says you're in tune but the rest of your quartet says you're flat, theory and analysis become valuable tools.

Pianists know this well; it's pretty tricky to memorize a Beethoven sonata or Chopin Nocturne as a singular strand of notes. The smart musician will start by figuring out musical form, then find patterns of harmonic progressions, and notice any digressions from said pattern. Whether you're dealing with Mozart or Webern, there are patterns to be found, and sitting through theory classes really is the fastest way of making sense of it all.

Theory and analysis can make sense of the small details, as well as the large. The difference between a major and minor triad is enormous, and the smart musician knows how it affects intonation and even phrasing. Dissonances, resolved moments of tension, 12-tone sets in retrograde; if these details are lost on the player, they're definitely lost on the listener. 

Courses like ear training skills are worthwhile, too; for singers in particular, it's a handy skill to be able to hear a melody once and sing it back correctly. Classes like these prepare singers for taking notes from a conductor, or being given certain cadenza or set of ornamentation. These kinds of things really do happen in the rehearsal room, and being able to repeat and memorize things by ear is a professional must-have skill.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458592288531/2016-03-21---BrahmsBeethoven.jpg.jpg)<figcaption>See that look on Brahms' face? Find out what it means in your Music History class.</figcaption>
</figure>

## History

Knowing your Second Viennese School from your Council of Trent isn't about building the skills to write programme notes that rival encyclopedias; it's about making all of this music mean something. It's an extraordinary thing to know that Mozart had bosses that had some control over what he wrote, or that Schumann named his multiple personalities, or that Messaien was a hardcore Catholic who lost his wife in the most horrific of ways. These bits of trivia are akin to knowing about Kurt Cobain's depression, or that Freddie Mercury died of complications related to AIDS. Especially when it comes to the best music-makers of any age, their lives and their work are hopelessly entwined. One can appreciate *Le nozze di Figaro* and *Bohemian Rhapsody* in an objective way, but if you're going to play or sing these pieces of music, it's almost incomplete to do so without thinking of authority figures who stifle the lower classes, and diseases that were physically and socially fatal.

Brahms wrote *Ein deutsches Requiem* not too long after Clara Schumann died. Messaien's *Poèmes pour Mi* reference the nickname he had for his ill wife. When Mozart was alive, Vienna was mental for all things Turkish. These facts make human beings of the greatest composers, and if your heart didn't already break at their music's beauty, their biographies will seal the deal.

Yes, your music history classes won't be an endless stream of interesting factoids, but they're the quickest route to real passion and interest in the works.

## Your non-music classes

Whether it's part of your minor, or it's a completely elective time-filler, non-music classes can be the best part of your degree. English literature, arts administration, conversational German, all of them are great to study because they add some variety to the constant focus on music alone. It's healthy to get out of the music building, join a class of unfamiliar faces, and talk about something else, work with a new set of values.

Music students can become insular; it's not a bad thing, it's a result of a small faculty, filled with people of the same age group, who share a big passion. In the professional world, it's often the case that the best, happiest artists are those with varied interests. Making friends who aren't musicians, hours spent doing something different, they're important to the big picture of the career you're pursuing. It can be easy to zero in on mastering one's instrument, but music isn't created in a vacuum; it's connected to language, literature, science, all these extra-musical subjects that are available the post-secondary student.

>What do you remember from your music-school years, and why is it valuable to you today? Let us know the comments below!
