+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2018-04-27T16:18:00-04:00"
lastmod = "2018-04-27T16:18:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524859651430/sqRebeccaB.jpg.jpg"
primary_image_credit = "Photo: Lottie Bowater."
publishDate = "2018-04-27T16:18:00-04:00"
related_articles = ["articles/lore-lixenberg-is-the-mother.md","articles/6-new-works-presented-at-various-stages-2017.md"]
related_companies = ["scene/companies/mahogany-opera-group.md"]
related_people = ["scene/people/frederic-wakewalker.md"]
short_description = "I would place Merz and Osborn&#039;s opera somewhere in the middle of absurdist and literalist. They attempt to explore the psychological relationship of mother and son through repetitive material and an assertive musical language."
slug = "uncomfortable-premieres-the-mother"
title = "Uncomfortable premieres: The Mother"
+++

This week saw the world premiere of *The Mother*, an opera commissioned by [Mahogany Opera Group](/scene/people/mahogany-opera-group/) with music by Laurence Osborn and text by Theo Merz. Set in a small town in 1920s Poland, The Mother wastes away the days knitting, drinking, and taking morphine while providing for her son, Leon, who dreams of becoming a radical philosopher. After he gives a lecture that sparks riot in his local theatre, Leon must pay for damages he caused, and relies upon his mother to do so. Later in the opera, Leon becomes a pimp - he is joined by a high class escort and two noblemen who introduce Leon and his mother to cocaine. His mother dies, and all that's left in the opera is an epilogue in the form of a dream sequence.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524860281835/GasmaskA.jpg.jpg)
<figcaption>Photo: Lottie Bowater.</figcaption>
</figure>

The text, Merz's adaptation of the original play of S.I. Witkiewicz, is straightforward enough. As there isn't really a narrative or plot line, the opera mostly concerns itself with the relationship of Leon with his mother. Merz and Osborn remained exceedingly faithful to Witkiewicz's dramatic theory of "Pure Form," wherein a piece of theatre defies logic and reality in order to create a spontaneous and metaphysical experience for the audience.

I would place Merz and Osborn's opera somewhere in the middle of absurdist and literalist. They attempt to explore the psychological relationship of mother and son through repetitive material and an assertive musical language. The actual tone music was very consistent throughout the entire piece, and personally I thought it lacked depth in terms of dynamic interest, especially in the first act. Osborn writes well for singers, making the text ring over a surprisingly dense orchestration, considering the small size of the ensemble.

A director's note from Frederic Wake-Walker remarks on opera, as a genre, being obsessed with death, as well as the mortality of this art form. Unfortunately this production seemed to highlight the death of funding for opera and contemporary music. Although the premiere of *The Mother* boasts a commission and grant funding from numerous foundations and trusts, the only thing I could think while watching this piece was how low the budget must have been to put on this one night. The result of this was something less than a finished product - watching performers dressed in all black awkwardly move about a messy stage didn't transport me into any world other than our own venue of the Polish Social and Cultural Association.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524860288749/woolA.jpg.jpg)
<figcaption>Photo: Lottie Bowater.</figcaption>
</figure>

Overall, there was good technical singing from the small cast, especially from Lore Lixenberg in the title role. But there was a looming sense of underpreparedness and lack of musical nuance that makes me not want to comment on the performers specifically. Jamie Man conducted a chamber orchestra with the expression of a parent's trying to wrangle six children into a car for a long journey.

Associate director Barbara Poll in her program notes writes that in Witkacy's works, there can only be permanent anxiety, indifference, and passivity. If this was truly the benchmark to which Mahogany Opera set itself, the show was a success. Writing that statement in a review for any other show would seem harsh, but it seems as though the goal of the creative team was to make the audience uncomfortable, and I, an audience member, felt extremely uncomfortable while watching this opera.
