+++
author = ["authors/jenna.md"]
date = "2014-12-17T14:00:00+00:00"
lastmod = "2016-11-28T10:11:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428961106430/uncle_john_by_brent_calis.jpg.jpg"
primary_image_credit = "Cameron McPhail in #UncleJohn. Photo by Brent Calis"
publishDate = "2014-12-17T14:00:00+00:00"
related_articles = ["articles/unclejohn-takes-ottawa.md"]
related_people = ["scene/people/miriam-khalil.md","scene/people/sharleen-joynt.md","scene/people/patrick-duwors.md"]
short_description = "I went to see opening night of Against the Grain Theatre&#039;s production of #UncleJohn, the re-imagination of Mozart&#039;s Don Giovanni by Joel Ivany. It was fantastic, but I&#039;m hardly the unbiased media figure I should be in order to offer up a true review."
slug = "unclejohn-the-toronto-story"
title = "#UncleJohn: the Toronto story"
+++


I went to see opening night of <a href="http://againstthegraintheatre.com/" target="_blank">Against the Grain Theatre</a>'s production of&nbsp;<em>#UncleJohn</em>, the re-imagination of Mozart's&nbsp;<em>Don Giovanni</em>&nbsp;by Joel Ivany. It was fantastic, but I'm hardly the unbiased media figure I should be in order to offer up a true review. <a href="http://atg.schmopera.com/" target="_blank">I joined the AtG team in Banff this summer</a>, as they collaborated with the Canadian Opera Company and Parks Canada to first present <em>#UncleJohn&nbsp;</em>at the Cave and Basin National Historic Site. The project was new for everyone, and the rehearsal room was a special place during that summer workshop. There were little details to iron out, both musical and dramatic, and so it was one of those stimulating processes of creative thinking and openness that most artists dream of.<p></p><p>Joel is all about the audience's experience, and that translates into unconventional venues&nbsp;(like outdoor spaces subject to rain, mosquitoes, and sulphur) and extraordinary&nbsp;demands on the mechanics of opera (like the&nbsp;<em>AtG Messiah</em> chorus performing from memory, or managing&nbsp;Mozart <em>recit</em>&nbsp;without any singer-conductor sight lines). The AtG creative team tends to work with&nbsp;a wild idea, and enough open minds around to try it out;&nbsp;the award-winning company&nbsp;has had full of successes from the beginning. All these unknown elements are hovering in the air throughout the whole rehearsal process, including the first performance, and no one really knows how they'll all settle.&nbsp;There's always a bit of alchemy that happens on AtG shows, in my own experience working with their team.&nbsp;<em>#UncleJohn</em> in Banff was an incredible mix of good energy amongst the team, green and responsive audiences, and an unforgettable venue. The reward for all that creative work was enormous.</p><p><span data-sc-tag="[caption id=&quot;attachment_2320&quot; align=&quot;aligncenter&quot; width=&quot;1498&quot;][/caption]" class="sc-node sc-node-caption"></span></p><p>For <em>#UncleJohn</em>&nbsp;in Toronto, I was around briefly during the rehearsal process (and of course, to get an <a href="/unclejohn-in-toronto/" target="_blank">interview with Joel and&nbsp;Miloš</a>), so the production wasn't entirely new to me when I saw it on Thursday night.&nbsp;I remember seeing real excitement and awe in the audience during the Banff shows, and it was neat to experience it for myself. I got to hear the effect of opera singers scattered around an open space,&nbsp;how different corners of the audience heard different sides to all the ensemble numbers, and how the cast seemed to like popping up behind you without warning (*cough, Leporello). I looked up with empathy at&nbsp;Miloš and the <a href="http://againstthegraintheatre.com/artists/542c0d5d0082a2f920000018" target="_blank">Cecilia Quartet</a>, hopelessly out of view of the singers, and marvelled at how the thing relentlessly held together. I know a good chunk&nbsp;of the cast well, especially in these roles; even so, there were things I had never seen before, and the novelty managed to outweigh any sense of "been there, done that".</p><p>What I heard between my brief time in rehearsal and opening night was on par with the&nbsp;amazing process that happens organically at Against the Grain. This <em>#UncleJohn&nbsp;</em>was as different as it could have, and should have been. The <a href="http://www.thegreathall.ca/" target="_blank">new venue</a>&nbsp;called for an entire re-design by Patrick DuWors (sets and costumes) and Jason Hand (lighting), and Joel made some changes in his libretto to fit Toronto audiences. But the coolest part was the cast. About half of the singers were new to this production, and just like the cast in Banff, they took on their roles&nbsp;as&nbsp;if they were versions of themselves. They were true to the dialogue and score (I know that much well), but they found something real about these <em>very</em> old characters.</p><p><span data-sc-tag="[caption id=&quot;attachment_2323&quot; align=&quot;aligncenter&quot; width=&quot;1500&quot;][/caption]" class="sc-node sc-node-caption"></span></p><p>It seems like an obvious result of hiring great artists to be in your show, but it's more special than that. I work with a lot of singers, and a truly organic performance is a hard achievement; they don't happen that often. But here, over just two productions of&nbsp;<em>#UncleJohn</em>, it had happened&nbsp;<em>twice</em>. That's a rare thing, you know. It's certainly a testament to Canadian artists, and to the audience-considerate approach of Against the Grain Theatre. I think it's also a testament to opera; that&nbsp;<em>Don Giovanni</em>, for example, can travel through transformations of language and orchestration and still move people.&nbsp;<em>#UncleJohn</em> shows us that opera is not dependent on large theatres or full orchestras, and that the best operas aren't even dependent on specificity of text.&nbsp;I think opera is dependent on its artists, specifically the ones that can deliver a meaningful performance without distance, ideal acoustics, and distractingly elaborate sets. Within less than a year, I saw two groups of singers&nbsp;collectively evolve this show and its people.&nbsp;If artists like these aren't so rare after all, perhaps the responsibility lies in the hands of the directors and conductors to step back and watch them.</p>
