+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2019-05-14T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1558456179/media/2019/05/sqTrovatore.jpg"
primary_image_credit = "Christopher Trapani (Manrico) and Leonora (Alexis Cregger) in Il trovatore, Regina Opera Company, 2019. Photo: Steven Pisano."
related_articles = []
related_companies = []
related_people = []
short_description = "Brooklyn-based Regina Opera has taken on Verdi's Il Trovatore and though they clearly have limited resources, they have staged a first-rate, fully-realized production."
slug = "two-different-servings-from-the-opera-fest-menu"
title = "Two different servings from the Opera Fest menu"
youtube_url = ""

+++
Some of the things that contribute to the enjoyment of 19th century opera includes the pageantry, the costumes, the scenery, etc.  But ultimately, it's the music that must be beyond question or what's the point of doing it at all? Both New Amsterdam Opera and Regina Opera Company understand this implicitly but have two completely different approaches to the music of two masters.

Brooklyn-based Regina Opera has taken on Verdi's _Il Trovatore_ and though they clearly have limited resources, they have staged a first-rate, fully-realized production.  Sandwiched in between _Rigoletto_ and _La Traviata_, _Il Trovatore_ is one of Verdi's most popular works, even though story-wise it's inferior to the other two titles. Most of the action takes place either in the past or offstage, and there is really no subplot. Everyone sings about what happened, and little is in the present-tense. It's a shallow tale about the revenge of the gypsies and it's all about "when," not "if."  The score, on the other hand, is unassailable; vintage Verdi containing some of his most stirring and recognizable melodies (such as "The Anvil Chorus.")

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557882405/media/2019/05/Trovatore-Marianna_Coleman10.jpg){{% /md %}}

<figcaption>Nathan Matticks (Count DiLuna) and Alexis Cregger (Leonora) in Il trovatore, Regina Opera Company, 2019. Photo: Marianna Coleman.

<figcaption></figcaption>

</figure>

Regina Opera has put its money where it counts most.  They've hired a 33-piece orchestra and they are "on the money" under the baton of Gregory Ortega. Most importantly, they've hired a tremendous cast of singers. Lara Michole Tillotson, as Azucena the gypsy, Nathan Matticks, as Count de Luna, and Christopher Trapani as Manrico, are flawless as they sing some of the most well-known arias in the entire opera repertory. There are a lot of performers who have taken on these roles, but this trio couldn’t be better. Ms. Tillotson is a tremendous actress with a soulful voice. Agony, fear, regret – it all comes bubbling up as she sings the uber-famous  "Stride la vampa." Likewise, Mr. Trapani is a tenor whose voice can soar up to the rafters – "Di quella pira" gives you chills as the curtain comes down in Act III. You can’t wait for Mr. Tillotson and Mr. Trapani to share their heart-breaking scene together in Act IV. Mr. Matticks is the perfect bad guy throughout – his stunning baritone voice conveying equal portions of lust and hatred. The chorus is small but they sound anything but, under the direction of chorusmaster Elizabeth Hastings.

Director Linda Lehr has employed simplicity in both her staging and set design, and it all works beautifully, servicing the singers rather than causing an obtuse distraction.  Using subtle colors and symbolism, the construction resembles the skeleton of a prison or cathedral, two important locations for the story. It’s also practical - changes are made quickly with the use of hinges or sliders, never interrupting the dramatic flow.

A world away from Brooklyn, on the Upper West Side of Manhattan, New Amsterdam Opera has made it clear that they have no interest in the theatrical side of opera. They present concert versions with no scenery, costumes or props. The singers, dressed in formal wear, with the women appropriately bejeweled, perform at music stands, with entrances and exits as the only stage movement. This format usually works with a program of excerpts, featuring scenes, arias or duets, and is difficult to pull off with an opera presented in its entirety.

But New Amsterdam unapologetically brings you entire operas, most recently the entire three hours of Massenet's _Herodiade_ – and with no subtitles. This is not the kind of presentation that would appeal to someone who has never been to an opera.  There is a long, detailed synopsis provided, but newbies to this artform should probably go to an opera with production values for their first experience.  While most opera companies are trying to bring in a wider audience, New Amsterdam seems to be aiming at those of us who are already opera lovers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1557882432/media/2019/05/Trovatore-CSmith4.jpg){{% /md %}}

<figcaption>Lara Tillotson (Azucena) in Il trovatore, Regina Opera Company, 2019. Photo: Cameron Smith.</figcaption>

</figure>

And oh, is there a lot to love - what a cast. _Herodiade_ was presented at the The Center at West Park (church), and in an intimate, acoustically-splendid space like this, one gets the rare chance to not only hear superlative music, but to actually be enveloped by it. Call it "Operatic Surround Sound." There were no special effects, but that was more than made up for by the vocal pyrotechnics.

French composer Jules Massenet, best known for _Werther_ and _Manon_, wrote over thirty operas, including _Herodiade_, a very different telling of the Salome story. Unlike the famous Salome by Richard Strauss, _Herodiade_ is not based on the Oscar Wilde play of the same name but on a novel by Gustave Flaubert.  There is no dance of the seven veils here and no lurid attraction to John the Baptist. In this one, John (or Jean) and Salome share a true love story. There are similarities - Herod does lust after Salome, and his wife Herodiade wants Jean's head, but she's motivated by revenge – Jean has denounced her publicly as a Jezebel.  She has, in fact, led a "wicked" life and has been unfaithful to Herod, resulting in the out-of-wedlock Salome (although Herodiade doesn’t know this until the final "it's too late" moment.)

Massenet's music is unrelenting.  There are no pianissimo windows where we see the inner thoughts of the characters. Arias might begin on a calm level but very quickly catapult into emotional high notes – and continue that way for three hours (with only one intermission.) Luckily, every voice in this production is glorious and up to the challenge.

As the title character, mezzo Janara Kellerman is every inch a queen, especially a queen who also moonlights as a diva. Her voice rumbles and soars in equal measures. As her husband, King Herode, baritone Jason Duika is the perfect counterpart - male versions of the same qualities. Soprano Marcy Stonikas, as Salome, is nothing short of a siren (as in the hypnotic, mythological sense of the word.)

But it's tenor Errin Duane Brooks (as Jean) who steals the show (after he stops it, numerous times.)  There was a danger – if only imagined – that he might actually damage the delicate plaster and stained-glass windows of the church with his volcanic high notes.

Bass-baritone Isaiah Musik-Ayala (as Phanuel) delivers a powerful aria to open the show and lends great support for the rest of the evening. Soprano Brooklyn Snow and baritone Charles Eaton also deserve mention for their excellence in two smaller roles.

None of this should indicate that the singers only used their voices. While restricted to their music stands, they were all very much "in the moment." The buried and then explosive fury of Ms. Kellerman, the repressed sexuality of Mr. Duika, the lovelorn Ms. Stonikas – it was all there in their faces. And Mr. Brooks conveyed the judgements of the holier-than-thou Jean with side glances that could wither a large tree.

Keith Chambers leads a sterling – no golden - 36-piece orchestra and the chorus is in fabulous form under the leadership of Mr. Chambers and Riley Burke.

One major production "oops": neither the name of composer Massenet nor the names of his librettists appear anywhere in the printed program. Credit where…well, you know the rest.