+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-03-27T17:11:00-04:00"
lastmod = "2018-03-27T21:33:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522185034632/sq---image%5B8%5D.jpg.jpg"
primary_image_credit = "Nathan Granner and Jamie Chamberlin in The Invention of Morel, Long Beach Opera, 2018. Photo: Kip Polakoff."
publishDate = "2018-03-27T17:11:00-04:00"
related_articles = ["articles/a-futuristic-love-story-the-invention-of-morel.md"]
short_description = "The percussionist inside Mr. Copeland finds the perfect places for the musical punctuation of xylophone, triangle, concert tom-toms, etc. And even though the tip-toeing steps of the bass and bassoon are heard throughout, it&#039;s the booming bass and bass drum that drive the drama, expressing the developing madness inside and outside the characters."
slug = "twice-on-this-island"
title = "Twice on This Island"
+++

Decades ago when Stewart Copeland was Sting's partner in the rock group The Police, you would not have predicted that his name would one day appear in an opera review.  But while Mr. Copeland has devoted much of his post-pop life to film scores, he's also worked on quite a bit of what some refer to as "serious" music. And his opera *The Invention of Morel* is seriously good. The Long Beach Opera company, which will celebrate its 40th anniversary next year, continues its long-time tradition of presenting works that speak to a contemporary audience. Known nationally and internationally for their "bold and unconventional repertory," Mr. Copeland's opera is no exception.

The score is heavy on bass and drums - no surprise considering the composer is a member of the Rock 'N' Roll Hall of Fame. This isn’t rock music, however - Mr.  Stewart's Police music was really a mix of rock and jazz, anyway. In *The Invention of Morel*, from the overture and throughout, Copeland makes references to the first half of the 20th century - his use of a solo bassoon, solo trumpet and solo bass clarinet were popular devices in classical works from the time (see "Copeland, Aaron" for example.) He creates the "island" atmosphere via Latin/African percussion, reminiscent of film scores from the golden age of Hollywood.

The percussionist inside Mr. Copeland finds the perfect places for the musical punctuation of xylophone, triangle, concert tom-toms, etc. And even though the tip-toeing steps of the bass and bassoon are heard throughout, it's the booming bass and bass drum that drive the drama, expressing the developing madness inside and outside the characters.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522184739970/image%5B2%5D%5B1%5D.jpg.jpg)
<figcaption>Andrew Wilkowske, Lee Gregory in *The Invention of Morel*, Long Beach Opera, 2018. Photo: Kip Polakoff.</figcaption>
</figure>

With a libretto by Jonathan Moore (who also directed with exemplary flair), based on a 1940 novel by Argentinian novelist Adolfo Bioy Casares, the subject matter of *The Invention of Morel* is familiar. There are echoes of works that preceded Casares: *Robinson Crusoe* and *The Tempest*. And audiences will recognize the influence Casares had on the future with the TV show *Lost*, and perhaps the book and film of the *The Shining*. A man, The Fugitive (Andrew Wilkowske), finds himself alone on a deserted island - but is it deserted? And is he alone? There’s a creepy mansion/museum on the hill with some sort of strange machinery in the basement (this turns out to be the "invention" in the title.) In the first fifteen minutes of the short opera (it's ninety minutes with no intermission - another factor that "speaks" to a contemporary audience), The Narrator tells us the story of how The Fugitive got to the island and discovered the machinery. The Fugitive and The Narrator (Lee Gregory) are played by two different actors, but they are dressed to look exactly alike, with the exception of the gray in The Narrator's beard which indicates that he is older. Right away, we understand that they are supposed to be the same person in two different periods of time, essentially telling their story twice. The lyrics reveal that The Narrator is nearing death and trying to get his memories of his younger self written down in a journal. The dueling baritones in the dual role interact, singing their arguments at one another and in unison. Wilkowske and Gregory are both excellent singer-actors and up to the task of serving as the heart and soul of the story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522184748934/image%5B3%5D%5B1%5D.jpg.jpg)
<figcaption>Danielle Marcelle Bond, Jamie Chamberlin, Nathan Granner, Cedric Berry in *The Invention of Morel*, Long Beach Opera, 2018. Photo: Kip Polakoff.</figcaption>
</figure>

But they aren't the only ones on the island. They discover some wealthy people having a party up in the mansion. Are they ghosts from the jazz age? The party-goers even do the Charleston at one point. And one of the characters, Faustine (Jamie Chamberlin) is dressed to look exactly like silent movie star Louise Brooks (in all her flapper glory.) This last touch is no accident - Ms. Brooks was one of Mr. Casares' obsessions.

"The rich are very different," as the quote goes, and there's something extremely abnormal about the rich folks up in the museum. That's really all that can be said here about the plot because everything else would be a spoiler. There are plenty of surprises and although they all fall into the world of science fiction and fantasy, the sum is believable and compelling. There are clues sprinkled throughout until Dr. Morel (Nathan Granner) makes his big reveal to everyone, but the hints all come together in a cohesive narrative (unlike the TV show *Lost*.) "There is only one soul, but it goes to the same place as the atoms, so it seems" - that’s a quote from the libretto; it reveals nothing here, but tells you everything once you see the show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522184756842/image%5B7%5D.jpg.jpg)
<figcaption>Nathan Granner, Jamie Chamberlin in *The Invention of Morel*, Long Beach Opera, 2018. Photo: Kip Polakoff.</figcaption>
</figure>

Mr. Moore's staging could not be more perfect, especially with The Fugitive and Narrator who are mostly in hiding, observing the other characters as they go about their mysterious business. Mr. Moore moves the two men all around the action, in and out, and we wonder - are they observers or the observed?
Ms. Chamberlin as Faustine is a wonder who soars into the cosmos with her superhuman soprano. The entire opera ends with her on the highest of high notes - and that is a spoiler of sorts here but, as the expression goes, "wait for it." In one scene, Copeland has her singing lyric-less legato notes as she walks along the beach, pulling The Fugitive, The Narrator (and the audience) toward the rocks like a mythical Siren. The rocks and beach background are courtesy of projection designer Adam Flemming, whose projections are one of the stars of the show. He's found the perfect images to underscore the drama at each moment. Director Moore has also made the choice to use a projector to display some of the performers like on a jumbotron during a concert. These moments are sparing but very effective - especially during a dream sequence, and whenever we see the eerie character of Ombrellieri (tenor Doug Jones), his evil eyes hidden by sunglasses. Jones also plays one of the party guests, the successful architect Alec, and he is completely different (and superb) in the two roles.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522184766115/image%5B13%5D.jpg.jpg)
<figcaption>Doug Jones, Danielle Marcelle Bond, Suzan Hanson in *The Invention of Morel*, Long Beach Opera, 2018. Photo: Kip Polakoff.</figcaption>
</figure>

Mr. Granner is a commanding presence as the title character. Baritone Cedric Berry (as Stoever, an outsider or, as he puts it, a "guest of the guests") has a wonderful sonorous solo as he expresses his distrust of Morel. Suzan Hanson and Danielle Marelle Bond (as Dora and The Duchess) respectively, round out the rest of the ensemble with their superlative voices and believable portrayals of the hedonistic upper class.

Alan E. Muraoka has designed a simple but evocative set. Several metal arches appear to plunge at an angle down into Mr. Flemming’s underwater projection, indicating that the mansion and all its denizens can possibly be found at the bottom of the ocean and in the past. The stage, which represents "the island" is lit from beneath the performers' feet like the dance floor of a nightclub, and there are several short white tablets that stand upstage which are a mystery until the end.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522184731078/image%5B1%5D%5B1%5D.jpg.jpg)
<figcaption>Andrew Wilkowske, Lee Gregory in *The Invention of Morel*, Long Beach Opera, 2018. Photo: Kip Polakoff.</figcaption>
</figure>

Andreas Mitisek, who has conducted at Long Beach Opera for half of its history, expertly leads a chamber orchestra whose members shine in their numerous and important solos. As mentioned, the bass (Brian Cassier) and percussion (Paul Sternhagen and MB Gordy) get quite a workout. They are featured in every moment of the score. Mr. Mitisek makes all the right choices, not the least of which was choosing this program.

In the talkback preceding the opera, Mr. Stewart said that he preferred creating a "tide of music" rather than individual songs or arias. The waves do in fact wash over us, just as they wash over the island, and this is certainly a new work that should become part of the repertory everywhere.
 
*Note: The evening began with two appeals for funds, (one from Mr. Mitisek himself.) This reviewer also noticed that there were a number of empty seats. This is an important organization that deserves its share of the ever-shrinking arts dollars.*
