+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2019-02-17T18:27:44+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1550427838/media/2019/02/441FrankfurtHG2014.jpg"
primary_image_credit = "Katharina Magiera (Hänsel), Louise Alder (Gretel) and Peter Marsh (The wicked witch; above) in Oper Frankfurt's 2014 production of Hänsel und Gretel. Photo: Monika Rittershaus."
related_articles = ["articles/opera-adapts-a-medium-more-adept-at-adapting.md", "articles/concept-production-real-reason.md"]
related_companies = ["scene/companies/oper-frankfurt.md"]
related_people = ["scene/people/karen-vuong.md", "scene/people/cecelia-hall.md"]
short_description = "The schtick tightened up during the second half and the story leavened. The actors seemed to relax into their characters' inner lives once their outer circumstances had a discernible logic. Liberated from conceptual mumbo jumbo, the score and libretto timed better with the on-stage action. Finally, things made sense."
slug = "tweaking-the-brothers-grimm-in-oper-frankfurts-hansel-und-gretel"
title = "Tweaking the Brothers Grimm in Oper Frankfurt's Hänsel und Gretel"
youtube_url = ""

+++
Oper Frankfurt's 2014 production of _Hänsel und Gretel_ (directed by Keith Warner), recently in revival, has enough conceptual story alterations to appear modern. However, the show only succeeds when it sticks closely to its source material.

The production begins with an on-stage puppet show. A group of kids watches intently, Hänsel included (played by [Cecelia Hall](/scene/people/cecelia-hall/)). Hall blends in well with the children. As a boy, she throws her lanky frame around like an impetuous, fun-loving little doofus. Hall shaves a shade of richness off her voice for the role, giving her tone a nimbler effervescence.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550428045/media/2019/02/440FrankfurtHG2014.jpg){{% /md %}}

<figcaption>Peter Marsh (the Witch) in Oper Frankfurt's 2014 production of Hänsel und Gretel. Photo: Monika Rittershaus.</figcaption>

</figure>

The production puts Hänsel and Gretel (played by clear-voiced soprano [Karen Vuong](/scene/people/karen-vuong/)) in an orphanage; a puzzling if manipulative change to the original setting. It's as if the director, worried about the story's stakes, has decided he must take the children' parents away too.

> Every good fairy tale has a teachable moral, and this evening's was one for many of today's opera directors: don't mess with a story that works.

The siblings cruise through typical staging: bickering, dancing, and finally making enough ruckus that their mother, who they seem to have dreamed into existence, accidentally nudges the last morsel of food – a (strangely unbreakable) jug of milk – off the counter. The mother exiles the children to the woods as punishment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550428267/media/2019/02/447FrankfurtHG2014.jpg){{% /md %}}

<figcaption>Louise Alder (Gretel) and Peter Marsh (the Witch) in Oper Frankfurt's 2014 production of Hänsel und Gretel. Photo: Monika Rittershaus.</figcaption>

</figure>

Yet the children end up back in bed. They again fall asleep and enter a hallucinatory dream sequence featuring a parade of creatures. A brief scene shows the children being adopted. Then, they swiftly age into adults, and return to the orphanage to reminisce and, oddly, rest in their old beds.

Confused yet? All this tangential semi-storytelling has negligible narrative value. It's meant to set up the show's final image in which the children, aged, reunite with their parents, but so much hard-to-follow sequencing alienates the audience and makes for a tedious hour and a half of opera.

Fortunately, the production's second half returns to the Brothers Grimm's plot and keeps the original story almost entirely intact.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550428328/media/2019/02/446FrankfurtHG2014.jpg){{% /md %}}

<figcaption>Louise Alder (Gretel) and Katharina Magiera (Hänsel) in Oper Frankfurt's 2014 production of Hänsel und Gretel. Photo: Monika Rittershaus.</figcaption>

</figure>

The two youngsters approach a rundown house. No candy or gingerbread here. As they're yanked inside, the house rotates to reveal its interior. The upper floors have a charming Alice-in-Wonderland decor while the basement looks like _Saw III_. A shower curtain half-heartedly conceals a blood spattered meat freezer surrounded by suspended corpses of doll children. A huge oven, sporting a crafty German design, sits ominously in the middle of the room. Its exterior has a felt-like texture, but that makes it neither cheesy nor benign.

> The audience tittered gleefully, high on fairytale whimsy, as Gretel kicked the villain into the oven.

Peter Marsh's witch, like Jim Carrey's Grinch, is full of verve and spunk, and no less likeable for his gleeful wickedness. With a shaved head and a thrown-on flower print frock, he couldn't care less about passing as a witch or a woman.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550428596/media/2019/02/444FrankfurtHG2014.jpg){{% /md %}}

<figcaption>Heidi Melton (Mother) and Louise Alder (Gretel) in Oper Frankfurt's 2014 production of Hänsel und Gretel. Photo: Monika Rittershaus.</figcaption>

</figure>

The schtick tightened up during the second half and the story leavened. The actors seemed to relax into their characters' inner lives once their outer circumstances had a discernible logic. Liberated from conceptual mumbo jumbo, the score and libretto timed better with the on-stage action. Finally, things made sense.

The opera rushed to the witch's unceremonious demise with momentum. The audience tittered gleefully, high on fairytale whimsy, as Gretel kicked the villain into the oven.

Ultimately, the show works whether the conceptual framing does or not (it doesn't). Frankfurt's ever reliable ensemble singers carried the production – Claudia Mahnke and Simon Bailey were strong in the notoriously thankless roles of the mother and father, respectively. The story is timeless and beloved and Humperdinck's music feels more 1990s and then 1890s with a familiar movie-like motivic structure and sweep that still compels.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550428685/media/2019/02/442FrankfurtHG2014.jpg){{% /md %}}

<figcaption>Louise Alder (Gretel) and Katharina Magiera (Hänsel) in Oper Frankfurt's 2014 production of Hänsel und Gretel. Photo: Monika Rittershaus.</figcaption>

</figure>

Every good fairy tale has a teachable moral, and this evening's was one for many of today's opera directors: don't mess with a story that works.