+++
author = ["authors/jenna.md"]
categories = "Humour"
date = "2015-04-12T00:31:00+01:00"
lastmod = "2016-06-05T20:16:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428794740446/pageturner.jpg.jpg"
publishDate = "2015-02-13T16:31:00+00:00"
related_articles = ["articles/pianists-3-tips-for-sounding-like-an-orchestra.md","articles/playing-bel-canto-4-tips-for-pianists.md"]
short_description = "Pianists, can we talk about page-turning for a minute? Nothing ignites panic in a pianist quite like that horrible feeling of two pages, disguised as one, inexplicably stuck together. The subsequent scuffle between index finger and thumb can escalate into the unthinkable: having to turn the page with both hands. I’ve never been a fan of having a designated page-turner seated beside me at the piano, because I like my bubble of personal space when I play; my stubbornness on this issue has only grown stronger since I’ve been playing opera scores. "
slug = "turning-pages-turning-heads"
title = "Turning Pages, Turning Heads"
+++

Pianists, can we talk about page-turning for a minute? Nothing ignites panic in a pianist quite like that horrible feeling of two pages, disguised as one, inexplicably stuck together. The subsequent scuffle between index finger and thumb can escalate into the unthinkable: having to turn the page with *both hands*. I've never been a fan of having a designated page-turner seated beside me at the piano, because I like my bubble of personal space when I play; my stubbornness on this issue has only grown stronger since I've been playing opera scores. Even neatly reduced piano-vocal scores have aggressively placed page turns, and in those chorus scenes, you're lucky to fit more than eight bars on two pages. To add insult to injury, the number of other people in the rehearsal room who care that frequent page turns can throw off a pianist's groove, is exactly zero.

What can be done? How can a rehearsal pianist handle this kind of multi-tasking while maintaining tempo *and* their self-respect? Ideally? Learn to memorize like a fiend. I didn't do that, but I did come up with three\* simple-yet-handy tips to make your page turns less awful.

## Remind Yourself What's Next

<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428794795729/IMG_20150212_201156-758x1024.jpg"><img data-resize-src="http://lh3.googleusercontent.com/4O179oJQjZLpP4ZtS0It2-SBd6_3d-juvALR8fyQY5jcsU0AwA4hVG4NjaQ9gpV95alceVWpWz6oolUAciyhrUXi3mZf0Q" src="http://lh3.googleusercontent.com/4O179oJQjZLpP4ZtS0It2-SBd6_3d-juvALR8fyQY5jcsU0AwA4hVG4NjaQ9gpV95alceVWpWz6oolUAciyhrUXi3mZf0Q=s1200"></a></figure>

This photo is from my *Peter Grimes* vocal score. The page turn happens in the middle of a chorale-type section, where the rhythm is steady and the harmonies are important. This means that leaving out the left or right hand while turning the page is obvious to the point of it being distracting. I wrote myself a mini cheat-sheet of what's just over the page, telling myself that the F major chord in the right hand stays the same over the page, and that there's a G-natural in the bass; I also know that at the top of the next page, the quarter-note chords stop for just enough time to turn. I did the same thing later in *Peter Grimes*, at the very fast end of one of the Interludes:

<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428794823664/IMG_20150212_201243-758x1024.jpg"><img data-resize-src="http://lh3.googleusercontent.com/jLrjgVNdnxLRr8e-G6R7iEzjfIGp4KmCn2NLIBe0Zyd_PGGauGyykPZekqP2RRxE9eUoBEynP2FR_pyybzS0XQbC0eDy8w" src="http://lh3.googleusercontent.com/jLrjgVNdnxLRr8e-G6R7iEzjfIGp4KmCn2NLIBe0Zyd_PGGauGyykPZekqP2RRxE9eUoBEynP2FR_pyybzS0XQbC0eDy8w=s1200"></a></figure>

What I mean to tell myself here is that just over the page you end loudly in e-flat minor, and the bass drum happens, with some gusto because of the exclamation mark. This little note reminds me that the Interlude is over on the top of the next page, and it leads into a bit of recit with just a rumbling bass drum roll for accompaniment. So, as I tear down this chromatic scale in major ninths, in a constant accelerando, I at least don't have to worry about turning this particular page until after the bass drum, exclamation point.

## Get the Job Done Early

<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428794937564/IMG_20150212_202516-1024x758.jpg"><img data-resize-src="http://lh3.googleusercontent.com/ua6OM19nXHugx4oTKIUJwy02rn4kwNh_5Ljt89kGdx8StVrjGx3yWfciE-wXdMXE100ELnI_1_fi7vWTrmtH5ykPBPeZ" src="http://lh3.googleusercontent.com/ua6OM19nXHugx4oTKIUJwy02rn4kwNh_5Ljt89kGdx8StVrjGx3yWfciE-wXdMXE100ELnI_1_fi7vWTrmtH5ykPBPeZ=s1200"></a></figure>

This is a fun bit in Act II of *La bohéme*, that's not that difficult to play, but because everyone and their dog are singing in this scene, the page turns just won't quit (you'll note that the above two pages have about ten bars in them, and these bars move quickly). This is the opposite of the *Peter Grimes* examples: in cases like this, it's better to nip the problem in the bud before it becomes a *disastro*. Instead of waiting to the last couple of bars to turn, as usual, the smart pianist will see that she can carve two and a bit beats of rest from the left hand after striking that low A-flat. While the right hand does its scale, the left is free to turn the page in peace before Act II ends. As you can see, I like to give myself some forewarning, with the "turn [page] early" note, bottom left, followed by "turn now." in the bottom right; it's like a snooze button, but for pianists.

## See the Forest for the Trees
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428794991862/IMG_20150212_201532-758x1024.jpg"><img data-resize-src="http://lh3.googleusercontent.com/CehqjkHU7lNQ33DXodYLqauObarb3U7-cycoUJZKX8T9bs626d9vV7qf3BpJkKz6OGfR-sPzXAvXZ1-sogzt_95Pgao" src="http://lh3.googleusercontent.com/CehqjkHU7lNQ33DXodYLqauObarb3U7-cycoUJZKX8T9bs626d9vV7qf3BpJkKz6OGfR-sPzXAvXZ1-sogzt_95Pgao=s1200"></a></figure>

This is from the Act II finale of *Il barbiere di Siviglia*, in which everyone is singing, Ricordi uses wide spacing, and you're lucky to get 4 bars in a page. After nearly launching my score across the room in a particularly panicked grab at a page, I cursed Rossini and his incessant patterns and slow-burn crescendos. Then, I discovered I could clip together almost sixty pages of C Major-ness, and turn the whole mess out of my life in one fell swoop.

<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428795028837/BarberPageTurns_Fotor-1024x1024.jpg"><img data-resize-src="http://lh3.googleusercontent.com/bPJ3zUZ5BD690uaJmNl3crNjCGWTAjlXozFpjeZs7eiPRxEWpd8RmpIO8Ez0ewaUK9qCZ_XIB5Rn-JnHSP3xAfChc2_a" src="http://lh3.googleusercontent.com/bPJ3zUZ5BD690uaJmNl3crNjCGWTAjlXozFpjeZs7eiPRxEWpd8RmpIO8Ez0ewaUK9qCZ_XIB5Rn-JnHSP3xAfChc2_a=s1200"></a></figure>

Mr. Rossini, between pages 227 and 284 of your opera, so few harmonic changes occur that I clip them together thus (above). How do you feel about that?

So, fellow pianists, tell me: what odd tricks do you use, that I should add to this list?

\* For those readers who think I've left out the trusty Extra Photocopied Page trick, or that I'm resisting the age of the iPad, I challenge you to try out these tactics while playing a staging rehearsal.

