+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-06-19T14:20:00-04:00"
lastmod = "2015-06-19T15:50:00-04:00"
preamble = "In the last of our conversations with the folks behind the Canadian Opera Company's [Summer Opera Camp](http://www.coc.ca/exploreandlearn/children/summeroperacamp), I chat with drama specialist Jen Johnson and design specialist Sonja Rainey. Drama teacher Jen is Co-Artistic Director of [Kick Start Arts](http://kickstartarts.com/), a not-for-profit aimed at using the arts \"to empower students, youth and adults to express themselves through the creative process.\" Sonja is a Dora-award nominated set and costume designer, working most recently with the [Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/) for their East coast tour this summer. Jen and Sonja were both kind enough to answer my questions about working with kids, and how \"they keep things fresh, always.\"\n\nFor more, check out our interview with COC Summer Opera Camp Music Director [Chris Thornborrow](/chris-thornborrow-on-composing-with-kids/), and Associate Director of Education & Outreach at the COC, [Katherine Semcesen](/summer-opera-camp-at-the-coc/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1434740649808/COCSquare.jpg.jpg"
publishDate = "2015-06-19T15:27:00-04:00"
related_articles = ["articles/the-cocs-summer-youth-intensive-opera-really-is-fun.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/chris-thornborrow.md"]
short_description = "In the last of our conversations with the folks behind the Canadian Opera Company&#039;s Summer Opera Camp, I chat with drama specialist Jen Johnson and design specialist Sonja Rainey. Drama teacher Jen is Co-Artistic Director of Kick Start Arts, a not-for-profit aimed at using the arts &quot;to empower students, youth and adults to express themselves through the creative process.&quot; Sonja is a Dora-award nominated set and costume designer, working most recently with the Bicycle Opera Project for their East coast tour this summer."
slug = "turning-opera-insideout-upsidedown-at-summer-opera-camp"
title = "Turning opera &quot;inside-out, upside-down&quot; at Summer Opera Camp"
+++

### 1. How do you introduce theatre to young people?

**Sonja**: I think one of the great things about theatre is that it's really a natural extension of what kids are really amazing at and what they spend most of their time doing, which is playing, and creating their own realities and narratives and characters. [They're] already primed for sort of sweeping into that other version of reality, and I think design is simply about making those possibilities tangible, and perceptible to an audience. 

**Jennifer**: I think exposure, of course. As a drama teacher, when the students see the other students pretending and performing, kids seeing others performing is a huge thing. I think they can see themselves on the floor, then. Exposure to professional theatre as well, so taking them out to see productions at YPT or the opera, or any of the smaller venues around Toronto I think is also really important for general exposure. The fringe is a great place; you bring your kids out to the Fringe or Shakespeare in the Park and they go away elated and excited about theatre. Camps are another place to go, obviously putting them in an immersive situation where they're learning and presenting and performing and creating.

**Sonja**: When you can make the imagined into something real, in some way, not necessarily in a literal way but in a poetic or atmospheric way, that excitement can be really engaging. All of a sudden they're in a position of adopting that attitude...and to be able to explore just how far ideas can go, and be in a place where we're in a very fertile landscape for exploring where stories can be created. It's kind of a perfect playground for big ideas, and I think kids really respond to that cultivating aspect. Being able to say, "we're going to actually make this, we're going to get our hands dirty, and get in on this and create a version of this imagined place," is a really good way to get in there.

### 2. What kind of work will you do with Summer Opera Camp participants?

**Jen**: I always keep it in group work to start with, so that they're not nervous. A lot of kids come in and they think they're going to have to stand on stage and recite Shakespeare. That's not where we start with younger actors; we always start off with group work, movement work, partners, things so that they can feel confident and feel successful with their first experiences with theatre, rather than making them shy and nervous.

**Sonja**: I like to show a lot of images and examples of work...not necessarily things that happen onstage, but everyday images and say, "what could be the story be that's happening here?" [I like] to get our hands dirty right away, to start by making collages about what a character might be like, and then turn that into a sketch. Or maybe it translates into a puppet, that character, or a sculpture. Building the simple foundation of characters or a context in a really tangible way.

**Jen**: You keep it moving quickly. I don't talk a lot, I like to just get up on our feet...that's what helps them get over any nervousness they might have as well. We're doing drama games right away...name games, get-to-know-you games, circle stuff. Because I come from a heavy dance background I prefer to start with movement for kids, because there's less inhibition when kids use their physical expression, more than their voice at first. So I get them making shapes and partnering, moving around the space; there's not a lot of silence in the room.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1434741024713/IMG_0077lightened_resized.jpg.jpg)
<figcaption>Participants learn to make wigs & mustaches during the COC's 2013 Summer Youth Intensive.</figcaption>
</figure>

### 3. What aspects of theatre are most appealing and accessible for young people?

**Sonja**: With a group of kids, the biggest thing is that there's always a microcosm. It's like a little city that emerges, and there are the ones who are the engineers, who want to figure out how everything works, like "how will all of these things move, how will we build them?" There are the sort of visionaries, who are thinking of the big picture, and then in contrast to that there are the people who just want to do their one litte piece and make it really beautiful and be on their own, maybe not in the limelight. There are those who come alive, the ones who want to be the performers, and they really engage with how what they're making will be *on them*. It's always a real breadth of how people enter into it; I think our job is to find that doorway for each kid to step through.

**Jen**: I think they really like the more abstract of theatre, like tableau work and movement work and character representations, and modernizing things. I think that they really take to that, I think they understand it, they can grasp it, they can do it very successfully. All kids also want to perform; it's not all about the rehearsal time and the creation time, they do want to usually do some performances, even if it's just for each other. Just those basic performance skills are something that I like to help them develop as well as they go through the week: facing the front, speaking clearly and loudly, looking up. Kids love characters; they love to develop characters, so I'll lead them through that. Character in the body, character in the voice, relationships with others, so if you're the boss versus the scared worker, or something. That's another thing I find kids can really grasp onto quickly.

### 4. What do you like about working with kids?

**Jen**: Oh my goodness, kids will do anything! Kids are eager and excited and ready to do anything, and they just work so hard to do the best that they can. And they have unlimited energy, they don't need coffee breaks, they just keep going. You have to keep up with the kids, right? 

**Sonja**: That expansiveness of possibilities, of just how wild kids' imagination can be, and that you're given a wealth of surprises. Those surprises keep me on my toes, they keep things fresh, always. It's always a way of reminding that you can turn things inside-out, upside-down to discover new things in what might feel like familiar territory. You're constantly looking at it from another angle.

**Jen**: The best parts are when they surprise me with they own creativity, their own expressions, and then I realize, wow, when the true artistry comes out and it's things they've come up with themselves, and I'm astounded. It's professional-level tableau, right there! And they're so excited, we're all excited, it's fun. I love working with kids.

**Sonja**: I think that those surprises and that fresh perspective is just the thing that, whenever we're collaborating in any context, is the juice, the fuel that makes me want to do this work.
