+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-07-09T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "[_The Turn of the Screw_](https://www.garsingtonopera.org/performance/turn-screw) runs at Garsington Opera through 19 July."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1562682618/media/2019/07/sqGOtots2019JP_00760.jpg"
primary_image_credit = "The Turn of the Screw Garsington Opera 2019 Ed Lyon (Peter Quint), Richard Farnes (conductor) Louisa Muller (director) Christopher Oram (design) Malcolm Rippeth (lighting) credit Johan Persson."
related_articles = []
related_companies = ["scene/companies/garsington-opera.md"]
related_people = []
short_description = "This beautiful period production of Britten's The Turn of the Screw, directed by Louisa Muller, is no exception. The newly and rather cleverly built Opera Pavilion borrows from Japanese architecture, creating a space which ambiguously walks the line between the indoor and the outdoor. "
slug = "an-ambiguous-turn-of-the-screw-at-garsington-opera"
title = "An ambiguous Turn of the Screw at Garsington Opera"
youtube_url = ""

+++
Garsington, along with its other major summer opera festival cohorts, is an experience. Set on the idyllic grounds of Wormsley Estate in Buckinghamshire, guests are encouraged to arrive early to explore the gardens, while enjoying the views with a picnic lunch. It is nothing short of a British institution and if the weather holds out, it can be a lovely way to spend the day. However, it does commit one to a full day at the opera, which is a big ask for most. Yet, if you have the free time and the money to spend, it's a great day out.

And money seems to be the key. Private tents can be booked for a fee and dinner reservations can be made to be enjoyed over the course of the typically 90-minute intermission. This is not to mention the price of the ticket itself which can be upwards of £150 a seat. With all the fuss around the "experience" of going to opera, the importance of the performance itself seems to fade. Which is a shame, because Garsington has consistently put on intelligent, high-quality productions.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562682729/media/2019/07/1TheTurnoftheScrewGarsingtonOpera2019SophieBevanGovernessJohanPersson.jpg){{% /md %}}

<figcaption>The Turn of the Screw Garsington Opera 2019 Sophie Bevan (Governess), Richard Farnes (conductor), Louisa Muller (director), Christopher Oram (designer), Malcolm Rippeth (lighting) credit Johan Persson.</figcaption>

</figure>

This beautiful period production of Britten's _The Turn of the Screw,_ directed by Louisa Muller, is no exception. The newly and rather cleverly built Opera Pavilion borrows from Japanese architecture, creating a space which ambiguously walks the line between the indoor and the outdoor. An ideal venue for a summer opera festival, the Pavilion features sliding glass panels to allow the sounds and sights of the outdoors in while keeping the performers and audience safe from the weather under the covered structure.

> Miss Jessel often appears from the lake, dragging her gown through it and leaving a trail of water in her wake.

Production design by Christopher Oram made use of the space with a very simple yet effective set design. Gilded glass doors framed the stage establishing a sense of faded Victorian grandeur. Change of scene was implied only through minimal prop use and lighting, while the static set never changed. This left much to the imaginations of the audience. A small lake was built into the front of the stage which, by the second act, had grown to more than twice the size. This clever bit of design represents a real place written into the libretto, as well as a metaphor for Miss. Jessel's growing influence as her power over Flora begins to take hold. Miss Jessel often appears from the lake, dragging her gown through it and leaving a trail of water in her wake, making her mark on the physical world.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562682751/media/2019/07/5TheTurnoftheScrewGO2019LeoJemisonMilesElenWillmerFloraEdLyonPeterQuintKatherineBroderickMissJesselJohanPersson.jpg){{% /md %}}

<figcaption>The Turn of the Screw GO 2019 Leo Jemison (Miles) Elen Willmer (Flora) Ed Lyon (Peter Quint) Katherine Broderick (Miss Jessel) Richard Farnes (conductor), Louisa Muller (director), Christopher Oram (design), Malcolm Rippeth (lighting) credit Johan Persson.</figcaption>

</figure>

The production played with blurring the lines between the physical and spiritual worlds while also blurring the lines between theatre and reality. Because the performance was taking place in a space that was open to the outdoors, our outside world became a part of the world that was being created onstage. The wing-less stage necessitated, performers to enter and exit from the outside there they could be seen. This widened the scope of performance space, blending it with our reality.

> Lyon actively played with the shaping of the phrases, bending them deliciously out of shape.

It was a very intelligent way to use the space and to draw similarities between the ghosts and the performers themselves. But because the first half of the opera was in daylight, it rendered Malcolm Rippeth's lighting designs virtually ineffective. It wasn't until the second act after the sun had gone down that the production was able to make real use of the lighting and of candlelight. This allowed for the sought-after eerie quality this opera possesses and it contrasted to the lightness of the first act, raising the stakes for the climactic and tragic ending to the story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562682763/media/2019/07/6TheTurnoftheScrewGarsingtonOpera2019SophieBevanGoverneLeoMemisonMilesEdLyonPeterQuintJohanPersson.jpg){{% /md %}}

<figcaption>The Turn of the Screw Garsington Opera 2019 Sophie Bevan (Governess), Leo Jemison (Miles), Ed Lyon (Peter Quint), Richard Farnes (conductor), Louisa Muller (director), Christopher Oram (design), Malcolm Rippeth (lighting) credit Johan Persson.</figcaption>

</figure>

There was some very fine singing in this production, in particular from tenor Ed Lyon and soprano Katherine Broderick who played Peter Quint and Miss Jessel, respectively. The ghosts are given more free range with their characters simply by the nature of their roles in the story which both singers took advantage of. Lyon actively played with the shaping of the phrases, bending them deliciously out of shape in a very musically intelligent way, highlighting Quint's depraved character. Broderick has a stunningly powerful voice and in terms of pure sound and consistency, it was the best singing of the evening.

> I am not sure if I can align myself with what Garsington what it stands for or, at least, with what it has become.

Sophie Bevan did a fine job in the role of the Governess, but her voice seemed to lack connection at times. She gained momentum in the second half though, both vocally and in terms of commitment to her character. I was very impressed with young performers Adrianna Forbes-Durant and Leo Jemison in the roles of Flora and Miles. I often worry for children performers onstage, but these two had my absolute confidence. They are obviously two very diligent, and hard-working musicians and I have the utmost respect for what they were able to achieve.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562682783/media/2019/07/TOS_88.jpg){{% /md %}}

<figcaption>The Turn of the Screw GO 2019 Adrianna Forbes-Dorant (Flora) Kathleen Wilkinson (Mrs Grose) Sophie Bevan (Governess) Richard Farnes (conductor) Louisa Muller (director) Christopher Oram (design) Malcolm Rippeth (lighting) credit John Snelling.</figcaption>

</figure>

This was a cohesive and considered production that I thoroughly enjoyed. I appreciate the opportunities Garsington offers young, up and coming artists. Summer opera festivals also fill the gap in the regular opera season and can be a fun way to experience a performance. But I am not sure if I can align myself with what Garsington what it stands for or, at least, with what it has become. This way of participating in opera only perpetuates its exclusionary and insular nature which seems to me to be the exact opposite of the direction we need to go if the genre is to survive into the future.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562682858/media/2019/07/TheTurnoftheScrewGarsingtonOPera2019LeoJemisonMilesEd%20LyonPeterQuintJohanPersson.jpg){{% /md %}}

<figcaption>The Turn of the Screw Garsington Opera 2019 Leo Jemison (Miles), Ed Lyon (Peter Quint) Richard Farnes (conductor) Louisa Muller (director) Christopher Oram (designer) Malcolm Rippeth (lighting) credit Johan Persson.</figcaption>

</figure>