+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2019-01-30T01:47:34+00:00"
disclaimer = ""
image_gallery = []
postamble = "For full details of the current and upcoming season with the Toronto Symphony Orchestra, [visit their website](https://www.tso.ca/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1548523276/media/2019/01/sqGustavoGimenoconductingMarcoBorggreve.jpg"
primary_image_credit = "Gustavo Gimeno, whose tenure as Music Director of the Toronto Symphony Orchestra begins in the fall of 2020. Photo by Marco Borggreve."
related_articles = ["articles/candide-projecting-the-best-of-all-possible-worlds.md", "articles/in-review-mahler-other-beauties-at-the-tso.md"]
related_companies = ["scene/companies/toronto-symphony-orchestra.md"]
related_people = ["scene/people/emily-dangelo.md", "scene/people/russell-braun.md", "scene/people/isaiah-bell.md", "scene/people/erin-wall.md"]
short_description = "\"There's nothing I like better than planning programmes,\" says Davis, of his enthusiastic stepping in as the TSO's Interim Artistic Director. But, eager to pass the torch officially to Gimeno, \"the next season will be Gustavo's.\""
slug = "tsos-201920-a-season-of-mostly-classics"
title = "TSO's 2019/20 a season of (mostly) classics"
youtube_url = ""

+++
The [Toronto Symphony Orchestra](/scene/companies/toronto-symphony-orchestra/)'s 2019-20 season will be, one hopes, the last in a while without the appointment of a permanent Music Director. Interim Artistic Director Sir Andrew Davis has returned to the TSO following Conductor Emeritus Peter Oundjian's exit at the end of the 2017-18 season; incoming Music Director Gustavo Gimeno, set to officially begin his tenure in the fall of 2020, will be in town to conduct a handful of concerts this season, whetting the audience's appetite.

> Eager to pass the torch officially to Gimeno, "the next season will be Gustavo's."

In fact, 2019-20 will be a season that, as Davis describes it, "emphasizes continuity." With Oundjian, Davis, Gimeno, and fellow former Music Director Jukka-Pekka Saraste, "The whole succession of Music Directors is there."

The TSO's past, present, and future will all take the podium in 2019-20. In the fall Gimeno will conduct a Russian-French programme (October 9-12, 2019), and he'll return in April for a concert of Brahms featuring star pianist Yuja Wang (April 8-11, 2020). Oundjian will return for a hefty concert of **Mahler's Symphony No. 5** and Bruch's **Violin Concerto**, featuring TSO Concertmaster Jonathan Crow (April 29-May 2, 2020). And Sir Andrew Davis will be a season-long presence as a conductor, a composer, and even as an organist for Saint-Saëns' **"Organ Symphony"** (June 17-21, 2020).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548523379/media/2019/01/GustavoGimenoMarcoBorggreve.jpg){{% /md %}}

<figcaption>Gustavo Gimeno, incoming Music Director of the Toronto Symphony Orchestra (fall, 2020). Photo by Marco Borggreve, courtesy of the Toronto Symphony Orchestra.</figcaption>

</figure>

Though these seasons of transition are perhaps light on the contemporary repertoire and outside-the-box projects which are easier to pull off with permanent management, the TSO is falling wisely back onto the massive canon of traditional symphonic masterworks. Like the current season, the TSO's line-up for next year gives aficionados the chance to hear live a good chunk of their symphonic repertoire bucket list: Massenet's **_Thaïs_**, starring [Erin Wall](/scene/people/erin-wall/) in the title role, Vivaldi's **_Four Seasons_**, featuring Jonathan Crow (November 16-20, 2019), **Dvořák's Cello Concerto**, featuring Joseph Johnson (January 30-February 1, 2020), Wagner's **_Wesendonck Lieder_** with Donald Runnicles on piano and the TSO Chamber Soloists, Mussorgsky's **_Pictures at an Exhibition_** (March 20-22, 2020), and Strauss' **_Also sprach Zarathustra_** (June 17-21, 2020).

> Amid a season that's packed with the traditional, there are a few items of novelty.

Those paying attention already know that 2020 marks 250 years since Beethoven's birth, and the TSO is celebrating: On the year's line-up are Beethoven's Symphonies Nos. 5, 6, 7, and 8, his Piano Concerti Nos. 3, 4, and 5 (the latter performed by TSO favourite Jan Lisiecki), and his Violin Concerto, played by James Ehnes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548523450/media/2019/01/TSO201920.jpg){{% /md %}}

<figcaption>Clockwise from top left: pianist Yuja Wang (photo: Kirk Edwards), soprano Barbara Hannigan (photo: Elmer de Haas), pianist Seong-Jin Cho (photo: Harald Hoffmann), and conductor Elim Chan (photo: Willeke Machiels). Photos courtesy of the Toronto Symphony Orchestra.</figcaption>

</figure>

Amid a season that's packed with the traditional, there are a few items of novelty. The TSO is beginning a collaboration with Equilibrium Young Artists, an international mentoring program founded by Canadian soprano and conductor Barbara Hannigan; four singers from Equilibrium will make up the quartet for Mozart's **_Requiem_**, January 15-18, 2020. And Hannigan herself will help kick off 2019-20 with the season opening concerts on September 19 and 21, alongside a fellow double-threat, conductor and violinist John Storgårds; she'll sing **Ophelia's Mad Scene from Brett Dean's _Hamlet_** while Storgårds conducts, and she'll take the podium to conduct Storgårds as he performs Dutilleux's **_Sur le même accord_**.

> The classics-heavy line-up already seems like a launching pad for the new aesthetic to come.

There are Young People's Concerts: **Symphony Spooktacular** (October 27, 2019), **Beethoven Lives Upstairs** (February 2, 2020). **The Composer Is Dead** (March 1, 2020), and **Symphonic Fairy Tales** (April 26, 2020); there are Holiday Pops with Toronto fave Measha Brueggergosman. And there's the inevitable **Handel's _Messiah_**, looking particularly Canadian with soloists [Jane Archibald](/scene/people/jane-archibald/), [Emily D'Angelo](/scene/people/emily-dangelo/), [Isaiah Bell](/scene/people/isaiah-bell/), and [Russell Braun](/scene/people/russell-braun/).

And films! The TSO continues its _Star Wars_ series, with **_Return of the Jedi_** (October 2-5, 2019) and **_The Force Awakens_** (May 6-9, 2020); plus, **_Home Alone_** for the holidays, December 6-7, 2019.

Perhaps the TSO is indeed playing a bit of a waiting game, spending the "interregnum" - to use Davis' term - doling out heavy-hitters and masterworks of centuries past. Still, there are worse ways to spend a season, and the classics-heavy line-up already seems like a launching pad for the new aesthetic to come.

"There's nothing I like better than planning programmes," says Davis, of his enthusiastic stepping in as the TSO's Interim Artistic Director. But, eager to pass the torch officially to Gimeno, "the next season will be Gustavo's."