+++
author = ["authors/jenna.md"]
categories = "Interview"
date = 2017-08-20T15:19:00Z
lastmod = "2017-08-21T13:23:00-04:00"
preamble = "Coming to [Opera Philadelphia](/scene/companies/opera-philadelphia/)'s O17 Festival this fall is the world premiere of [_We Shall Not Be Moved_](https://www.operaphila.org/whats-on/on-stage-2017-2018/we-shall-not-be-moved/), **September 16-24**. Created by composer Daniel Bernard Roumain and librettist Marc Bamuthi Joseph, and directed by Bill T. Jones, _We Shall Not Be Moved_ tells the story of five teens who find shelter in the abandoned West Philadelphia building that occupies the same spot as the [MOVE organization](https://en.wikipedia.org/wiki/MOVE)'s headquarters, home of the 1985 police standoff that resulted in the [destruction of a neighbourhood](https://ammo.com/articles/move-bombing-how-philadelphia-became-the-city-that-bombed-itself) and 11 deaths (including 5 children).\n\nDaniel Bernard Roumain's work is a \"brooding, often joyful score filled with place, purpose, and possibility\", and combines classical singing with R&B, jazz, and spoken word. We spoke with the composer about _We Shall Not Be Moved_, and its connection with a piece of American history in Philadelphia."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503243147072/2017-08-20---Square---we-shall-not-be-moved-003.jpg.jpg"
primary_image_credit = "The cast of We Shall Not Be Moved rehearses during a 2017 workshop in Philadelphia. Photo: Dave DiRentis/Opera Philadelphia."
publishDate = "2017-08-21T12:03:00-04:00"
related_companies = ["scene/companies/opera-philadelphia.md"]
short_description = "&quot;As an artist, I am most concerned with offering an antidote to the ills of the world within our communities. As a Haitian-American composer, I am always wanting to create music that speaks to multiple, overlapping cultures, and combine sounds that might, upon an initial hearing, appear to conflict, and upon a deeper listening, offers resolution and beauty.&quot;"
slug = "truth-as-reconciliation-we-shall-not-be-moved"
title = "&quot;Truth, as reconciliation&quot;: We Shall Not Be Moved"

+++
## What stood out to you about the story of the MOVE bombing?
 
The MOVE organization, more than being a close, community of loving people, was a close family of brilliant, imaginative individuals, who lived and died in fighting for our ever elusive American dreams: life, liberty, and the pursuit of happiness. 

## Why did you see it as a story well-suited to an operatic telling?
 
Marc's story is NOT the story of MOVE. Marc's story is completely original. *We Shall Not Be Moved* is the story of runaway children, law enforcement, truth, and reconciliation. 

## How did the characters of The Family Stand develop?
 
Our brilliant director, Bill T. Jones, asked probing questions that demanded clear and precise answers that we answered in a barrage of libretto revisions, workshops, and constant development conversations. 

## Do they represent a forgotten segment of our society?
 
I think so. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503243543655/2017-08-20---we-shall-not-be-moved-001.jpg.jpg)
<figcaption>John Little (tenor Daniel Shirley), John Blue (countertenor John Holiday), John
Mack (baritone Adam Richardson), Un/Sung (spoken word artist Lauren Whitehead), and John Henry (bassbaritone Aubrey Allicock) in front of the boarded-up Osage Avenue home on the site of the 1985 MOVE bombing in Philadelphia. Photograph by Dominic M. Mercier for Opera Philadelphia.</figcaption>
</figure>

## What kind of musical aesthetic comes out of a story from this world, in contemporary Philadelphia?
 
My music is an amalgam of all the music I listen to and love. From Satie to Sade, the musical aesthetic for *We Shall Not Be Moved* is lyrical, funky, complex, dense, and at times, rhapsodic. I use repetition in a purposeful, deliberate way: to better understand Marc's poetic words and phrases, and to give the drama time to be understood and unfold. 
 
## What has it been like working with Marc Bamuthi Joseph's libretto, which combines operatic singing with spoken word poetry?
 
For me, Marc's words are full of music. I never have to imagine or find or even "set" his words to music. His hybrid opera, in which spoken-word and spoken-word rhythms are married to operatic singing, felt and feels organic, natural, and frankly, timely. Marc and I, working closely with Bill T. Jones, have created an opera full of a world of ideas, sound, and intrigue. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503243553452/2017-08-20---we-shall-not-be-moved-002.jpg.jpg)
<figcaption>Composer Daniel Bernard Roumain, director Bill T. Jones, and librettist Marc
Bamuthi Joseph. Photograph by Dave DiRentis for Opera Philadelphia.</figcaption>
</figure>
 
## How does the MOVE bombing fit into Philadelphia's historical relationship with activism and police?
 
I'm not sure. As an artist, I am most concerned with offering an antidote to the ills of the world within our communities. As a Haitian-American composer, I am always wanting to create music that speaks to multiple, overlapping cultures, and combine sounds that might, upon an initial hearing, appear to conflict, and upon a deeper listening, offers resolution and beauty. But as a Black man, I, too, have been made aware of the limits to my relationship with law enforcement, my responsibility to my sons, and my awareness of how much hate remains persistent and present in our lives. 
 
## What do you hope audiences will take away from this world premiere run of *We Shall Not Be Moved*?
 
Truth, as reconciliation. 

>We Shall Not Be Moved plays September 16-24 at The Wilma Theater in Philadelphia. For details and ticket information, follow our box office links below.