+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2016-03-18T17:43:00+00:00"
lastmod = "2016-03-21T10:23:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458503262332/2016-03-20---Writers.jpg.jpg"
publishDate = "2016-03-21T10:23:00+00:00"
related_articles = ["articles/music-the-musicians-therapy-except-when-its-not.md","articles/once-agan-shushing-meanies.md","articles/catty-commentary-or-whats-not-useful-for-opera.md","articles/when-critics-are-jerks.md"]
short_description = "Maybe it&#039;s the concept of the critic, or maybe it&#039;s the notebook itself, that can evoke suspicion. The notebook is open to record all the mistakes, and while the critic is scribbling in the dark, magic is happening onstage and they&#039;re missing it. It&#039;s not just a myth; these things happen, and critics can be relentlessly harsh, to the point where one wonders why they keep going to the opera, if they dislike everything they see."
slug = "true-stories-the-critic-who-loves-opera-even-more-now"
title = "True stories: the critic who loves opera even more now"
+++

Recently, I had a conversation with a fellow opera-goer, curious about the pen and notebook I whip out before the lights dim and the opera begins. A long-time attendee of the Royal Opera House, she told me that she would find it difficult to become removed enough from the action onstage to write coherently about it. The conversation sparked a question: do critics and reviewers have a lesser experience at the opera, precisely because they're charged with writing about it afterwards?

The short answer is no, not at all. The pen and notebook are out and ready, and the notes we take in the dark, while staring at the stage, are usually hilarious chicken scratch. We make note of moments that wow us, singers that thrill us, and when a tempo is *just right*. We scribble noisily (and underline aggressively) when productions anger us, singers confuse us, and when the overture schleps mercilessly. Things like "holy tenor!", "Rowan Atkinson?" and "how can a set change take *this long??*" litter the notebook pages, and it's likely not a far cry from the thoughts popping into the heads of other listeners. (Well, maybe not the Rowan Atkinson bit, but who knows?)

One surprising result of taking on the critic's role is that the moments of awe and amazement become more noticeable. It's not rare, necessarily, but there are moments where what I see is so engrossing, so stunningly exciting, that it's not worth tearing my eyes away to put pen to paper, even in the dark. These moments have included the entirety of the COC's [*Bluebeard's Castle/Erwartung*](/in-review-bluebeards-castle-erwartung/) double-bill, Tapestry Opera's [*Songbook VI*](/he-saidshe-said-songbook-vi/), Against the Grain Theatre's [*Death/Desire*](/in-review-death-desire/), ENO's [*The Magic Flute*](/in-review-enos-the-magic-flute/), and Sondra Radvanovsky's [Koerner Hall recital](/in-review-sondra-radvanovsky-at-koerner-hall/). 

This isn't to say that a show isn't great unless it makes us forget to take notes. But it's a litmus test of sorts that has emerged out of writing reviews. In the same way that music [doesn't always soothe the working musician's soul](/music-the-musicians-therapy-except-when-its-not/), when you work in opera, attending one isn't always the first choice for after-dinner plans. So, as my day job shifted from rehearsal time to writing time, the desire to attend *lots and lots of shows* skyrocketed. It can be an unsettling thing to doubt the level of passion you have for opera and classical music, especially when it's also your career. One of the cooler things that came out of creating Schmopera is the assurance that that passion is indeed there, and insatiable; the doubts came from feelings of being burnt out, which is a simpler problem to solve.

We digress. Maybe it's the concept of the critic, or maybe it's the notebook itself, that can evoke suspicion. Stereotypes can make it seem as though The Notebook is open to record all the *mistakes*, and while the critic is scribbling in the dark, magic is happening onstage and they're missing it. It's not just a myth; stereotypes exist for a reason, and critics can be relentlessly harsh, to the point where one wonders why they keep going to the opera, if they dislike everything they see. 

Our contributors are all working artists, which means they're better multi-taskers than many. Personally, I've been listening intently while making notes (mental or otherwise) for a long time now. That's what coaching is, that's assisting a conductor: listen hard, figure out what you're hearing, and if it's not making you happy, figure out why (the reason should be better than *I don't like that*, too). As a performer, and champion of opera singers, the potential hypocrisy of writing reviews about my colleagues and friends was serious; that notebook is there to keep *me* honest, not the folks onstage. Outbursts of rage in Act I may be mollified by Act III, and art certainly does deserve points for context.

Taking notes, articulating thoughts, all of it has strangely enhanced the experience of live theatre and music. There's that saying, "you get out what you put in", and maybe that applies to going to shows. The complimentary tickets offered generously by opera companies, symphonies, recital series, they come with an agreement that something will get written about what we see. So, when there's responsibility on our end to write something truthful and interesting, we listen intently. Speaking for myself, I'm paying more attention at shows than ever before; I've put more effort into going to the opera, and I've built a enviable collection of "wow" moments as a result.
