+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = "2018-11-18T17:16:00-05:00"
lastmod = "2018-11-22T11:18:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1546224475/media/2018/12/sqGloryDeniedDMMO.png"
primary_image_credit = "Michael Mayes as Older Thompson in Glory Denied, Des Moines Metro Opera, 2018. Photo: Duane Tinkey."
publishDate = "2018-11-22T11:18:00-05:00"
related_articles = ["articles/an-extended-mad-scene-glory-denied.md"]
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = ["scene/people/kelly-kaduce.md"]
short_description = "This is Des Moines Metro Opera&#039;s second opera performed at Camp Dodge, and I hope it will not be the last. Aside from the physical location, the collaboration with the military community produces numerous benefits. The participation of veterans and active duty service members in the post-show panel discussion helped to bridge the gap between theater and reality."
slug = "true-impact-dmmos-glory-denied"
title = "True impact: DMMO&#039;s Glory Denied"

+++
[Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/) does not pull any punches when it comes to their Second Stages series. The company has consistently chosen operas that are thought provoking and relevant to modern audiences and then set them in unique locations that provide another level of thematic context. Tom Cipullo's _Glory Denied_ is a complex, emotional piece on its own, but its dramatic impact is greatly enhanced when performed on an active military base.

This is Des Moines Metro Opera's second opera performed at Camp Dodge, and I hope it will not be the last. Aside from the physical location, the collaboration with the military community produces numerous benefits. The participation of veterans and active duty service members in the post-show panel discussion helped to bridge the gap between theater and reality. Cipullo's music can convey the passion and angst of a soldier's true story, but seeing a Vietnam veteran with tears in his eyes as he talked about the loss of his best friend, a POW who never returned, breaks your heart with visceral power. Putting the faces of real people, fellow Iowans, at the front of the discussion helped to highlight the universal themes of _Glory Denied_.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1546224717/media/2018/12/GloryDeniedDMMO2.png){{% /md %}}<figcaption><em>Glory Denied</em>, Des Moines Metro Opera, 2018. Photo: </figcaption> </figure>

The scenic design by Adam Crinson was subtle and versatile with a four pronged platform that could serve as the site of Colonel Thompson's captivity and his world back home in the United States simultaneously.  A plethora of crude paper stars hung from the ceiling of the theater, a constant reminder of a homemade gift from his daughter and a symbol of what he is fighting to return to. Kathy Maxwell's lighting design showcased the singers as the dramatic focal point, and the use of video projects on upright panels provided historic images and written correspondence without being distracting.

The stage was set up in a round which allowed the singers to move through the space organically and sing at different angles. This led to some sounds issues at times depending on where you were sitting in relation to the singer, but these moments were usually short lived. I can't be too picky about it, since I am sure acoustics were not high on the priority list when the National Guard built the space.

The orchestra under the direction of Joshua Horsch provided the varied emotional atmosphere of the opera. Perched on a raised platform behind the stage, the instrumentalists were an acoustic constant, but even with the use of monitors around the stage, I could sense there were some brief moments where the ensemble and the vocalists were not quite syncing up. Cipullo's music is rhythmically complex, a feature which becomes extra challenging in a non-conventional theater space. As the performance progressed, this issue decreased significantly as the singers and conductor adjusted.

There are only four characters in _Glory Denied_, the younger and older versions of Jim Thompson and his wife Alyce. The story is told in a non-linear fashion, jumping back and forth in time. The audience is experiencing Jim's life as he does. Even when he returns home after nine years of captivity, he never truly leaves his POW camp cage. Similarly, he cannot leave behind his idealized memories of his life before the war. The conflict between memory and reality dominates his mental struggle, and all he can do is fight to survive the past and present.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1546224960/media/2018/12/GloryDeniedDMMO3.png){{% /md %}}<figcaption><em>Glory Denied</em>, Des Moines Metro Opera, 2018. Photo: </figcaption> </figure>

Emma Grimsley sang the role of Younger Alyce, an idealized memory of Jim's wife. Because she is not a real person, she lacks the emotional depth of the other characters, but the concept of her is crucial to Jim’s endurance. Grimsley's voice resembled that of a Disney princess, and I could easily picture the soprano singing with birds in a chirpy homage to Snow White. Her pure, shimmering vocal tone matches the fairy tale perception Jim has of his wife, creating a shocking effect when we meet the real version of Alyce.

Younger Thompson, the prisoner of war, was a physically grueling role, and John Riesen portrayed the character with heartfelt sincerity. While Younger Thompson was more dramatically compelling than Younger Alyce, this Jim is far easier to understand than the older version of him. His enemies are clearly defined, and his goal is to get home. His letters from Alyce and his memory of her, however unrealistic it may be, are the only things motivating him to survive.

Older Alyce was the most controversial figure of the opera. One moment she would piss you off, and then her next scene would break your heart. Many of the choices she makes during Jim's absence are unsettling. Some of her actions are easier to fathom than others. She is lonely and has four young children to raise, so I can understand why she would turn to another man for companionship and financial security. Her refusal to allow Jim's name to be released to the public or to make POW bracelets with his name was perplexing and frustrating. Her reaction came across as callous, and with little to no explanation for her motives in that scene, it is easy to demonize her. Unlike Jim's idealized memory of her, Alyce is not perfect. She's a messy human being, but that doesn't make her a villain. Jim tells her "I want what I left," but this is impossible. She cannot exist as a time capsule from nine years ago, and I can understand how she would resent this.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1546225046/media/2018/12/GloryDeniedDMMO4.png){{% /md %}}<figcaption><em>Glory Denied</em>, Des Moines Metro Opera, 2018. Photo: </figcaption> </figure>

Soprano [Kelly Kaduce](/scene/people/kelly-kaduce/) sang the role of this problematic woman with emotional complexity and heft. Her performance evoked a wide range of reactions from the audience, making Alyce just as sympathetic and frustrating as a real person. Her aria during her reunion with Jim was the most lyrical and loving music of the opera, and her vocal tone in that scene brought unexpected softness after her earlier bitter music. Kaduce's ability to jump from low, cutting lines of profanity to high, floating notes with ease demonstrates her vocal prowess as well as her dramatic chops. This is the soprano's first time performing this role, and I can only imagine how much more powerful her portrayal will become as she grows into it further.

Michael Mayes was a commanding force onstage as the Older Thompson. He was menacing in his interactions with his younger self, sometimes acting as the Vietnamese interrogators that tortured him for almost a decade. Mayes' physicality was versatile as the character shifted through time and emotions, becoming more intense and brimming with anger as Jim's mental struggles increased.

Older Jim is just as complicated as his wife, and while it was easier to sympathize with him, there were moments when his darker nature would surface. Mayes delivered a dramatic and vocal performance that matched Thompson’s constantly fluctuating emotional journey. His "Welcome Home" aria was a mixture of humor and heartbreak as Jim comes to terms with all the changes that have happened during his captivity. It reminded me of an angry, depressing version of "We Didn't Start the Fire," part historical recap, part emotional breakdown.

In stark contrast were the scenes in which Jim forgives his wife and asks to start again. Mayes sang with haunting beauty, his pianissimo seemingly freezing time, making it all the more jarring when Alyce rejects his olive branch.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1546225104/media/2018/12/GloryDeniedDMMO5.png){{% /md %}} <figcaption><em>Glory Denied</em>, Des Moines Metro Opera, 2018. Photo: </figcaption> </figure>

Cipullo's compositional style evolved as the opera progressed, and I enjoyed the second half of the work much more than the beginning. The music became more expansive and melodic as the Older Jim and Alyce dominated the story which made their emotions more compelling for me. I even found myself tearing up a couple of times during their reunion and the final scene of the opera which is a testament to the hard hitting emotional weight of Cipullo's music.

_Glory Denied_ is guaranteed to make you feel something whether you have been personally impacted by the military experience or not. As a civilian, I can never understand what Jim Thompson or his wife Alyce endured as a result of his captivity. I can, however, empathize with them which is a key message of this opera. As one of the veterans mentioned in the post-show talk back, you encounter people every day and have no idea what they are going through mentally. Like Jim and Alyce, everyone is trying to survive their own struggles, taking it one day at a time. So reach out to another human being and ask to hear their story. It might have a bigger impact than you realize.