+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-04-16T22:03:00-04:00"
lastmod = "2018-04-17T20:03:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523930611399/sqCH1379245_Original.jpg.jpg"
primary_image_credit = "Photo: Chris Lee/Boston Symphony Orchestra."
publishDate = "2018-04-17T20:03:00-04:00"
short_description = "Caught between duty, desire and despondence, Kaufmann&#039;s Tristan navigated with a melancholic and determined grace, building to fanatical splendor only to dissolve in hallucinatory turmoil. Whether he can sustain all of this vocally and emotionally in a full production is a question that the opera world eagerly waits to have answered."
slug = "tristan-und-isolde-druginduced-elegance"
title = "Tristan und Isolde: drug-induced elegance"
+++

Whatever was going on between Richard Wagner and Mathilde Wesendonk, we should be grateful for it. In 1858 Wagner moved into a cottage on the Zürich estate of Mathilde and Otto Wesendonk where he began composing *Tristan und Isolde*, his immortal ode to love and death. We don't know if their relationship was spiritual or physical, or a bit of both, but we do know that it had an influence on Wagner as he set this Celtic legend to music.

What Andris Nelsons and his Boston Symphony Orchestra brought to Carnegie Hall last Thursday was an elegantly played, and for the most part, gorgeously sung, *Tristan und Isolde*, Act II. The intensity of Wagner and Mathilde's relationship may remain debatable but the volatility of Tristan and Isolde is not. The pair must connect with irrational intensity.

And connect they did. Jonas Kaufmann and Camilla Nylund were beautifully matched, their voices blending with dramatic power and then melting into the romance and resignation, or, depending on how you look at it, the redemption of the night. They were on opposite sides of the conductor's podium, but appeared to be locked in a nocturnal embrace. Their stage distance was an effective visual contrast to the intimacy of the music. 

Nelsons was so supportive of his singers as to seem complicit, an impeccable go-between as it were. Strings hovered almost imperceptibly and sublimely engulfed the enraptured lovers. Subdued percussion, weighty but not overwhelming brass and distant woodwinds cast an unbroken spell until Kurwenal's sudden entrance interrupted. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523930446515/CH1379241.jpg.jpg)
<figcaption>Jonas Kaufmann, Andris Nelsons, and Camilla Nylund singing Act II of *Tristan und Isolde* at Carnegie Hall. Photo: Chris Lee/Boston Symphony Orchestra.</figcaption>
</figure>

To say that Jonas Kaufmann melded the strength and clarity of a heldentenor with sustained passages of smoky, nuanced beauty, is fairly summing it up. Caught between duty, desire and despondence, Kaufmann's Tristan navigated with a melancholic and determined grace, building to fanatical splendor only to dissolve in hallucinatory turmoil. Whether he can sustain all of this vocally and emotionally in a full production is a question that the opera world eagerly waits to have answered. But what an impressive tryout he had at Carnegie Hall and at Symphony Hall in Boston a few days earlier.

Nylund was, for the most part a radiant if troubled Isolde with a voice of unremitting loveliness, despite instances of lost low notes and moments when she did not sufficiently rise above the orchestra. Her Isolde possessed a youthful and fretful quality that captured the fragility of her ardor and conflicted nature. One did not need to follow a libretto or surtitles to know that Isolde's passion was induced.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523930576109/CH1379240.jpg.jpg)
<figcaption>Camilla Nylund and Jonas Kaufmann, Act II of *Tristan und Isolde* at Carnegie Hall. Photo: Chris Lee/Boston Symphony Orchestra.</figcaption>
</figure>
 
A fully staged *Tristan und Isolde* is so static by nature that mounting a sufficiently expressive concert version of Act II is less daunting than *Das Rheingold*, for example, in which its swimming maidens, giants, and lurking Nibelungen, among other things, must be evoked. The challenge here was to make theatrical decisions, like the placement of Tristan and Isolde, work in the service of the singers and the flow of evening. Such was the case throughout this handsome concert.  

Mihoko Fujimura, as a forceful and unyielding Brangäne, began at stage left for her opening scene with Isolde and moved to the stage right entrance where she served as lookout for the lovers. The only fully functioning adult in the room, her deep and clear mezzo had an authority that gave essential shape to the back-story and made the substitution of Isolde's requested death formula with a love potion, seem a reasonable tactic. Fujimura projected a penetrating if largely unseen presence as the tension mounted during her night watch. Despite much of her singing being done off stage and having limited opportunity to act, she emerged as a remarkably strong presence. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523930590396/CH1379248_Original.jpg.jpg)
<figcaption>Mihoko Fujimura singing Act II of *Tristan und Isolde* at Carnegie Hall. Photo: Chris Lee/Boston Symphony Orchestra.</figcaption>
</figure>

With Tristan having crossed the stage to finally be by Isolde's side, King Marke, sung with mournful dignity by bass, Georg Zeppenfeld, commanded stage right by simply standing there. Motionless and heartbroken, like a middle-aged Hamlet, he was so stunned by Tristan's inability to explain his betrayal that any expression of rage or anger was beyond him. There he stood, the very definition of stoicism, as the baffling lovers rhapsodically pledged to journey together into death and as Tristan was wounded. 

Lovers longing for the eternal bliss of oblivion on one side of the podium; an emotionally flattened king on the other; and an inspired conductor in the center, brought Act II to a stirring conclusion. Audiences in Boston and New York, having experienced the opera's middle act, can now anticipate a tenor who might achieve the vocal equivalent of sipping from the Holy Grail, singing the perfect Tristan.
