+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2020-09-25T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "[_The Trial at Rouen_](http://www.bmop.org/audio-recordings/norman-dello-joio-trial-rouen) is released by BMOP/sound."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1600626598/media/2020/09/Cover_Image_hs5rsp.jpg"
primary_image_credit = ""
related_articles = ["articles/odyssey-operas-grand-la-reine-de-saba-a-great-season-opener.md", "articles/odyssey-operas-giovanna-darco-bold-and-flawed.md"]
related_companies = ["scene/companies/odyssey-opera.md"]
related_people = ["scene/people/stephen-powell.md", "scene/people/heather-buck.md"]
short_description = "Thankfully, Odyssey Opera thought a little ahead of the curve: for the next album in their recordings of newer opera, they have opted to put The Trial at Rouen on Boston Modern Orchestra Project's recording label, BMOP/sound, and with the same cast that performed it in December 2017, no less!"
slug = "trial-at-rouen-slow-but-revealing-on-record"
title = "Trial at Rouen slow but revealing on record"
youtube_url = ""

+++
When I first returned to Boston, [Odyssey Opera](/scene/companies/odyssey-opera/) was in the middle of its exploration of operas based on the story of Joan of Arc. The entire first half of this season, I ended up missing: I had come to the city around the time of their performance of Arthur Honneger's _Jeanne d'Arc au bûcher_, just in time to catch Verdi’s [_Giovanna d’Arco_](/odyssey-operas-giovanna-darco-bold-and-flawed/) after that. At the time, I figured that I would not get much of a chance to catch up on the other two operas, in particular Norman Dello Joio's _The Trial at Rouen_.

Thankfully, Odyssey Opera thought a little ahead of the curve: for the next album in their recordings of newer opera, they have opted to put [_The Trial at Rouen_](http://www.bmop.org/audio-recordings/norman-dello-joio-trial-rouen) on Boston Modern Orchestra Project's recording label, [BMOP/sound](http://www.bmop.org/audio-recordings/norman-dello-joio-trial-rouen), and with the same cast that performed it in December 2017, no less! It is perhaps a necessary update: this opera was originally written as a television opera, and while I can't speak for the quality of the original television broadcast it is also a good thing that this somewhat obscure opera gets to be exposed to more people, for at the very least Dello Joio's libretto functions as an interesting dissection of Joan of Arc as a person.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1600626988/media/2020/09/OO-Trial-HeatherBuck_Orchestra_rbh6y3.jpg){{% /md %}}

<figcaption>Heather Buck (Joan of Arc) with the Boston Modern Orchestra Project under Gil Rose, 2017. Photo by Kathy Wittman.</figcaption>

</figure>

At its heart, the libretto is very much about Joan’s inner struggle throughout her heresy trial in Rouen, and going back and forth between her fear of death and her duty to God. This part of the story is quite riveting, and we get the whole gamut of emotion, even to the point that Joan technically recants in this version, before the voices of God come to her and reassure her of her purpose. It gives Joan of Arc flesh as a dignified figure who nevertheless is allowed her valid fears, and at least here she makes a compelling central figure to follow.

> The things the characters sing when nobody is accompanying them reveal quite a bit about the characters.

But what Dello Joio also does successfully is to carefully frame how the other characters and forces of the opera relate to her. His take on Pierre Cauchon is fascinating, in that Dello Joio treats him as someone whose biases are so ingrained into him he does not even realize they're there. This is best shown in the way Dello Joio lets Cauchon's darker instincts come to the fore: his rage comes out at the right moments, and I particularly appreciated the touch of classism that he lets slip in his aria right before the trial begins.

Musically, all of this is supported by some rather excellent touches: the trial alternates between harsher and lighter textures in time with the back-and-forth between Joan and Cauchon, and both of these are reflected in some very fine choral writing. There are also many moments where the dual chorus writing piles up on itself in opposition (there is a choir of Inquisitors and a choir of the common people, both who take opposing sides and reflect on the actions of the people they're supporting), and these moments are quite a sight to behold in recording. Of course, the music also lingers on Joan’s inner musings, and this is to the credit of the opera, for it highlights what works about the libretto. And this is to say nothing of Dello Joio's use of orchestral silence: the things the characters sing when nobody is accompanying them reveal quite a bit about the characters, and they're well-chosen places.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1600627061/media/2020/09/OO-Trial-HeatherBuck_2_pklkpj.jpg){{% /md %}}

<figcaption>Heather Buck (Joan of Arc) with the Boston Modern Orchestra Project under Gil Rose, 2017. Photo by Kathy Wittman.</figcaption>

</figure>

Of course, to get to what's good about the opera, you have to get through its introduction first, and the first act of this opera really drags its heels. It could have done with a few cuts, if not in the content of each scene then at the very least to cut several filler lines it could have done without. Musically, this first act is also way less interesting than the second: there are almost no tempo changes throughout, and because of this the ideas in each scene sort of blend into each other after a while, and it somewhat undermines the dichotomy that the second act accomplishes so well. To be certain, it is not enough to completely undermine the impact the second act has, but it is certainly a problem, particularly on record.

> It is good to see Odyssey Opera still producing records with times the way they are now.

At the very least, the opera was performed quite well by everyone involved, and at this point I would expect nothing less from Odyssey Opera on record. [Heather Buck](/scene/people/heather-buck/)'s searing soprano perhaps hits better in a live venue where you can see her acting, but her attention to her characterization is still on great display in this recording. [Stephen Powell](/talking-with-singers-stephen-powell/)'s voice also lends a great menace to the proceedings: his voice was always quite clear, and it inflected the character quite well. Rounding out the cast are a soulful Luke Powell as a friar who is ambivalent about the proceedings, Ryan Stoll providing a menacing turn as Joan's jailor, and Jeremy Ayres Fisher opening the work as a homesick soldier whose song sets the tone for the whole work. The choirs sang quite excellently as well, and barring one spot at the top of Act II where both choirs sang just a little bit behind the beat they provided great singing, and the audio engineers did a very good job of balancing the two ensembles as well.

It is also worth noting that this was Dello Joio's second attempt at setting the Joan of Arc story: the first attempt was withdrawn rather early after its premiere performance, and its music compiled into the Triumph of Saint Joan Symphony. This is recorded here as the first three tracks of the album, and serves as a good footnote to Dello Joio's history with the story of Joan of Arc.

It is good to see Odyssey Opera still producing records with times the way they are now: it is one way to keep opera alive in a time like this. But more than that, it also serves as a record of pieces that may not receive as much airtime as others: [_The Trial at Rouen_](http://www.bmop.org/audio-recordings/norman-dello-joio-trial-rouen) is ultimately a work deserving of a record even despite its slow start, and I for one am glad I got to catch up on it after I had missed it so long ago.