+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-01-29T11:02:00+00:00"
lastmod = "2017-01-30T10:45:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485693112326/2017-01-29---Glass.jpg.jpg"
primary_image_credit = "Philip Glass. Photo courtesy of philipglass.com."
publishDate = "2017-01-30T10:35:00+00:00"
related_articles = ["articles/a-test-of-endurance-satyagraha-at-eno.md","articles/a-warhorse-for-operas-new-world.md"]
short_description = "Alsop met Glass when she was a young violinist, and perhaps it was that familiarity with the composer and his work that allowed her to conduct the BBC Orchestra and Chorus with a focused, efficient hand. There was a settled ease to her posture that emanated into the orchestra, a physical representation of how Glass&#039; music works, which is to simply stay out of its way."
slug = "transparent-glass-the-composer-turns-80"
title = "Transparent Glass: the composer turns 80"
+++

On January 31st, 2017, Philip Glass will turn 80. The BBC Symphony Orchestra & Chorus, helped him celebrate in the only appropriate way for the famed composer of epic, trance-inducing minimalist music, by stretching the festivities over several days. Housed at London's Barbican Centre on Saturday was a day-long celebration, *Total Immersion: Philip Glass at 80*, featuring conversations and concerts of his music, and that of his contemporaries like Terry Riley, Michael Nyman, and Nico Muhly. On Glass' actual 80th, it's the Bruckner Orchestra Linz that will sing a "Happy Birthday" of sorts, by [premiering his Symphony No. 11 at Carnegie Hall](http://www.carnegiehall.org/Calendar/2017/1/31/0730/PM/Bruckner-Orchestra-Linz/).

We caught the concert at the Barbican Hall that closed *Total Immersion*; maestra Marin Alsop led the BBC Symphony Orchestra and Chorus, and pianists (and sisters) Katia and Marielle Labèque, through the Prelude to *Akhnaten* (1983), the UK premiere of his Double Concerto for Two Pianos and Orchestra (2015), and *Itaipú - a symphony portrait for chorus and orchestra* (1989).

Alsop met Glass when she was a young violinist, and perhaps it was that familiarity with the composer and his work that allowed her to conduct the BBC Orchestra and Chorus with a focused, efficient hand. There was a settled ease to her posture that emanated into the orchestra, a physical representation of how Glass' music works, which is to simply stay out of its way.

Being in the midst of history seems to be a trend in recent weeks, and so was the case with hearing Glass' music. That quintessential sound of arpeggios and ostinati is so familiar, and his layering of a sythesized keyboard under the strings seemed like a 21st-century answer to the harpsichord. His music sounds like busy cities and long journeys; it sounds as big as space travel and as minute as cells dividing under a microscope. It belongs to any and every time period, and without any context, one could impress upon his music nearly any emotional state.

Listening to Glass' music evoked a strangely specific image: a gate, slowly opening over four or five minutes of artful cinematography. His work composing film scores is one of the reasons Glass is a household name of 20th- and 21st-century music, and for a listener born in the 1980s, the sound of Philip Glass has become intistinguishable from the sound of an well written original film score. Is this instinct a result of having seen *The Truman Show* or *The Thin Blue Line* or *The Hours*, and having Glass' scores imprinted in our memory? Or is there something inherently cinematic about Glass' music? 

The answer doesn't really matter; it's more fascinating to try and figure out why a largely tonal composer, making extensive use of minimalism - a "niche" trend dating from the 1960s - gets listeners so excited. Glass' popularity doesn't come simply from his film scores. Humans gravitate towards repetition, and Glass gives his audiences many, *many* opportunities to hear and recognize musical material. His music seems as though it's about to meander, yet it doesn't lose listeners. 

Perhaps Glass really has struck that balance between experimental and familiar, or at least he's found a way of evolving musically without skipping steps. And it's no small thing that Glass started fresh with his aesthetic, after being strongly influenced by Indian classical music. It's another check in the "universal" column for his music; at a time when the world seems to recede into islands of nationalism, there's some light in the fact that people respond enthusiastically to Glass, and his extending his musical hand around the globe.
