+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = "2019-09-30T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Following its performances in Banff and Calgary, [Against the Grain Theatre's travelling production](http://againstthegraintheatre.com/la-boheme/) hits 7 more cities before arriving in Toronto on October 11. The tour concludes with three performances in Whitehorse (Nov. 4-5) and Dawson City, Yukon (Nov. 7)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1569891183/media/2019/10/sqATG_Banff-5014_txy2h3.jpg"
primary_image_credit = "The cast of La bohème, Against the Grain Theatre, 2019: (l-r) Jonelle Sills (Mimì), Marcel D'Entremont (Rodolfo), Andrew Adridge (Schaunard), Giles Tomkins (Colline), Clarence Frazer (Marcello), Danika Lorèn (Musetta) and Gregory Finney (Benoit/Alcindoro). Photo courtesy of The Banff Centre."
related_articles = []
related_companies = ["scene/companies/against-the-grain-theatre.md"]
related_people = ["scene/people/giles-tomkins.md", "scene/people/marcel-dentremont.md", "scene/people/jonelle-sills.md", "scene/people/clarence-frazer.md", "scene/people/gregory-finney.md", "scene/people/danika-lorn.md"]
short_description = "At the same time, the limited set design accentuates the quality of the music to tell the story of La bohème, from the virtuosic one-man orchestra in pianist David Eliakis, to the cast. And in a smaller space, the story becomes even more intimate and heart-wrenching."
slug = "transladapted-boheme-offers-fresh-intimate-production-for-national-tour"
title = "\"Transladapted\" Bohème offers fresh, intimate production for national tour"
youtube_url = ""

+++
If you were in Calgary, this weekend, how did you spend the snowy Saturday night? For the first time in a long time, I went to the bar. But not just any bar: this is the travelling bar of Toronto-based Against the Grain Theatre, and its touring production of Puccini's _La bohème_.

For its 10th season, Against the Grain (AtG) takes its acclaimed production of Giacomo Puccini's classic across the country. On this night, the company's convoy of minivans and U-hauls pulled into Calgary, fresh off a performance in Banff the night before. The English-language performance is a new libretto by AtG founder Joel Ivany, which includes opportunities to transplant the production from 1830 Paris to 2019 Canada. The themes, however, remain as prevalent as ever: starving artists trying to make a living in an increasingly expensive world, the bond of friendship, and the tragedy of a life cut short too soon.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569891111/media/2019/10/ATG_Banff-2182_pthmjh.jpg){{% /md %}}

<figcaption>The cast of La bohème, Against the Grain Theatre, 2019: (l-r) Jonelle Sills (Mimì), Marcel D'Entremont (Rodolfo), Danika Lorèn (Musetta) and Clarence Frazer (Marcello). Photo courtesy of The Banff Centre.</figcaption>

</figure>

To maximize the impact of these themes, the travelling set is stripped to its bare essentials: a simple apartment (consisting of a table and a couch) and a busy gathering place on Christmas Eve, in this case, a nameless, local bar for the duration of Act II. On this night, the performance space accommodated a few dozen guests, so AtG’s performers interacted as much as possible with their fellow bar patrons (i.e., the audience), drawing the guests into the action.

At the same time, the limited set design accentuates the quality of the music to tell the story of _La bohème_, from the virtuosic one-man orchestra in pianist David Eliakis, to the cast. And in a smaller space, the story becomes even more intimate and heart-wrenching.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569891124/media/2019/10/ATG_Banff-2272_o8rljs.jpg){{% /md %}}

<figcaption>The cast of La bohème, Against the Grain Theatre, 2019: (clockwise from top left) Andrew Adridge (Schaunard), Giles Tomkins (Colline), Jonelle Sills (Mimì), Clarence Frazer (Marcello), Danika Lorèn (Musetta), Marcel D'Entremont (Rodolfo), and Gregory Finney (Benoit/Alcindoro). Photo courtesy of The Banff Centre.</figcaption>

</figure>

One of the reasons I think _La bohème_ resonates with audiences is because it is a story about friendship and belonging. To truly embody these themes, much care needs to be taken into casting the right personalities who contribute their own special joie de vivre.

The AtG production is blessed to have Andrew Adridge as Schaunard and [Giles Tomkins](/scene/people/giles-tomkins/) as Colline, respectively. The chemistry between the two effectively shows how friends take care of each other in times of need, whether it be for sustenance or a laugh. Adridge is likable as Schaunard, while Tomkins' rich baritone is complemented by his character's eccentricities. Schaunard's epiphany about Mimi at the end of the opera is especially poignant, and Adridge captured this key moment well.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569891138/media/2019/10/ATG_Banff-5067_nilk4i.jpg){{% /md %}}

<figcaption>The cast of La bohème, Against the Grain Theatre, 2019: (l-r) Jonelle Sills (Mimì),  Andrew Adridge (Schaunard), Marcel D'Entremont (Rodolfo), Giles Tomkins (Colline), Danika Lorèn (Musetta), Clarence Frazer (Marcello), and Gregory Finney (Benoit/Alcindoro). Photo courtesy of The Banff Centre.</figcaption>

</figure>

Cast as both the landlord Benoit (Act I) and Musetta's ill-fated date Alcindoro (Act II), [Gregory Finney](/scene/people/gregory-finney/) makes the most of his limited stage time. The largely comedic roles allow Finney to show off his fine acting ability, whether he is singing in a drunken stupor or trying to calm his date at the shooter bar. All the while, Finney backs it up with strong vocal technique that deserves recognition.

[Danika Lorèn](/spotlight-on-danika-loren/)'s portrayal of Musetta is vivacious and nuanced, with sparkling vocals to match her acting ability. When she sweeps into the bar in Act II, her sole purpose is being noticed (certainly not on the arm of her patron), and noticed she was on this night. She is a fiery force to be reckoned with in Act III when she fights with Marcello, but it is in Act IV where Lorèn infuses an endearing vulnerability into her portrayal of Musetta that demonstrates the character is capable of looking and acting beyond self-interest.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569891152/media/2019/10/ATG_Banff-5144_spcuaq.jpg){{% /md %}}

<figcaption> The cast of La bohème, Against the Grain Theatre, 2019: (Jonelle Sills (Mimì), Marcel D'Entremont. Photo courtesy of The Banff Centre.</figcaption>

</figure>

As Marcello, baritone [Clarence Frazer](/scene/people/clarence-frazer/) commanded the stage with both swagger and gravitas. Blessed with a secure upper register, Frazer wowed the audience with even, spinning tone that enhanced his onstage presence. Frazer's work in Act III is especially noteworthy during which Marcello counsels both Mimì and Rodolfo about their relationship, before exploding into a jealous rage with Musetta. On this night, Frazer provided a well-rounded portrayal that audiences across the country will be sure to enjoy.

From the moment soprano [Jonelle Sills](/scene/people/jonelle-sills/) appears in the bohemians' apartment as Mimì, you are struck by her meekness and innocence. Sills' portrayal of the doomed Mimì exudes a purity that makes her fate all the more heart-wrenching. And while her acting is convincing, the control she has over her voice is simply mesmerizing. Her Act III aria, in which she asks Rodolfo to return her belongings, is especially powerful; the vocal colours she achieved in her anguish and resignation were perfectly matched for this intimate production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569891165/media/2019/10/IMG_0171_sny6zm.jpg){{% /md %}}

<figcaption>Giles Tomkins (Colline) in La bohème, Against the Grain Theatre, 2019. Photo courtesy of The Banff Centre.</figcaption>

</figure>

On this night, I was most impressed by the riveting, virtuosic performance of tenor Marcel D'Entremont as Rodolfo. D'Entremont enchants from his first note, full of warmth and depth as he moves seamlessly between vocal registers. His Act I aria, in which he formally introduces himself to Mimì, demonstrates his command of Puccini's difficult writing, soaring effortlessly into a euphoric lovesick climax. Equally as impressive, however, is D'Entremont's ability to support his vocal partners, namely with Frazer's Marcello and especially Sills' Mimì: never overpowering, always finding the suitable harmony to allow the music to truly sing. His is a voice opera audiences will surely celebrate for many years.

With a production as well-known and familiar as _La bohème_, it may be a challenge to find engaging ways to connect the bohemians of 19th-century Paris to modern audiences. However, with an intimate, "transladapted" production, Against the Grain offers a vehicle through which the magic of Puccini's beloved score will continue to draw audiences, big and small.