+++
author = ["authors/greg.md"]
categories = "Review"
date = "2018-03-13T16:52:00-04:00"
lastmod = "2018-03-13T16:52:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520974195611/sq---water.jpg.jpg"
publishDate = "2018-03-13T16:52:00-04:00"
related_articles = ["articles/soundstreams-musik-ende.md","articles/in-review-squeezebox.md"]
related_companies = ["scene/companies/soundstreams.md"]
short_description = "Michelle Colton, Aiyun Huang, and Ryan Scott showed what true musical versatility means, playing timpani, water (yes, they actually played the water - sometimes with cups to create a neat effect that reminded me of horses galloping through water), cymbals (which they would then dip in the water to create new effects), singing prayer bowls and that&#039;s just in the first two movements."
slug = "transfixing-soundstreams-presents-tan-duns-water-passion"
title = "Transfixing: Soundstreams presents Tan Dun&#039;s Water Passion"
+++

[Soundstreams](/scene/companies/soundstreams/) can pride itself in a tradition of presenting bold works by bold composers, and Friday night was no exception. Based on *Bach's St. Matthew Passion* (*Matthäus-Passion*) and commissioned by the Bachakadmie Stuttgart led by Helmut Rilling to commemorate 250th year of Bach's death, Chinese Composer Tan Dun's *Water Passion After St. Matthew* is a work so unique and creative yet accessible that I was transfixed. 

Dun is the last of four composers Soundstreams has presented continuing to "explore the tension between Chinese ancient cultural traditions and those in Western music." Artistic Director Lawrence Cherney noted in the program. Dun served years doing forced labour which ended with the death of Mao Tse Tung in 1976. Dun along with Chen Yi, Chen Xiaoyong, Ye Xiagong all graduated from the reopened Beijing Central Conservatory and sought "connection with Western music, though in different ways."

The stage was set up with a series of clear glass basins, lit from beneath, and filled with water. In the shape of a cruciform, it divides the stage into four quadrants. Two housing one-half of the chorus each, and the other two assigned separately to the soprano and cellist; and bass-baritone and violinist. At the four points of the cross were the conductor and the three percussionists. It was such a simple and clear design (which I believe is outlined in the score) that it moves the piece from simply being an oratorio or cantata with neat instruments to a fully theatrical piece of art. 

The choir, Soundstreams's own Choir 21 were incredible. Their dynamic range was incredible and their tuning was spine-tingling. The diction could have been a little crisper, but I'm not sure that is really a priority in this kind of a work. Their haunting harmonies and the divisions of the female and male voices added a neat dimension to the production of the sound. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520974165387/Soundstreams_TanDun_WaterPassion-122.jpg.jpg)
<figcaption>David Fallis, soprano Carla Huhtanen and Choir 21. Photo by Trevor Haldenby.</figcaption>
</figure>

Soprano soloist for the evening was the incredible [Carla Huhtanen](/scene/people/carla-huhtanen/). This kind of work seems to be her bailiwick. Infinitesimally quiet pianos and bone-rattling fortes coupled with a range that stretched from the foundations to the stratosphere, Huhtanen brought flair and artistry to Dun's piece. Bass-baritone Stephen Bryant was equally matched to this piece. With a silky-smooth melisma and a depth of range rarely called-upon for a soloist, his singing was a treat. I heard a lot of art song in his delivery. Carefully articulated and intelligently navigated, he sang a variety of roles with earnestness and grace. 

Violinist Erika Raum and cellist David Hetherington played with such care, finesse, and artistry that one forgot you weren't hearing an entire string section playing. Michelle Colton, Aiyun Huang, and Ryan Scott showed what true musical versatility means, playing timpani, water (yes, they actually played the water - sometimes with cups to create a neat effect that reminded me of horses galloping through water), cymbals (which they would then dip in the water to create new effects), singing prayer bowls and that's just in the first two movements. Another level to this piece is the addition of sampled music, done brilliantly bu Yuanlin Chen.  

David Fallis conducted this devilishly complicated piece with a tenderness and reverence that was due to both the harmonic soundscape and the textual material. The balance of all the moving parts was on point, and Fallis lead the team through a remarkable evening of music-making. Another strand of Soundstreams' programming is "foster legacy by introducing Canadians to some of the great choral masterpieces of the 20th and 21st centuries." If they continue to present works of this calibre, that legacy is more than assured. 

Soundstreams also announced its next season in their brochure, and the lineup looks to be quite exciting. Their next offering [*Freddy's Tune*](https://www.soundstreams.ca/performances/main-stage/freddys-tune/), "Bach's musical Offering in a cross-genre modern offering", is **April 21, 2018 at 8pm** at Trinity's St. Paul's Centre. 
