+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = 2023-01-18T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1673808959/media/2023/01/sq_Trade_Mary_Motorhead_Baranova-7347_dgub6p.jpg"
primary_image_credit = "Naomi Louisa O'Connell in Trade/Mary Motorhead, Prototype Festival, 2023. Photo: Richard Termine."
related_articles = ["articles/angel-s-bone.md", "articles/note-to-a-friend-matters-of-life-and-death.md"]
related_companies = ["scene/companies/beth-morrison-projects.md"]
related_people = []
short_description = "Their interaction is so believable that we feel as if we are peering through the keyhole of the motel room where they've met for their illicit encounter. We forget we're watching something on a stage."
slug = "trade-mary-motorhead-music-in-the-background"
title = "Trade/Mary Motorhead: music in the background"
youtube_url = ""

+++
When are operas more like plays with music? Answer: the double-bill _Trade/Mary Motorhead_ by Irish composer Emma O'Halloran, presented as part of the [Prototype Festival](https://prototypefestival.org/shows/trade/). The two one-act plays have compelling stories and while both are billed as operas, and both are sung-through, the music doesn't add much. In fact, in the one-person opener, the monodrama _Mary Motorhead_, the musical elements push things overboard, and in the two-hander _Trade_, even the singing feels like underscoring. It's no surprise that both pieces were originally well-written plays (by Emma's writer-uncle Mark O'Halloran) and so they form strong libretti.

What an extraordinary talent is Naomi Louisa O’Connell, who plays the titular Mary Motorhead. Her sonorous soprano and acting skills demand our attention for the entire half-hour running time of the piece. But it’s the performance and the story, the direction by Tom Creed and the co-starring lighting design by Christopher Kuhl that sell the proceedings. (The exact same thing can be said for _Trade_.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1673809324/media/2023/01/Trade_Mary_Motorhead_Baranova-3400_i7ztvh.jpg){{% /md %}}

<figcaption>Naomi Louisa O'Connell in Trade/Mary Motorhead, Prototype Festival, 2023. Photo: Richard Termine.</figcaption>  
</figure>

The character of Mary is nicknamed "Mary Motorhead" because the sorrow, anger and frustration of living in a "hole" in an Irish industrial town, drives her to heavy drinking and wild, violent behavior ("Motorhead" is UK slang for "speed freak.") She recounts her life from a jail, so we know at once that things ended badly for her. She tells us that everyone has a "big history" and a "secret history," and she promises to tell us both. And it's her private history that is the most poignant – the moments in her life when she was given "just enough hope for a girl to hang herself." A deep, close relationship ends when her only friend moves away from Ireland. The chance to finally impress her father in a sports competition ends in defeat and violence toward her nearest competitor. The love of her life slowly fades away from her and leads to one last horrible act of violence resulting in an eighteen-year prison sentence.

Although the entire action takes place against a cell wall, Christopher Kuhl's lighting (spotlights, strobes, etc.) takes us outside into distinctly different spaces.

It's all very theatrical. We get it from the words and we feel it. We don't need the relentlessly dramatic vocal music to help us get there. And where is the orchestra driving us? Ms. O'Connell has already driven us there. Some softened interludes  would certainly help – especially moments where Mary expresses sad regret. But the only respite we get in the score is a complete break from live music that gives way to electronic sampling that seems to go on forever, completely diminishing the murderous climax of her life story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1673809351/media/2023/01/Trade_Mary_Motorhead_Baranova-7250_aclra2.jpg){{% /md %}}

<figcaption>Naomi Louisa O'Connell in Trade/Mary Motorhead, Prototype Festival, 2023. Photo: Richard Termine.</figcaption>  
</figure>

_Trade_ is another well-crafted play from Mark O'Halloran, this time brought to life by Kyle Bielfield and Marc Kudisch as a young male prostitute and his older customer, respectively. Though they've met for money and sex, Mr. Kudisch's character wants something much more: a real connection and the intimacy of true understanding. After a while we come to realize that  the young escort wants the same thing and so they find their way to each other through an hour or so of sharing their life stories and current circumstances. The dialogue is so good and authentic-sounding that it could stand on its own (and does since, as noted, it's actually a play turned into a libretto.)

Mr. Kudisch is a Tony-nominated Broadway actor with a baritone worthy of an operatic stage. Mr. Bielfield boasts the punch of a superlative operatic tenor. But they are much more than that. It's one of those rare occasions when the talents run through the entirety of  the principal performers. Their interaction is so believable that we feel as if we are peering through the keyhole of the motel room where they've met for their illicit encounter. We forget we're watching something on a stage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1673809332/media/2023/01/Trade_Mary_Motorhead_Baranova-3600_ur1yph.jpg){{% /md %}}

<figcaption>Kyle Bielfield in Trade/Mary Motorhead, Prototype Festival, 2023. Photo: Richard Termine.</figcaption>  
</figure>

Unfortunately, we also forget about the music because it's all one-long recitative. Ms. O'Halloran reminds us about the music when the monotony is broken by a sudden loud or high note. But it takes us out of the storyline. When Mr. Bielfield bursts into the higher part of his range on a phrase like "I'm alright" we're impressed at the virtuosity but it's so jarring it makes his character seem mentally rather than emotionally disturbed. The orchestra is no help, either, with the left hand of the piano reminding us, too literally, that there is something potentially heart-breaking underneath the casual conversation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1673809339/media/2023/01/Trade_Mary_Motorhead_Baranova-3715_wo75wv.jpg){{% /md %}}

<figcaption>Marc Kudisch (left) and Kyle Bielfield in Trade/Mary Motorhead, Prototype Festival, 2023. Photo: Richard Termine.</figcaption>  
</figure>

Kudos again to director Creed and the lighting of Christopher Kuhl. Three unseen windows are reflected and magnified on the upstage wall. The performers are momentarily shadowed as they pass through the silhouettes of the window frames. The metaphor he creates for the illumination vs. darkness of the characters' inner lives is original and subtle. The light also reflects the passage of time in the story as the "windows" brighten into sunset and then disappear so that the wall is only illuminated by the sadness of the room's artificial lamp light.