+++
author = ["authors/jenna.md","authors/greg.md"]
categories = "Review"
date = "2017-05-25T10:53:00-04:00"
lastmod = "2017-05-25T18:08:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495724528980/2017-05-25---Square---Oksana.jpg.jpg"
primary_image_credit = "Natalya Gennadi (Oksana) and Adam Fisher (Father Alexander) in Oksana G., Tapestry Opera, 2017. Photo: Dahlia Katz."
publishDate = "2017-05-25T14:50:00-04:00"
related_articles = ["articles/in-review-rocking-horse-winner.md","articles/in-review-naomis-road.md","articles/enticing-teasers-winter-shorts.md"]
related_companies = ["scene/companies/tapestry-opera.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/natalya-matyusheva.md","scene/people/adam-fisher.md","scene/people/keith-klassen.md","scene/people/jacqueline-woodley.md","scene/people/kimberly-barber.md","scene/people/andrea-ludwig.md","scene/people/aaron-sheppard.md","scene/people/krisztina-szab.md","scene/people/alexander-hajek.md","scene/people/neil-craighead.md","scene/people/cairan-ryan.md","scene/people/aaron-gervais.md","scene/people/tom-diamond.md","scene/people/jordan-de-souza.md"]
short_description = "There&#039;s much about Oksana that&#039;s maddening. Kind and trusting people make risky and uninformed decisions, and evil people lie and harm others with no remorse; everyday people ignore cries for help from sex workers, and helpless parents, left without money or police, turn to fortune-tellers in times of desperation. Maddening as it may be - and easy as it seems to say, &quot;I&#039;m too smart to fall for that&quot; - the story of human trafficking is true and happening now."
slug = "tough-to-watch-oksana-g"
title = "Tough to watch: Oksana G."
+++

**Jenna**: "The story of sex trafficking needs to be told in a way that makes us intuitively realize how real and awful it is. We all know the facts, but we need to feel the plight of a normal girl who gets trapped in this situation; feel that it could have just as easily been us, or our sisters, or our daughters," write composer Aaron Gervais and librettist Colleen Murphy of their opera, [*Oksana G.*](https://tapestryopera.com/3-oksana-g/) "It is that kind of realization that can galvanize an individual to step up and make a difference in the lives of others. That's why this story has to be told as an opera."

**Greg**: *Oksana G.* is a dark, horrifying tale of the abuses that some more-than-unfortunate Ukrainian women were forced to endure during the rise of crime and sex trafficking following the dissolution of the USSR. This is a powerful story, borne of our times and it speaks right to the heart of a lot of discussions that are in the forefront of the minds of the general populace. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495734823004/2017-05-25---oksanag-photobydahliakatz-8579.jpg.jpg)
<figcaption>Natalya Gennadi (Oksana) and Jacqueline Woodley (Natalia) in *Oksana G.*, Tapestry Opera, 2017. Photo: Dahlia Katz.</figcaption>
</figure>

**Greg**: This piece is both timely and timeless, presenting issues that may be foreign to many Canadians - save our experience seeing it on the news. These things are still happening, and with the current state of affairs in the former Soviet Union, it seems like it's on an upswing again. Young women and children still regularly fall prey to these situations. It's not easy to watch it portrayed, but it's something more people need to see and be informed about. Once again, [Tapestry Opera](/scene/people/tapestry-opera/) finds itself at the forefront of some of the most important contemporary social discussions. 

**Jenna**: *Oksana G.* certainly leaves you with a heaviness, even a numbness. The world premiere, presented by [Tapestry Opera](/scene/companies/tapestry-opera/) is a powerful story of discomfort, horror, and worst of all, reality. With its home-grown cast and creative team, this debut production by [Tom Diamond](/scene/people/tom-diamond/) is also a moving display of the beautiful artistry we have in Canada.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495734833544/2017-05-25---oksanag-photobydahliakatz-8753.jpg.jpg)
<figcaption>Jacqueline Woodley (Natalia) in *Oksana G.*, Tapestry Opera, 2017. Photo: Dahlia Katz.</figcaption>
</figure>

**Jenna**: The score by Gervais seems to tumble forward, with evocative and painful harmonies supporting a speech-like setting of the multi-lingual libretto by Murphy. Dubbed "opera vérité", the action of *Oksana G.* moves at a pace that's almost shockingly brisk for opera. In compact scenes, we discover small-town Ukraine and meet the 17 year-old Oksana, whose home life is humble and whose friends and family love her. Within minutes, big smiles and charming naïveté give way to regrettable decisions and bewildering, terrifying circumstances.

**Greg**: Gervais' score is lovely. In the vein of a lot of current operatic compositions, the harmonic structures are lush washes of sound that the sung dialogue dances over. I would have liked to see some more variation in the overall "feel" of the piece (there's a moment when Oksana and her friends dance to a Russian folk song, and it was one of the most memorable parts of the show, due to its stark contrast to the rest of the score.) The auction scene is breathtakingly suspenseful and masterfully staged to bring about the anxiety in Gervais' score. Murphy's libretto (sung in Ukrainian, Italian and English) is as accessible as it is poetic and marries beautifully with Gervais's craftily conceived vocal lines. Under [Jordan De Souza](/scene/people/jordan-de-souza/)'s baton, the orchestra was lush and delicious and full of new and interesting colours. I did feel there was some balance issues between the stage-level pit and the singers - in particular in the high voices low registers - but the colours...#tonepainting.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495734911248/2017-05-25---oksanag-photobydahliakatz-8506.jpg.jpg)
<figcaption>Krisztina Szabó (Sofiya), Alexander Hajek (Yuri) and Kimberly Barber (Asa) in *Oksana G.*, Tapestry Opera, 2017. Photo: Dahlia Katz.</figcaption>
</figure>

**Jenna**: There's much about *Oksana* that's maddening. Kind and trusting people make risky and uninformed decisions, and evil people lie and harm others with no remorse; everyday people ignore cries for help from sex workers, and helpless parents, left without money or police, turn to fortune-tellers in times of desperation. Maddening as it may be - and easy as it seems to say, "I'm too smart to fall for that" - the story of human trafficking is true and happening now.

**Greg**: Tom Diamond has the heroic task of bringing all this to its feet - and he does so in a way that is inspiring. Masterfully using the depths created by the cavernous Imperial Oil Theatre at the Canadian Opera Company's headquarters, the scenes travel back and forth seamlessly. The treatment of Oksana not just as a victim, but a tragic heroine who takes her future into her own hands. His use of the chorus (all top-notch performers) was masterclass in staging. Kudos to designer Teresa Przybylski and lighting designer Jason Hand for bringing to life one of the best sets I've ever seen at an opera. 

**Jenna**: Teresa Przybylski's staggered looming pillars across the wide stage, with the help of lighting designer Jason Hand, seemed to morph from forest to church tower, and always seemed to obscure the full truth. Within the expansive, shadowy space of the Imperial Oil Opera Theatre, Tom Diamond took each scene and distilled it to what is universal about the business of selling people: the communication - and manipulation - of people. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495734890643/2017-05-25---oksanag-photobydahliakatz-9015.jpg.jpg)
<figcaption>Keith Klassen (Konstantin) and Natalya Gennadi (Oksana) in *Oksana G.*, Tapestry Opera, 2017. Photo: Dahlia Katz.</figcaption>
</figure>

**Greg**: The singing by everyone on stage was beautiful. Everyone was on the top of their game vocally, but where this show shines is in the dramatic portrayal of these colourful (for lack of a better word) characters. Each body on the stage was used cleanly and artistically and nothing was done that didn't drive the plot forward. I have to say that this show employs some of the most impressive *a vista* scene changes I've seen in live theatre. The cast is huge and this is the largest-scale production I've seen Tapestry produce.

**Jenna**: There was true familiarity in the cautious optimism of Oksana's parents ([Alexander Hajek](/scene/people/alexander-hajek/) and [Krisztina Szabó](/scene/people/krisztina-szabo/)), and their descent into misplaced rage, fueled by the stress of a missing child. The cheek-splitting grins of Oksana ([Natalya Gennadi](/scene/people/natalya-matyushekva/)) and her friend Natalia ([Jacqueline Woodley](/scene/people/jacqueline-woodley/)) set up a devastating u-turn when we see them next, in chains. The girls - Oksana, Natalia, and Lyuba ([Andrea Ludwig](/scene/people/andrea-ludwig/)), whom they meet "on the job" - showed a fascinating slice of how people deal differently with stress and captivity; Oksana held on to reason and hope (for a time, at least), Lyuba seemed to grow tough, and Natalia simply crumbled.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495734929070/2017-05-25---oksanag-photobydahliakatz-8958.jpg.jpg)
<figcaption>(l-r): Andrea Ludwig (Lyuba, foreground), Neil Craighead (Dima), Keith Klassen (Konstantin), and Adam Fisher (Father Alexander) in *Oksana G.*, Tapestry Opera, 2017. Photo: Dahlia Katz.</figcaption>
</figure>

**Greg**: As the titular Oksana G., Natalya Gennadi embodies the character's tragic journey wholly and honestly from start to finish. Even in her darkest moments, she still manages to let Oksana's positive lights shine through. Her strength is palpable. As her friend Natalia, Jacqueline Woodley portrays an innocent girl destroyed by the world she finds herself forced in. Her portrayal was spellbinding. [Keith Klassen](/scene/people/keith-klassen/), singing the piece's main villain, Konstantin, brings his signature steely-voiced tenor and a portrayal of a character that is equal parts charisma and danger. His layered characterization is pivotal to the girls' decision to follow him to pursue their dreams - dreams which turn to nightmares. Tenor [Adam Fisher](/scene/people/adam-fisher/) shines in the role of Canadian priest Father Alexander, who is responsible for saving some of the women sold into the sex trade. His voice was clean and bright and wrought with emotion. He employed the use of a more musical theatre vocalism which lent itself well to this modern score. I have to say, his English diction was some of the best in the show. 

**Jenna**: As sickening as it is, there's even a familiarity with the connection between Oksana and her captor, Konstantin. Konstantin (Keith Klassen) has a perverse concept of what it means to love someone; his "love" for Oksana is all-consuming, and he imposes upon her what she must do for him, as the "loved" person. Klassen's strong tenor seems to turn dangerous on a dime, and Gervais writes for Konstantin a perfect foil in Father Alexander, sung in a standout performance by Adam Fisher. The Canadian priest, whose troubled past may or may not have led to his humanitarian work in Italy, is almost too good to be true. Where Konstantin wanted things *from* Oksana, Father Alexander wants them *for* her. Perhaps in an echo of Oksana's fateful goodness, Father Alexander's flaw is falling for the trap laid by Konstantin. It's disturbing in layers, to see Konstantin jealous and accusatory towards Oksana over her relationship with the Priest; for someone who is manipulative and self-serving, perhaps it's impossible to imagine a relationship between a man and a woman that doesn't involve sex, or some form of currency exchange.

**Greg**: Playing Oksana's mother, Krisztina Szabó plays a beautiful Sofiya. Caring, warm, and matronly, her journey through Oksana's disappearance is a roller-coaster ride of emotions. The standout for me as Asa, the tarot reader, was mezzo-soprano Kimberly Barber. She absolutely shines in this role. Wisdom and clarity in a lovely smoky low register I found myself immediately captured by her presence onstage. Maria Soulis as Clara, Father Alexander's helper in Rome, sings with a bright tone and her pragmatic character were a great foil against Fisher's idealistic and romantic Father Alexander. Rounding out the cast with some stellar performances were Andrea Ludwig as Lyuba, Erica Iris, Neil Craighead, Aaron Sheppard, Cairan Ryan, and Alexander Hajek, each with a completely drawn character that was well sung and engrossing. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495734851200/2017-05-25---oksanag-photobydahliakatz-8925.jpg.jpg)
<figcaption>Natalya Gennadi (Oksana), Adam Fisher (Father Alexander), Andrea Ludwig (Lyuba), and full company in *Oksana G.*, Tapestry Opera, 2017. Photo: Dahlia Katz.</figcaption>
</figure>

[*Oksana G.*](https://tapestryopera.com/3-oksana-g/) isn't a show one "enjoys". It has staying power in the minds of its listeners, a combination of anger and numbness that follows out of Murphy's story and Gervais' homogenous, undulating score. The world premiere run plays at 227 Front St. East until **May 30th**; you can - and should - get your [tickets here](https://tapestryopera.com/3-oksana-g/). Don't miss one of th emost important pieces of theatre art produced this season.
