+++
author = ["authors/greg.md"]
categories = "Interview"
date = "2017-12-31T19:22:00-05:00"
lastmod = "2018-01-01T09:30:00-05:00"
preamble = "Each holiday season, after all the Christmas carols, Nativity pageants, and *Messiahs* are done, it's time for another holiday tradition here in Toronto, taken from the customs of Vienna and Prague: heading to the opera house on New Year's Day to guzzle champagne and see the classics like *Die Fledermaus*, *Countess Maritza*, *The Merry Widow* and *The Student Prince*. The holiday operetta has also found a home here in Canada with Toronto Operetta Theatre. \n\nTOT has been in operation here in Toronto for over 30 years, and it's the only company in Canada that focuses entirely on operetta, basically the grand aunt of today's musical theatre. This year's offering for the holiday season is the classic by composer Leonard Bernstein, *Candide*, starring [Tonatiuh Abrego](/scene/people/tonatiuh-abrego/) in the title role, and featuring [Nicholas Borg](/scene/people/nicholas-borg/) (Narrator/Pangloss/Martin), [Vania Chan](/scene/people/vania-chan/) (Cunégonde), and TOT favourite Elizabeth Beeler (Old Woman). \n\nI asked them questions about the differences between opera and operetta, what *Candide* is actually about, and what kind of music they listen to for fun. \n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1514765568210/2017-12-31---Beller%2C-Chan-We-are-Women.jpg.jpg"
primary_image_credit = "(l-r) Elizabeth Beeler (Old Woman) and Vania Chan (Cunégonde) in Candide, Toronto Operetta Theatre, 2017. Photo by Gary Beechey."
publishDate = "2017-12-31T19:22:00-05:00"
related_articles = ["articles/what-the-eff-is-a-zarzuela-anyway.md","articles/in-review-ah-mikado.md"]
related_companies = ["scene/companies/toronto-operetta-theatre.md"]
related_people = ["scene/people/tonatiuh-abrego.md","scene/people/vania-chan.md","scene/people/nicholas-borg.md"]
short_description = "&quot;I feel the piece itself is a deep commentary on the organization of mankind, a musing on the structures we put in place to prevent chaos, and a mirror into the follies of our past and in some cases our present. It is an accounting of worth through the eyes of the innocent, when we still look for the best possible world.&quot;"
slug = "tots-candide-its-very-sincere-and-passionate-"
title = "TOT&#039;s Candide: &quot;It&#039;s very sincere and passionate.&quot; "
+++

## Is this your first foray into operetta? Is this your first time working with TOT? 

**Tonatiuh**: I performed the role of Nanki-Poo in the St. Anne's Savoy Society's production of *The Mikado*. I thoroughly enjoyed the experience and comedy of the show. This is my first time with TOT and I'm very excited to be a part of it!

**Vania**: This is my fifth operetta production with Toronto Operetta Theatre. TOT feels like a home to me now, and the cast, crew and creative team are like family. 

**Nick**: In the past I've had the opportunity to work on the operettas of Gilbert & Sullivan and during my time with UofT Opera I had the pleasure of performing Benjamin Britten's seldom performed operetta *Paul Bunyan*. I am so excited to return to TOT and reunite with Derek Bate and Guillermo Silva-Marin.

**Elizabeth**: I have a feeling this is my 11th or 12th operetta with TOT.  

## How do you find operetta varies from your work in opera? 

**Tonatiuh**: Dialogue is the biggest difference for me. There's a particular style and pacing required for it and I find I need to find a vocal placement for both the dialogue and singing that doesn't tire my voice out but also keeps the energy and integrity of the story vibrant. 

**Vania**: Operetta would often be considered more lighthearted in nature when compared to opera. The challenges, however, are still the same, and I enjoy the thrill of preparing and performing a role. My goal is to be able to freely "play" on the stage and allow my character to come to life. I do admit that there is more dancing in operetta, but I actually like that.

**Nick**: The text! As the Narrator of *Candide* I have large amounts of text that are not set to music, so my job becomes painting those texts with the colours and rhythms that will convey the meanings of these narrations.

## Have you ever sung Bernstein before? How about this piece? 

**Tonatiuh**: I've performed a couple of numbers from *West Side Story*, like "Maria" and "Tonight". I've never performed this entire piece before but did a couple of numbers when I was in the emerging artist program in Calgary Opera.

**Vania**: I feel like I've come full circle when it comes to Bernstein's *Candide*. I was a member of the chorus in TOT's last production of *Candide* about 10 years ago, I'm grateful to now have the opportunity to sing the role of Cunégonde. 

**Nick**: When I was in high school I performed in Bernstein's *West Side Story*, which is perhaps my favourite musical of all time. I was Officer Krupke and a Shark. I had never danced before and that show was a baptism by fire. 

**Elizabeth**: I've sung a good deal of concert work with *West Side Story* pieces in it, most recently duet with Ben Heppner (an emergency replacement last January). I've sung "Let Your Garden Grow" in various places for charity benifits; it says so much about the simplest things we all need.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1514765862709/2017-12-31---Beller%2CChan%2C-Abrego.jpg.jpg)
<figcaption>(l-r) Vania Chan (Cungégonde), Elizabeth Beeler (Old Woman), and Tonatiuh Abrego (Candide) in *Candide*, Toronto Operetta Theatre, 2017. Photo by Gary Beechey.</figcaption>
</figure>

## When does the action of the show take place? In your own words, what is the story about? 

**Tonatiuh**: This show is a very strong critique of the human condition and all authority figures but it also is very poetic in its love and hope for humanity. 

**Vania**: The story of *Candide* features a group of characters encountering a never-ending series of unfortunate events. The lovers, Candide and Cunégonde are at the centre of the action, and both characters learn about the harsh realities of the world, of humankind, and about themselves. Overall, I feel that the moral of the story is this: rather than expecting "The Best of All Possible Worlds", we all need to do the best we can with what we have, bloom where we are planted, and "Make Our Garden Grow."

**Nick**: The action of the story takes place during the period of the Reformation and Enlightenment, when the world was beginning to open not only to new lands across the sea, but to new ideas that were at odds with the morality of the existing powers. 

Our production looks to find the universal truths that stretch past its historical framework and hold a mirror to how these hypocrisies are still present in our modern times, like the abuses of power from people who espouse the virtues of their morality. The story of *Candide* is the story of finding the truth of our own life and building a personal philosophy, and not trusting any dogma blindly.

**Elizabeth**: I feel the piece itself is a deep commentary on the organization of mankind, a musing on the structures we put in place to prevent chaos, and a mirror into the follies of our past and in some cases our present. It is an accounting of worth through the eyes of the innocent, when we still look for the best possible world.

## What is your biggest challenge in this piece? 

**Tonatiuh**: The role of *Candide* sits quite low in the tenor range for most of the show. For me, I find that it's tempting to feel like a baritone for once which, while very fun, doesn't help in the moments where high notes are written. That being said, I  love the role and music for *Candide*! It's very sincere and passionate.

**Vania**: There's no doubt that the biggest challenge for me is performing "Glitter and Be Gay", Cunégonde's famous virtuosic coloratura aria. I've sung this aria several times before, but this is the first time that I'm performing it within the context of the entire operetta; I've already discovered new things about my character. This aria is a show piece, but it's also a window into the mind of Cunégonde. I'm excited to take on the challenge, and I look forward to sharing this thrilling experience with the audience. 

**Nick**: Keeping pace with the action of the story as the characters cross the world! 

**Elizabeth**: This is a huge challenge of a piece. My husband says there's something to offend everyone in it for sure. The operetta is presenting a spectacular piece and giving a lot of young singers a chance to be challenged vocally and dramatically.

## What's your favourite part of the show? 

**Tonatiuh**: I thoroughly enjoy "Bon Voyage" and never tire of hearing it! Our Vanderdendur (Cian Horrobin) does a stellar job!

**Vania**: I could easily say that my favourite part of the show is "Glitter and be Gay", simply through pure bias and my own sentimental connections with the aria. Ha ha! In truth, there are so many fun moments and catchy tunes in the show, that it's hard to pick a favourite. I'm really swept away by the entire show. 

**Nick**: The Auto-da-Fè: The cruelty of the Spanish Inquisition juxtaposed against a big brassy musical theatre show-stopper, all the while infused with religious musical themes; it all creates a dizzying scene that is both hilarious and terrifying! It is the perfect marriage of Voltaire’s merciless satire and Bernstein’s musical genius. 

## Tell me about your character. 

**Tonatiuh**: I identify a lot with Candide. He has a relentless positivity that many people take advantage of or are quick to criticize but at the end turns out to be an immense source of strength. He undergoes an incredible emotional journey where everything he loves is taken away from him, and he is betrayed by the one thing that keeps him going, the love he has for Cunégonde. He learns from all of this and turns into a very wise and strong man. 

**Vania**: Cunégonde begins as a well-off, sheltered young girl, who dreams of even better things in life. She believes that a worldly life awaits her with gold and jewels at her feet. She is in love with Candide, who has simpler tastes and more humble expectations in life. This is a constant source of conflict for her. She is drawn to a rich and comfortable lifestyle, and would sacrifice morality and her own virtue for it. At the same time, she loves Candide and cares about what he thinks of her. Candide sees her as a pure and angelic saint, and she wants to maintain that image.

**Nick**: Which one? As Narrator I take on the guise of Voltaire, the author of the novel. Voltaire was a philosopher who wielded sarcasm as a weapon against the hypocrisy of his day, much like the late-night comedy satirists we have today. I also play Dr. Pangloss, Candide and Cunegonde's teacher, who represents the prevailing philosophy on the human condition of the time that Voltaire aimed to dismantle: that no matter what happens "all is for the best in this best of all possible worlds". I also play Pangloss’ foil Martin, who represents the polar opposite philosophy known as nihilism that nothing is for the best in this "worst of all possible worlds". Both Pangloss and Martin have a huge influence over Candide and their philosophies help to steer the plot. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1514765902323/2017-12-31---Dorado-Abrego-seated.jpg.jpg)
<figcaption>Tonatiuh Abrego (centre) in the title role of *Candide*, Toronto Operetta Theatre, 2017. Photo by Gary Beechey.</figcaption>
</figure>

## What do you hope the audience takes away from seeing this piece?

**Tonatiuh**: Beautiful, heart-wrenching music with a timeless message that is certainly relatable today. 

**Vania**: In addition to toe-tapping melodies stuck in their heads for days, I hope that the audience realizes that this operetta is such a unique and crucial piece. Through musical and comical twists, *Candide* acts as a commentary on humanity - showcasing the baseness of human behaviour - ego, greed and lust. In the end, we see that hope abounds through the simple and essential desire for connection and love. 

**Nick**: Not only will the audience leave humming the tunes, but hopefully they will take away a sense of humanity's ability to persevere in the face of overwhelming odds.

## What's on your playlist? 

**Tonatiuh**: Franco Corelli, Daft Punk, Stan Rodgers and El Quinteto Tiempo (Argentinian vocal group).

**Vania**: I was listening to different productions of *Candide* while learning the piece. As we approach the performance period, I usually like to give my ears a break, so I don't really listen to anything.

**Nick**: For space saving reasons only the current necessities are on my iPhone: the score to *Candide* and the Barenaked Ladies Christmas Album. 

**Elizabeth**: My iPod is an oldie and I have various things on it, from Dawn Upshaw to James Taylor. 

>*Candide* runs until January 7th at the Jane Mallett Theatre in the St. Lawrence Centre for the Arts. There are some great group rates and discounts available. You can get more information from the [TOT website](http://www.torontooperetta.com/shows.html) or you can buy your [tickets here](http://www.torontooperetta.com/tickets.html).
