+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = 2023-04-17T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "[Heartbeat Opera's production of _Tosca_](https://www.heartbeatopera.org/tosca-2023) runs for two more performances, on April 21 and 23, 2023."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1681780343/media/2023/04/sqHeartbeatOpera_Tosca_HBTOSCA7_or4wlh.jpg"
primary_image_credit = "Anush Avetisyan as Tosca in Heartbeat Opera's production of Tosca, 2023. Photo; Russ Rowland. "
related_articles = ["articles/in-review-tosca-at-the-coc.md", "articles/wno-tosca.md"]
related_companies = ["scene/companies/heartbeat-opera.md"]
related_people = ["scene/people/gustavo-feulian.md", "scene/people/chad-kranak.md", "scene/people/anush-avetisyan.md"]
short_description = "Shadi G can only get to her concept by imposing an element which proves to be downright distracting. She has added to the cast two non-singing members of \"the secret police\" who are ominously watching the proceedings and who even try, on several occasions, to arrest members of the cast."
slug = "tosca-at-heartbeat-opera-art-to-the-point-of-distraction"
title = "Tosca at Heartbeat Opera: art to the point of distraction"
youtube_url = ""

+++
[Heartbeat Opera](/scene/companies/heartbeat-opera/) celebrates its 10th anniversary next season and its mission is to create "radically imagined adaptations."

But it's a constant and obvious question: when do adaptations muddle a great opera and when do they enlighten? Director [Shadi G](https://www.shadighaheri.com/) has a political statement to make about the world today and has found a vehicle in one of the greatest works ever composed: Puccini's _Tosca_. The plot of _Tosca_ was originally set in 1800 Rome, but Shadi G sees a parallel and sets her production in modern-day Iran. (Supertitles are in both English and Farsi.) You can understand her impulse; the plot of _Tosca_ involves government corruption, political prisoners, sexual subjugation of women, artists victimized by an autocratic state and the hypocrisy of theocracy. However, even though the finale takes place on a rooftop with a panoramic view of Tehran in the background and assassins in modern dress in the foreground, there is little (if not confusing) connective tissue to Shadi G's concept in the preceding acts. She does change Tosca's line "What a sin! You have undone my hair" to "What a sin! You have seen my hair," a modern reference to the current anti-hijab movement, but otherwise it's the traditional Ilicia and Giacosa libretto which retains the storyline about Napoleon and Rome.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1681780508/media/2023/04/HeartbeatOpera_Tosca_ToscaCav_HBTOSCA9_eizduw.jpg){{% /md %}}

<figcaption>Anush Avetisyan as Tosca and Chad Kranak as Cavaradossi in Heartbeat Opera's production of Tosca, 2023. Photo: Russ Rowland.</figcaption>  
</figure>

Shadi G can only get to her concept by imposing an element which proves to be downright distracting. She has added to the cast two non-singing members of "the secret police" who are ominously watching the proceedings and who even try, on several occasions, to arrest members of the cast.  Another flimsy aspect of Shadi G's vision is Brechtian: we are told in the program that we aren't really watching _Tosca_ but watching actors who are trying to stage a production of _Tosca_, seemingly in defiance of the government. The politics dominate and become a wall that prevents the audience from experiencing a masterpiece as written.

What's more, the "secret police" characters are often placed on stage to completely steal focus from Puccini. There is a balcony above the stage – the very definition of "upstage" – and our eyes are frequently drawn there, such as the moment when a policeman's face is lit up by the screen from his cellphone while he checks his messages. It's rare when supernumeraries take on starring roles, but that's the net effect. From the beginning, they seem to be there to "ruin" what should be great moments – was that Shadi G's intention? On that level, she succeeded.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1681780713/media/2023/04/HeartbeatOpera_Tosca_tutti_HBTOSCA10_nfagww.jpg){{% /md %}}

<figcaption>Chad Kranak (centre) as Cavaradossi in Heartbeat Opera's production of Tosca, 2023. Photo: Russ Rowland.</figcaption>  
</figure>

Tosca herself, who is already the biggest victim in the plot, is victimized further by directorial conceit. She isn't even allowed to make her first grand entrance; the moment she appears, she is pulled back into the wings by the police and has to fight her way back on stage. It gets worse for her. The entirety of "Vissi d'arte" is performed next to an open door where shadowy moving figures are seen on the walls in the stairwell and during the final notes of what is normally one of the most heartbreaking arias in the Puccini canon, a policeman appears in the doorway with his arms crossed and we are forced to look at him.

Then, when Tosca is supposed to have her greatest moment of triumph after the murder of Scarpia, she isn't allowed to enjoy it but has to fight off the cops who try to pull her into the stairwell. Worst of all, since she’s not really supposed to be Tosca, but an "actress playing Tosca,” the drama is further undercut as she immediately becomes the main participant in a set change by the full company of actors. The set-change gimmick is used at other times – at one point even the conductor (Jacob Ashworth, who is also the Artistic Director) is drafted into service to help move an alter when the cast finds itself shorthanded (this was obviously a "well-rehearsed adlib.")

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1681780759/media/2023/04/HeartbeatOpera_Tosca_ToscaScarpia_HBTOSCA6_girvr0.jpg){{% /md %}}

<figcaption>Anush Avetisyan as "an actor playing Tosca" and Gustavo Feulien as "an actor playing Scarpia" in Heartbeat Opera's production of Tosca, 2023. Photo: Russ Rowland.</figcaption>  
</figure>

And possibly the worst of Shadi G's ideas was to improve on Puccini's score - during the set change from Act I to Act II, the cast sings a protest song sung in Farsi (and encourages the audience to clap along.) And if we didn't get it the first time – and we certainly did - an added "Poet on Roof" character with a dangling cigarette in his mouth, appears up on the balcony prior to Act III to sing the song again – only very slowly this time, as if he were composing it.

> It could also have been Shadi G's best moment, too, but here once again the policemen are upstage usurpers.

Soprano [Anush Avetisyan](/scene/people/anush-avetisyan/) (billed in the program as "an actor playing Tosca") expertly hits all the notes as does baritone [Gustavo Feulien](/scene/people/gustavo-feulian/) (billed in the program as "an actor playing Scarpia.") Their voices seamlessly slice through the air and their "singing war" in Act II is the highlight of the evening. Feulien makes a frightening and mawking Scarpia, the epitome of power corrupting absolutely. Avetisyan, perhaps hampered by the surrounding "elements," could only get to the surface with her acting, but if there is a prize for "tiniest Tosca with the grandest voice," the gamine Ms. Avetisyan would win.

[Chad Kranak](/scene/people/chad-kranak/) ("an actor playing Cavaradossi") is ineffective for almost the entire opera and there is zero passion between him and Ms. Avetisyan. The love (and lust) between Cavaradossi and Tosca, which should be the foundation of the entire story,  appears more like the flirtations of teenagers afraid to ask one another to a dance. Mr. Kranak's best moment is when he is alone during "E Lucevan le stelle." Mr. Kranak cuts a sympathetic figure as he sadly awaits execution. Blindfolded and alone on a rooftop surrounded by satellite dishes and air conditioning units, he crawls to a graffiti-covered piece of plywood where he props himself up to deliver the super-famous emotional aria. It could also have been Shadi G's best moment, too, but here once again the policemen are upstage usurpers, lighting cigarettes and making plans while Mr. Kranak sings his heart out.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1681780845/media/2023/04/HeartbeatOpera_Tosca_Cavaradossi_HBTOSCA11_f34w9y.jpg){{% /md %}}

<figcaption>Chad Kranak as "an actor playing Cavaradossi" in Heartbeat Opera's production of Tosca, 2023. Photo: Russ Rowland.</figcaption>  
</figure>

As for the rest of the chorus-less cast, Christopher Nazarian offers fine support as "an actor playing Spoletta." (There is some pre-recorded chorus when needed.)

At ninety minutes, Heartbeat Opera has cut about a half hour from the usual running time of _Tosca_. Without the cuts it's already one of Puccini's tightest and most focused of scores, so here again there is no improvement on the original. Arranger Daniel Schlosberg has reduced the orchestra to eight pieces, and has chosen to have the string section represented by only cellos and bass (no violas or violins.) He has also cut the percussion section. The result is a muted _Tosca_, figuratively and literally. He often highlights the notes from a muted trumpet player who, along with a featured piccolo, sound like they are underscoring the hijinks in a Merry Melodies cartoon. His program notes tell us he aspires to "speak even closer to the truth of what the creators intended," but he doesn't get close to the perfection that existed long before he got here.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1681780912/media/2023/04/HeartbeatOpera_Tosca_Scarpia_HBTOSCA5_g1aerz.jpg){{% /md %}}

<figcaption>"Gustavo Feulian as "an actor playing Scarpia" in Heartbeat Opera's production of Tosca, 2023. Photo: Russ Rowland.</figcaption>  
</figure>

The designers have all eagerly embraced the director's distractions. The realistic rooftop is well designed by Reid Thompson, but in his Act I church set we can’t take our eyes off the enormous crucifixion painting which serves as the cyclorama backdrop. Lighting designer Oliver Wason has been instructed to light up the policemen at inappropriate times, while his lighting on the principals changes at inexplicable moments. And costume designer Mika Eubanks is tasked with transitioning from early 19th century Rome to 21st century Tehran.  The transition happens in Act II, when Scarpia, dressed like a Roman noble, faces off against Tosca who appears in a black hijab with a silvery cape over a black turtleneck, jeans and combat boots. She's clearly ready for the ensuing battle with Scarpia (boots) or ready to be a superhero (cape.) Tosca is presented as the latter in the final moment as she dramatically, and defiantly, whips the hijab off her head and strikes a pose rather than leaping off the roof (as scripted.) We watch this ostensibly climatic moment from far away, across the distance created by all the aspects of this adaptation.