+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2015-04-10T23:41:00-04:00"
lastmod = "2015-04-12T19:53:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428723386294/Screen-Shot-2015-02-26-at-9.30.45-AM.png"
primary_image_credit = "Photo: Carla-Grace Colaguori (Zerlina) and Bradley Hoover (Don Giovanni) in Toronto City Opera's production of Don Giovanni."
publishDate = "2015-02-26T09:40:00-05:00"
related_companies = ["scene/companies/toronto-city-opera.md"]
short_description = "Wednesday night, I went to see Don Giovanni at Toronto City Opera; I don’t know much about the company, and I was most surprised to learn that they’re in their 48th season. Forty eighth! TCO’s mission is to “grow the art of opera. It will facilitate this by training young and/or inexperienced singers through an intense regimen of coaching in musicianship, stagecraft and performance.” I’m a big fan of companies who create performance opportunities for young singers. "
slug = "toronto-city-opera-don-giovanni"
title = "Toronto City Opera: Don Giovanni"
+++

Wednesday night, I went to see _Don Giovanni_ at [Toronto City Opera](http://www.torontocityopera.com/#!mission-and-vision/c1bu9); I don't know much about the company, and I was most surprised to learn that they're in their 48th season. _Forty eighth!_ TCO's mission is to "grow the art of opera. It will facilitate this by training young and/or inexperienced singers through an intense regimen of coaching in musicianship, stagecraft and performance." I'm a big fan of companies who create performance opportunities for young singers. There was a wide range of skill and experience among the cast, and for the most part the singers were still in the process of negotiating their technique and putting it into practice onstage. Because of Toronto City Opera's mission, and how much I support it, I'll refrain from writing a review in the same vein as I would for a professional company. 

This _Don Giovanni_ used full traditional sets and costumes in this production by TCO Artistic Director [Beatrice Carpino](http://www.torontocityopera.com/#!director/cb5f); the score was led by Music Director [Adolfo de Santis](http://www.torontocityopera.com/#!music-director/cd0b) and pianist[Ivan Jovanovic](http://www.torontocityopera.com/#!our-pianist/cfra). I think that what TCO does is great for artists who crave experience, and that their goal could be even better accomplished by letting the performances be much more about a process than a product. TCO is the perfect organization to offer semi-staged or in-concert productions of opera standards, leaving lots of time to work slowly on the score and text. The end result could be a workshop-like performance, free from sets and costumes, to show audiences how opera is created from the ground up. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428723444526/Screen-Shot-2015-02-26-at-9.43.38-AM.png)
<figcaption>Jackie McIntyre (Anna) and Nseke Brunot Theophile (Ottavio). Photo: TCO</figcaption>
</figure>

There's absolutely no issue with inexperienced artists performing a piece like _Don Giovanni_, and the benefit of a project like that is that the artists to learn about the stuff of opera. Tackling style, ease with the language, and the technical hurdles of the music are the real educational gems; fully staged productions are fairly common in Toronto, and I think the real audience pull for a company like TCO is the chance to get an inside look at the learning process. I'm curious about how much interaction Toronto City Opera has with the faculty and students at University of Toronto or the Glenn Gould School over the years; performance opportunities for university-level singers can be slim, and this is a great place to get singing operatic standards. It occurred to me that it could be a chance for young pianists and conductors, too; so much of their learning comes from doing, and so on-the-job experience would be invaluable. Ivan Jovanovic deserves many kudos for playing Mozart's tricky score, and there were opportunities for him to learn as well. I'm not sure if TCO recruits young pianists and conductors for their productions, but it would be fantastic chance for talented music staff like Ivan to delve deeply (with guidance) into the art of playing Mozart _recit_, and deciphering orchestral reductions. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428723593168/Screen-Shot-2015-02-26-at-9.29.50-AM.png)
<figcaption>Bradley Hoover (Giovanni) and Samantha Weaver (Elvira). Photo: TCO</figcaption>
</figure>

The TCO's impressive 48 seasons show that there are artists who want to get onstage, and that there's a creative team _and_ an audience to support them. I think more faith can be put in showing off the work singers must put into learning a foreign language, mastering technically difficult elements of their roles, and parsing the drama of their scenes. This kind of work is of most value to young artists, and translates across the stylistic board; I think the process is more interesting to the public than we may think, and with TCO, it could be worth a try. 

Toronto City Opera has one more performance of [_Don Giovanni_](http://www.torontocityopera.com/#!cast-list-by-performance/cyd4) this Saturday at 7:30pm, 777 Bloor St W. They're also putting up Verdi's [_Un ballo in maschera_](http://www.torontocityopera.com/#!cast-list-by-performance/c34s), February 27th at 7:30pm, and a 2pm on March 1st. You can find [details and ticket info right here](http://uofttix.ca/view.php?id=1141).
