+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2018-02-25T18:51:00-05:00"
lastmod = "2018-02-25T19:19:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1546218548/media/2018/12/Miles-Alissa.jpg"
primary_image_credit = "Miles Mykkanen and Alisa Jordheim in Candide, Palm Beach Opera, 2018. Photo: Bruce Bennett."
publishDate = "2018-02-25T19:19:00-05:00"
related_articles = ["articles/candide-the-best-of-all-possible-productions.md", "articles/just-plain-great-pbos-le-nozze-di-figaro.md", "articles/grappling-with-daily-life-wnos-candide.md"]
related_companies = ["scene/companies/palm-beach-opera.md"]
related_people = ["scene/people/tobias-greenhalgh.md", "scene/people/kasia-borowiec.md", "scene/people/miles-mykkanen.md", "scene/people/alisa-jordheim.md"]
short_description = "&quot;How can such ghastly horrors befall a world where all is for the best?&quot; Candide asks. We may not live in the best of all possible worlds, but when the music fades and the curtain falls, it&#039;s our job to try and make the world a little better."
slug = "too-many-jewels-the-search-for-meaning-pbos-candide"
title = "Too many jewels &amp; the search for meaning: PBO&#039;s Candide"

+++
Any opera containing the line "I am, I admit, extremely fond of the potato" is, one can safely assume, not meant to be taken too seriously. Yet [Palm Beach Opera's _Candide_](https://pbopera.org/event/candide/), which opened on February 23, took on sombre meaning in a region still reeling from the tragic shooting at Stoneman Douglas High School only a week earlier.

"30,000 people pointlessly die – probably for the best of all possible reasons," remarked narrator Pangloss – portrayed by Broadway habitué Ron Raines – upon the siege of Westphalia and the massacre of its eccentric residents. Though Raines recited the words with lighthearted sarcasm, the circumstances beyond the sheltering walls of the concert hall wove poignancy into the cynical libretto. The quip may well have been parroting any number of Second Amendment apologists who have paraded across the news cycle over the past ten days: Seventeen teenagers are dead, but at least our freedom is intact. All's for the best.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1546218645/media/2018/12/Ron-Miles.jpg)<figcaption>Ron Raines and Miles Mykkanen in _Candide_, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

PBO's _Candide_ lent itself well to darker musings in a performance that excelled musically but struggled comedically. Tenor [Miles Mykkanen](/scene/people/miles-mykkanen/) in the title role sang with resonance and spot-on spirit, delivering a show-stopping "It Must Be So." Clad in lederhosen, Mykkanen's _Candide_ was grinning and guileless – a definite highlight. Opposite Mykkanen, soprano [Alisa Jordheim](/scene/people/alisa-jordheim/) aced Cunegonde's coloratura pyrotechnics with a clear voice and thoughtful interpretation, and her duets with the tenor were warmly sung. Musically, Jordheim's "Glitter and Be Gay" was winningly executed, but was unsettled by awkward staging: while Cunegonde fumbled with one too many pieces of prop jewelry, the witty text and playful score were forced to do the comedic heavy lifting.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1546218513/media/2018/12/Denyce-Graves2.jpg)<figcaption>Denyce Graves in _Candide_, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

Overall, comic timing was off. Jokes landed a second too late, with overplayed dialects muddling the punchline. Maybe the problem was logistical: spoken lines were aided by neither supertitles nor amplification – a fact which hurt superstar Denyce Graves's heavily accented monologue as The Old Lady. The moment that received the most laughter was a cameo by PBO's beloved General Director, Daniel Biaggi, as the Completely Unknown Stranger who recruits _Candide_ to fight for the Jesuits in Montevideo.

As saucy servant girl Paquette, soprano [Kasia Borowiec](/scene/people/kasia-borowiec/) sang brightly and with zest. Baritone [Tobias Greenhalgh](/scene/people/tobias-greenhalgh/) caught big laughs as a vain – and totally fabulous – Maximilian, singing the role with whimsy and finesse.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519602274576/Alissa%2C-Denyce.jpg.jpg)
<figcaption>Alisa Jordheim and Denyce Graves in _Candide_, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

Scenic projections by designer Jerome Sirlin lent the production the oversaturated aesthetic of a 1990s PC game, complete with oversized text in Microsoft Word standard fonts identifying the location of each scene. The overstated designs underestimated the audience's imaginations – yet, paired with Voltaire's outlandish plot and Bernstein's no-holds-barred score, a cartoonish backdrop of neon-coloured Dutch-colonial architecture didn't seem too out of place.

The Palm Beach Opera Chorus sang strongly, and had obvious (and infectious) fun cheering on the victims of an auto-da-fé, waltzing in a Parisian ballroom, and transforming into a herd of singing golden sheep. The a capella finale was breathtaking: "We're neither pure nor good nor wise," they sang. "We'll do the best we know \[...\] and make our garden grow."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519602334431/Tobias-G.jpg.jpg)
<figcaption>Tobias Greenhalgh in _Candide_, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

At the time of the operetta's premiere in 1956, Leonard Bernstein and a coterie of librettists – including Lillian Hellman and Stephen Sondheim, among others – were commenting on a post-war reality, where the horrors of the Holocaust still resonated and the dangers of McCarthyism ran rampant. With 2018 marking Bernstein's centennial, opera-goers around the world have no grounds to complain about a shortage of _Candide_'s this season. It's worth considering, then, what a performance of _Candide_ means in 2018. Is "The Best of All Possible Worlds" a portrayal of white privilege? Is "Make Our Garden Grow" a call to action?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519602410524/Miles.jpg.jpg)
<figcaption>Miles Mykkanen in _Candide_, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

Opera often has the power to transport us for an hour or three, but PBO's _Candide_ was a striking reminder of opera's power to reflect the world we live in. "How can such ghastly horrors befall a world where all is for the best?" Candide asks. We may not live in the best of all possible worlds, but when the music fades and the curtain falls, it's our job to try and make the world a little better.