+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-01-07T09:38:00-05:00"
lastmod = "2015-04-12T10:45:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428849839104/Gorilla-Opera.jpg.jpg"
publishDate = "2015-01-07T09:38:00-05:00"
related_articles = ["articles/adele-knowing-your-audience.md","articles/practicing-spontaneity-be-like-hillary-not-like-donald.md","articles/the-one-mustpack-item-for-any-summer-program.md"]
short_description = "In opera circles, one of the beloved stories of innocent lay-person ignorance is the old chestnut: “Oh you’re an opera singer? Can you sing something for me right now?” The implication of this hypothetical, that it’s utterly ridiculous to ask an opera singer to demonstrate his or her skills, is really telling of characteristics unique to classical musicians. For trained opera singers, the concept of spontaneity is, for some reason, unwelcome."
slug = "to-dance-for-grandma-or-the-spontaneity-question"
title = "To Dance for Grandma, or the Spontaneity Question"
+++

<p>In opera&nbsp;circles, one of the beloved stories of innocent lay-person ignorance is the old chestnut: "Oh you're&nbsp;an opera singer? Can you sing&nbsp;something for me right now?" The implication of this hypothetical, that it's utterly ridiculous to ask an opera singer to demonstrate his or her skills, is really telling of characteristics unique to classical musicians. For trained opera singers, the concept of spontaneity is, for some reason, unwelcome.</p><p>Although it may be the easiest for singers to demonstrate&nbsp;their skills for&nbsp;curious water-coolerites (a phlegm check and a good breath can be enough to show off one's best high notes), the aversion to spontaneity is a common trait across classical music disciplines. As a young pianist, I was nervous&nbsp;to play for family and friends on a whim, and didn't do it all that much. I was aware that I had put much time and effort and love into the piano, I feared my little pop-up concert wouldn't do any of it&nbsp;justice. Conversely, my brother first learned to play guitar by ear (he has a naturally great ear, by the way). That may not be the common reason&nbsp;for hesitancy amongst classical musicians, but it's certainly a trait found less in artists of other genres.</p><p>Of course, my brother and I aren't representative&nbsp;of all&nbsp;other musicians who work either in or&nbsp;outside of the Classical genre, but in my own experience with musicians, this sort of difference temperament is generally on par. So why are classically trained musicians less spontaneous with their skill? Why don't more opera singers, for example, jump at the chance for an impromptu, off-the-cuff performance upon request? As a pianist myself, I used to tell myself that I was off the hook for plenty of these unplanned "performance opportunities" because the piano itself isn't very portable. But that excuse doesn't fly for flautists or violinists, and it definitely doesn't hold weight around singers, who bring their instrument everywhere they go by default.</p><p>Opera singers have spoken to me in the past about this conundrum. There seems to be a lot of focus on the risk of vocal health versus the potential gain of applause. An unexpected show probably means that the singer won't have time for their usual warm-up, along with a myriad of other unknown factors like acoustics and available pianists for accompaniment. Plenty of singers, understandably, don't want to risk unhealthy singing by foregoing their technical process for the sake of some demanding party guests. But are opera singers, like other classical musicians, held captive by&nbsp;the long list of variables that need to be in order for them to practice their craft?</p><p>A working singer's list probably includes the aforementioned warm-up routine, a pianist and a conversation with said pianist, and a knowledge of the space acoustics. I think there are two more pieces to the puzzle, in which the real problem lies. The first seems petty, but it isn't: small spaces stress out opera singers. I'm not talking black-box-theatre small, I'm talking your aunt's kitchen or living-room small. In close quarters, singers can feel like they need to make a choice between using their "full voice" and perhaps deafening their friends and family, or shrinking away from their full sound and exacerbating the above concern about vocal health.</p><p>Finally, there's the question of context. Why are all these people here? Is it for a concert or concert-like event, in which case one can assume that everyone who is there wants to hear music? Or is it a random social gathering, mixed with people who are curious about the Classical Musician in their midst, and people who really&nbsp;don't care? If it's the second case, there's an enormous risk of performing for an unwilling or apathetic audience. I'm sure any musician would tell me that he detests that idea, and I think classical musicians are even more tender about it. In the case of opera singers, I don't blame them. It's a pretty vulnerable thing, to sing for people in close proximity, let alone to sing for people who didn't come to this party to hear opera. Ouch.</p><p>In all honesty, these hypothetical events are usually a low-risk environment for impromptu concerts. The audience of curious friends and acquaintances will most likely be impressed with our performance, regardless of the disproportionate standards we hold privately for ourselves. So why do we so often feel that spontaneous shows don't really exemplify our skill? Do we feel as though we need to communicate to our audience the hours upon hours of work put into what they're hearing?</p><p>Perhaps this timid-seeming temperament of classical musicians comes from the way they were trained.&nbsp;We're educated over long periods of time and in very formalized ways; much like professional athletes, we put in hours of training that are grossly disproportionate to the hours spent in performance. I think it's fair to say that musicians who work in jazz, blues, Irish fiddle music, etc., get onstage more often and earlier than classical musicians. Gigs in bars, jam sessions, fumbling around by ear on a guitar, are all hugely educational for any musician; players and singers can learn how to make music as a group, how to lead and follow, how to take a solo and how to accompany, and how to do it all in front of an audience. In an opposite approach, classical musicians are generally taught to practice first, and perform the finished product later. Imperfection in public is not a big part of our training, and the values of improvisation are often overlooked.</p><p>But, you know, there really&nbsp;<em>is</em> something different about so-called classical music. Compared to pop, rock, and a lot of jazz, the music is more complicated, and it demands more technical facility. The pieces we perform exist independently of our particular interpretation, and the act of writing music is held at a high value. When singers turn down an invitation to show off their chops, it may be &nbsp;justified; it may be true that our music deserves a certain&nbsp;ceremony around its performance, to match the effort that went into writing it in the first place.</p><p>In the spirit of fairness, I present to you an example of what can happen when classically trained musicians have the skill and freedom to improvise. For&nbsp;an encore, violinist Anton Kontra leads pianist and comedian&nbsp;Victor Borge through <a href="http://imslp.org/wiki/Cs%C3%A1rd%C3%A1s_%28Monti,_Vittorio%29" target="_blank">Monti's Czárdás</a>. The fun part: Victor hadn't played the piece before. This makes me smile more than most things.</p><p><figure data-type="video"><iframe src="//www.youtube.com/embed/tvUbrbFdJ8g" width="420" height="315" frameborder="0" allowfullscreen="allowfullscreen"></iframe></figure></p>
