+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-11-13T17:19:00-05:00"
lastmod = "2015-11-14T12:45:00-05:00"
preamble = "[Toy Piano Composers](/scene/companies/toy-piano-composers/) is a Toronto-based collective of composers, currently in their eighth season of concerts presenting their new works. Next Saturday, November 21st, they're holding their next event, [*To Be Announced III*](https://www.facebook.com/events/1626884627575817/), a showcase of world premieres by five emerging composers, selected from their most recent call for works. Joseph Glaser, James Lowrie, Patrick McGraw, Julia Mermelstein, Matthew Tozer, and Xintong Wang will have their works premiered by the Toy Piano Composers Ensemble: Tim Crouch (flute), Anthony Thompson (clarinet), Etienne Levesque (percussion), Wesley Shen (piano), Sharon Lee (violin), Adam Scime (double bass), and Pratik Gandhi, conductor. \n\n*To Be Announced III* also features guest singers [Maureen Batt](/scene/people/maureen-batt/) and [Jesse Clarke](/scene/people/jesse-clark/), who were kind enough to give us an inside look at their process, and what's exciting about premiering new works."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447453410267/2015-11-13---TPC-Poster.jpg.jpg"
publishDate = "2015-11-14T12:44:00-05:00"
related_companies = ["scene/companies/toy-piano-composers.md"]
related_people = ["scene/people/maureen-batt.md","scene/people/jesse-clark.md"]
short_description = "Toy Piano Composers is a Toronto-based collective of composers, currently in their eighth season of concerts presenting their new works. Next Saturday, November 21st, they&#039;re holding their next event, To Be Announced III, a showcase of world premieres by five emerging composers, selected from their most recent call for works."
slug = "to-be-announced-iii-new-music-via-toy-piano-composers"
title = "To Be Announced III: new music via Toy Piano Composers"
+++

## 1. How do you approach learning a brand new piece of music? 

**Maureen**: For me, the biggest consideration for learning a contemporary piece of music vs. a piece from more traditional repertoire is that I might not be familiar with the composer’s musical language. If someone hires me to sing a Mozart or Puccini opera role, I know exactly what that will entail in terms of my hours of practice and in terms of how I’ll be using my voice. When I’m learning a piece by a composer whose work/works I have not yet sung, I build in some extra time to get familiar with the language. 

No matter the time period of music, I start with learning the rhythms. There aren’t necessarily more markings in my scores for new music—say, compared to all the translations I’ve have written in a Strauss score, but there are definitely more colours. I work with pencil crayons (whoa: flashback to my fourth year theory at Dalhousie), or erasable, coloured pens. I indicate meter changes, where my pitches or sounds might be coming from, and then whatever other “art work” might be needed to help me solidify the piece.

**Jesse**: Assuming there is text, I always start there. I try to read through it in a very general way, nothing too intense. I try to find something interesting in the language. A clever turn of phrase. A well-formed thought. A cool word. Something that excites me or makes me curious. Something that I will look forward to saying. An anchor. Then I add melody/harmony/rhythm and work from there. Just one or maybe two little spots. After that I start branching out from that root. I think this approach works for me because I am always intimidated by the piece as a whole. Any piece, really. They always seem gigantic when you first sit down. 

Now, if there is no text, or the text supplied is banal doggerel…I’m a sucker for a good melody. So I try and find one of those. If not, a harmonic moment. If not, I say screw it and start at the beginning. After I feel somewhat comfortable with the pitches/rhythm etc. all the work becomes dedicated to creating a character that fits into that particular structure. 

I try to approach traditional repertoire the same way. It’s difficult though. It’s easy to rely too heavily on recordings, at least for me it is.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447522033037/2015-11-14---Maureen-Batt.jpg.jpg)
<figcaption>Maureen Batt, soprano.</figcaption>
</figure>

## 2. Have you been able to work with the composer on these pieces? How does that input affect your own interpretation of the music?

**Jesse**: Haven’t worked with these composers yet. We will get to do more of that next week. A composer’s input always affects my interpretation. It has to. As I said earlier, I try to create a fully realized character and bring that point of view to the rehearsal. However, I feel that a big part of my job is to try to actualize a composer’s vision and give a truthful and accurate rendition of the piece. So if the character that I’ve created is incongruent with the composer’s intentions, I have to change my original plan. 

It’s fine to say that I would like the piece to be at a particular tempo, or change this and that note, or I’d like to play this character as a lost Manitoban goat-herder etc. But if the composer says “absolutely not” or “yes” to one thing and “maybe” to something else, I have to reorganize and adapt. I have to make it work. This goes for conductors and directors as well btw.

**Maureen**: We met the composers this week at the orchestra rehearsal! We’ll be working more intensely with them this week as our rehearsals gear up. The composers’ input always affects my own interpretation of the music, particularly when we get the chance to work them in person in a mini workshop format. One of the coolest things for me about singing new music is that I can email or call the composer to talk about his/her piece (or, let’s be honest, go for a beer with the composer to talk about his/her piece).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1447522070678/2015-11-14---Jesse-Clark-resized.jpg.jpg)
<figcaption>Jesse Clark, baritone.</figcaption>
</figure>

## 3. What sort of connection exists between you and the TPC?  What can independent opera and concert organizations learn from each other to succeed?

**Jesse**: My connection to TPC is through [Essential Opera](/scene/companies/essential-opera/). They originally put on a triple-bill of new Canadian works that featured the compositions of the three artistic directors of the TPC. I was fortunate to be cast in Elisha Denburg’s *Regina* and a previous incarnation of Chris Thornborrow’s *Selfie*. Monica Pearce’s *Etiquette* was scored for three ladies so I missed out on the hat-trick. I guess they got desperate and hired me for this? You’d have to ask them.

In terms of learning from each other...I think the most important stuff is really about sustainable development. Business strategies, marketing, long term planning, budgeting, branding, fundraising, tax benefits/exemptions, hiring, sponsorship, contracts, liability, payroll, grant applications, crafting a good mission statement, how to find good board members. etc.

**Maureen**: I have performed on two other TPC concerts – *SMILE!* (2010) and *Opera Scenesters* (2012) and had a blast!! Additionally, in personal projects and projects with Essential Opera, I have premièred works by Fiona Ryan, Monica Pearce, Elisha Denburg, and Chris Thornborrow. The TPC clan is full of some of my favourite people and I’m positively delighted to be working with them again on this project, *TBA3*. What better project than to foster more new music, and emerging composers!

You don’t have to look far around the country to sense a great source of creative energy – we have a lot of arts collectives and groups being run by 30-somethings and we’re all in this party together.

>*To Be Announced III* happens at 8pm on November 21st at The Music Gallery, 197 John St., Toronto. For details and ticket info, follow the box office links below.
