+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2017-01-24T10:39:00+00:00"
lastmod = "2017-01-24T17:17:00+00:00"
preamble = "Sometimes a tremolo is just a tremolo, but sometimes there's more to it than that. Pianists, when you're playing orchestral reductions of opera scores, the pages can seem littered with tremolos. At worst, they can make you feel like you're a living player-piano in an old saloon; at best, they offer the textures and forward propulsion that can make an orchestra such a thrilling beast.\n\nWe've summed up three big categories of tremolos that pop up in the pages of piano-vocal opera scores, and how to make them all sound as orchestral as possible."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485272563514/2017-01-23---Tremolo.jpg.jpg"
publishDate = "2017-01-24T17:11:00+00:00"
related_articles = ["articles/the-opera-pianists-list-o-priorities.md","articles/pianists-3-tips-for-sounding-like-an-orchestra.md","articles/the-pianists-tech-week-plight.md"]
short_description = "In a case like this, sometimes a slower tremolo yields better results on the piano. If you try for speed, it&#039;ll likely sound a bit drier, a bit more percussive; a slow tremolo lets you just sit in the sound that already exists, and your muscles will be relaxed enough to sustain it."
slug = "tips-for-pianists-how-to-tremolo-like-a-pro"
title = "Tips for pianists: how to tremolo like a pro"
+++

## When it's the timpani

When it's written down in the bass, there's a good chance that a tremolo marking in a piano reduction is there to imitate a timpani roll. A timpani certainly has pitch in its sound, but it's less acute than the sound of low piano octaves. Sometimes a timpani is there to add gorgeous warmth to the harmonies above it, like in this section from *La bohème*:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485255812135/Tremolo---La-boheme.jpg.jpg)
</figure>

See the tremolo half notes in the piano's left hand? The harmonies come from the cellos and violas, and the timpani is there too, holding a low E throughout the phrase. That E pitch isn't necessarily vital to hear; what's important is the constant sense of rumbling - sexy anticipation, really.

A fun way to play this is to forego the written left hand tremolo notes, and instead opt for an extra low octave in the bass. So, in the first measure, you'd play the full A major harmony on the downbeat, and throughout the rest of the bar, you do a gentle octave tremolo between E1 and E2. It's a great way of clearly indicating each shift in harmony, while maintaining that exciting low rumble. That timpani tremolo should be the softest layer in this section; imagine that the alternating octave sound like one continuous note.

In other cases, a timpani roll is a solo moment. Have a look at the opening of Verdi's *Il trovatore*:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485276976293/Tremolo---Il-trovatore.jpg.jpg)</figure>

Those low tremolo Es in the left hand are timpani solos. If you've ever heard a timpani do a crescendo out of nothing, you know that there's a second or two at the start where you're not even sure if the timpanist is playing. Like in the *Bohème* example, the goal here is to  avoid hearing two different notes, and achieve a uniform, sustained sound instead. 

Instead of starting the timpani solo with a single note, start with a solid octave; it helps to blend the initial attack into the tremolo. As you get louder and louder, imagine that it's just the lower octave note doing the crescendo. Depending on the piano you're using, it can even help to do this bit with two hands. 

## When it's the strings

In piano reductions, tremolos can also stand in for string action. String players achieve a tremolo with short, quick bow strokes; as a full string section, the effect is a sustained chord that can shimmer or tremble. There's a good example in Radamès' aria from Verdi's *Aida*:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485255794180/Tremolo---Celeste-Aida.jpg.jpg)
</figure>

That high F in the second bar comes from the violins, who play *con sordina* (muted). Remember that *con sordina* marking when you come to the accent on the first high F; Verdi wrote it in the context of a really soft moment for the violins, so it's not a Liszt-like piano accent. When you listen to this aria, the violoins sound a bit like they're coming in late; don't be late, but pay attention to how long it takes for a muted string sound to become audible.

The high F starts as a regular note, and then turns into a tremolo where it's indicated in the piano score. An octave tremolo is a good approximation for a piano in this case; remember though, that the violins are really only playing the highest F. Be really gentle with the bottom octave as you play the tremolo. It takes some imagination, but the idea is simply to add a new colour to the F, which joins in the sound made by Radamès.

In a case like this, sometimes a slower tremolo yields better results on the piano. If you try for speed, it'll likely sound a bit drier, a bit more percussive; a slow tremolo lets you just sit in the sound that already exists, and your muscles will be relaxed enough to sustain it.

Sometimes, string sections create a whole tremolo chord, like in this example from *La bohème*:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485255821153/Tremolo---La-boheme-2.jpg.jpg)
</figure>

The right hand in this line is taking care of the violin section, where the players build a chord out of tremolo notes. With a section like this, a pianist's first instinct might be to rock the hand back and forth, their fingers playing the triads at the "top" of the tremolo, and their thumb playing the lower single note. But because this isn't piano music, the pianist has to imitate *how* a section of violins would tremolo; each violin player is doing a tremolo on one single note, not alternating between two notes.

To get closer to this effect on the piano, try beginning each shift in harmony with a full, solid version of the chord; once you've played the full chord, you can continue with the tremolo effect. 

So, start this line by playing all four notes in that C major chord, and in the fourth measure, do the same with the new D minor chord. One trap to avoid: be careful about getting to percussive with downbeats; remember that each violin player has a long, sustained melody of tremolo notes, not a series of accented chord changes.

## When it's the woodwinds

It's a rarer find, but sometimes woodwind instruments play tremolos too. This is good news, because flutes and clarinets create a tremolo effect with a similar technique to pianists. We wanted to show you an example from the last two pages of Britten's *The Rape of Lucretia*, but the score isn't yet in the public domain. Instead, here's a short example, from Verdi's *Falstaff*:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485275649394/Tremolo---Falstaff.jpg.jpg)
</figure>

The tremolos in the left hand are strings, but there's also a clarinet playing with them. The clarinet plays a low D and F, alternating quickly between the two notes; compared to imitating strings, it's easier for pianists to "be woodwinds". Each of the two notes sounds more clearly in woodwinds than they do in strings, and they cut more easily over an orchestra; pianists can afford to be more soloistic and "notey" when they're imitating winds.

>Pianists, what are your go-to tips for making an orchestral tremolo? Let us know in the comments below!
