+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-04-21T20:33:00-04:00"
lastmod = "2017-05-03T10:01:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493751481295/2017-05-02---LINDSEY-kate.jpg.jpg"
primary_image_credit = "Baptiste Trotignon & Kate Lindsey. Photo by Richard Dumas/Alpha Classics."
publishDate = "2017-05-03T09:44:00-04:00"
related_people = ["scene/people/kate-lindsey.md"]
short_description = "Listening to Thousands of Miles is a complete treat. Lindsey&#039;s clear, warm mezzo is certainly versatile, but she has also chosen her repertoire wisely. It&#039;s the sound of the Weill songs that seems to inform the rest of the music on this album; though the songs by Zemlinsky, Korngold, and Alma Mahler can easily fall in the world of late-Romantic German Lieder, there&#039;s a delicious flavour in the way Lindsey and Trotignon perform them."
slug = "thousands-of-miles-its-raw"
title = "Thousands of Miles: &quot;It&#039;s raw.&quot;"
+++

"We were really, really coming from two different worlds," says mezzo-soprano [Kate Lindsey](/talking-with-singers-kate-lindsey/) about working with jazz pianist [Baptiste Trotignon](http://www.baptistetrotignon.com/) to create her new album, [*Thousands of Miles*](https://www.amazon.co.uk/Thousands-Miles-Kate-Lindsey/dp/B06Y5T4BWJ/ref=sr_1_1?s=music&ie=UTF8&qid=1492278601&sr=1-1&keywords=thousands+of+miles), available **May 19th**.

Lindsey and Trotignon have recorded music by Kurt Weill, Alma Mahler, Alexander von Zemlinsky, and Eric Korngold. For lovers of that delicious early 20th-century sound that blends the German/Austrian aesthetic with the broad optimism of American Hollywood, *Thousands of Miles* is a bit of a musical jackpot. "I'd say it's raw, which really attracts me," says Lindsey. "There's this sense of searching in all these pieces. Tonally, they're searching for something. The text is very luscious, and it's all about a really intense romantic love."

The album marks the first fruits of Lindsey's collaboration with Trotignon, a process which began in Paris. "I took the Eurostar down with this massive bag of music and papers," Lindsey laughs. "I pulled it out, and he just looked at me like, 'Oh my gosh.'"

With her early background in musical theatre, and her professional experience as an opera singer, the mezzo-soprano chose repertoire for *Thousands of Miles* with an approach centred on text and historical perspective. Trotignon offered an important balance, in that "he's all about the sound."

"He would say, 'I think these things fit together nicely,' because as a jazz pianist, he could feel the emergence of jazz in the classical pieces." 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493751533039/2017-05-02---Kate2016a--c-Richard-Dumas_Alpha-Classics.jpg.jpg)
<figcaption>Kate Lindsey. Photo by Richard Dumas/Alpha Classics.</figcaption>
</figure>

Listening to *Thousands of Miles* is a complete treat. Lindsey's clear, warm mezzo is certainly versatile, but she has also chosen her repertoire wisely. It's the sound of the Weill songs that seems to inform the rest of the music on this album; though the songs by Zemlinsky, Korngold, and Alma Mahler can easily fall in the world of late-Romantic German *Lieder*, there's a delicious flavour in the way Lindsey and Trotignon perform them. 

With jazz, Lindsey explains, "you really stick with a steady beat, and within that steady pulse, you do whatever you want to do." It's a stylistic trait that challenges the stretchy, *rubato*-filled tempos of music on the classical side of the spectrum; as though they represented two musical styles, Lindsey and Trotignon each made their case for moments of flexibility, and moments of rigidity.

"In classical music, there's a lot of *rallentando*, you pull back, you can stretch," says Lindsey. "[Trotignon] looks at that and says, 'but why?' It's a really good question, 'why?'"

The result is fascinating; instead of indulging in every elastic moment, smelling every rose, Lindsey and Trotignon let the songs speak for themselves, making you want to rewind and listen to it again.

The pair are already looking ahead to live performances, rooted in their work on *Thousands of Miles*. "It's the type of disc that we feel is a real concert," Lindsey says. They have a handful of dates set for Paris in autumn 2018, and "we're trying to do something in London as well."

With a common ground established, to hear Trotignon and Lindsey in a live setting is not something to be missed; they may come from "different worlds", but they both have deep roots in performing for a live audience. 

Lindsey is already excited about how their partnership can evolve onstage. "What I would enjoy about it is the fact that it's always changing, what Baptiste does always changes."


*Thousands of Miles* is released on Alpha Classics on **May 19th**. Pre-orders are available [here](http://katelindsey.com/thousands) and [here](https://www.amazon.co.uk/Thousands-Miles-Kate-Lindsey/dp/B06Y5T4BWJ/ref=sr_1_1?s=music&ie=UTF8&qid=1492278601&sr=1-1&keywords=thousands+of+miles). For a sneak peek, check out the mini-documentary below:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/A6rNJY_S36A" frameborder="0" allowfullscreen></iframe>
</figure>
