+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2017-11-10T18:59:00-05:00"
lastmod = "2017-11-11T12:50:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510358744624/2017-11-10---square---TPIV05cBenjamin_Heller.jpg.jpg"
primary_image_credit = "Andrew Mayer, Eddie Rodriguez Jr. (background) in Thomas Paine in Violence, 2017. Photo: Benjamin Heller."
publishDate = "2017-11-10T19:39:00-05:00"
related_articles = ["articles/nasty-women-great-operas-opera-5s-suffragette.md","articles/5-people-who-would-make-great-opera-roles.md"]
short_description = "Enthroned eight feet off the ground, she presides like an oracle. Below is bedlam. Four hyperactive, dapper, brown men run her subconscious. The &quot;Manchorus&quot; (played tirelessly by Paul Pinto, Andrew Mayer, Christian Luu, and Eddie Rodriguez Jr.) frenetically shuffles about, sharply turning and gesturing, maneuvering papers, tables, panels, electronics, and punctuating Paine&#039;s speeches with tight, high, vocal stabs for dramatic and comedic effect."
slug = "thomas-paine-in-violence-must-be-witnessed"
title = "Thomas Paine in Violence &quot;must be witnessed.&quot;"
+++

During the Obama administration, America's ship was turning in the right direction for progressives. Social programs developed. People fantasized about ideas far on the horizon becoming realities like universal health care and universal basic income. Not so today, as the left wades through the daily fog of egocentrism and hatred tweeted out by our bungling Huckster in Chief. How would America's founders reconcile today's frightening mess of a nation?

Thomas Paine, the subject of Paul Pinto's frenetic, must-see, new opera, would probably despair at the widened gap between rich and poor, and at the cowardice of today's politicians beholden to corporate interests, eager to sacrifice moral values for political capital. Paine's essay [*Agrarian Justice*](https://en.wikipedia.org/wiki/Agrarian_Justice), the source material for [*Thomas Paine in Violence*](http://here.org/shows/detail/1926/), argues that a version of universal basic income and social security is fundamental for a just civilization.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510358855287/2017-11-10---TPIV07cBenjamin_Heller.jpg.jpg)
<figcaption>Andrew Mayer (left, back), Eddie Rodriguez Jr. (foreground), Joan La Barbara (elevated); *Thomas Paine in Violence*. Photo by Benjamin Heller.</figcaption>
</figure>

Paine describes how originally the earth was "common property of the human race". Every person had a right to the soil's bounties. But that style of living required large amounts of open land for hunting and gathering and only fed so many mouths. So people cultivated the earth and created efficient systems of production. Society bloomed from these developments, growing in population and developing agriculture, science, and the arts.
 
With cultivation came private property. Those able to significantly increase land's value gained ownership of their plots. Society divided into the haves and have-nots. Man's original right to shared earth ceased without retribution. Paine proposes a fix: a sum given to citizens on their 21st birthday, along with a subsidy provided yearly after they turn 50, paid for by an inheritance tax. Paine asserts that repaying man's natural land right is a fundamental step towards correcting societal inequality and a preventative measure against a worsening cycle of poverty.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510358874953/2017-11-11---TPIV02cBenjamin_Heller.jpg.jpg)
<figcaption>Paul Pinto, Eddie Rodriguez Jr.; *Thomas Paine in Violence*. Photo by Benjamin Heller.</figcaption>
</figure>
 
The Spirit of Thomas Paine, played by the inimitable Joan La Barbara, reckons with *Agrarian Justice* in a modern context. Enthroned eight feet off the ground, she presides like an oracle. Below is bedlam. Four hyperactive, dapper, brown men run her subconscious. The "Manchorus" (played tirelessly by Paul Pinto, Andrew Mayer, Christian Luu, and Eddie Rodriguez Jr.) frenetically shuffles about, sharply turning and gesturing, maneuvering papers, tables, panels, electronics, and punctuating Paine's speeches with tight, high, vocal stabs for dramatic and comedic effect. The Founding Father's mind is on hyper-drive trying to corral and channel its fury at the direction the modern world has careened.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510358884236/2017-11-11---TPIV03cBenjamin_Heller.jpg.jpg)
<figcaption>Eddie Rodriguez Jr., Christian Luu, Andrew Mayer, Paul Pinto, (Joan La Barbara elevated); *Thomas Paine in Violence*. Photo by Benjamin Heller.</figcaption>
</figure>
 
Paine converses to an ambiguous public through a radio station that dwells underground or in some other-worldly, purgatory space. She is tired, frustrated and cantankerously desperate to rediscover and retransmit her message to a modern world that will not recognize pleas for justice, no matter how articulately stated.
 
La Barbara mostly speaks throughout the evening, though she also sustains lines into chant, and at crucial moments sings. A simple, touchingly bellowed melody bookends the piece. When the opera reaches its most fevered pitch, La Barbara roars, topping a dense pile of electronic sound with a guttural wail. Her presence is nuanced, multi-faceted and utterly believable. She is effortlessly engaging yet generous as a co-artist, yielding focus when necessary for the benefit of the piece's larger purpose.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510358893233/2017-11-11---TPIV04cBenjamin_Heller.jpg.jpg)
<figcaption>Eddie Rodriguez Jr.; *Thomas Paine in Violence*. Photo by Benjamin Heller.</figcaption>
</figure>
 
Simmering with humor, verve, and menace, the opera is not didactic despite having a definite message – a testament to Pinto's brilliance as a creator. Form fits function in Pinto's work. Devices express meaning through both content and structure. The opera's climactic final section is an astoundingly woven framework that is a microcosm for the evening's abundance of ingenious structural invention.
 
Paine grapples with her final speech, searching for her point. She restarts and rephrases, aching for the concise expression of her message. Meanwhile, the instrumentalists one by one calmly finish playing, rise, listen for a few moments, and exit. The Manchorus gently repeats an indecipherable phrase adding texture not text to the environment. Beckoned, Paine starts her speech again, an impassioned appeal that peaks before lowering, and dissolving. Reverb joins her voice as she sinks in pitch. La Barbara endows her timbre with frailty evincing futility in the face of a deaf populous.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510358863141/2017-11-11---TPIV01cBenjamin_Heller.jpg.jpg)
<figcaption>Joan La Barbara; *Thomas Paine in Violence*. Photo by Benjamin Heller.</figcaption>
</figure>
 
As Paine trails off into oblivion the Manchorus fades up. Undetected, they have assembled at a table downstage center. Now their text is audible: "More persons fall annually into it than get out of it", a quote describing the hereditary poverty cycle that each year claims more victims, the crux of what Paine wants ended. The Manchorus repeats the phrase in a rapid, percussive, pitched unison again and again. But as the audience grasps the idea, a syllable shifts. This alteration stays for the next repetition, morphing the text like an impatient child would in a game of telephone. Just as the new incarnation is grasped, another syllable deviates. Each fresh combination of phonemes creates a different sentence and so a different meaning. Reducing and diminishing, the language bends and cramps, one repetition funny, the next ironic, the next profound.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510358903049/2017-11-11---TPIV06cBenjamin_Heller.jpg.jpg)
<figcaption>Paul Pinto, Eddie Rodriguez Jr., Christian Luu, Andrew Mayer; *Thomas Paine in Violence*. Photo by Benjamin Heller.</figcaption>
</figure>

Finally "Poor sons hate your rights" reduces to a crystalline, chilling phrase: "Hate your rights", repeated and repeated. Its rhythmic density screams with urgency. Paine's message is reduced to an ambiguous essence, a plea to the past and present.
 
*Thomas Paine in Violence* must be witnessed. The art that Pinto has created with, Joan La Barbara, the Manchorus, the brilliant instrumentalists and creative team is thrilling and rare and must be experienced live for a full sense of its depth of ingenuity.

>*Thomas Paine in Violence* runs through November 18. For details and ticket information, follow our box office links below. 
