+++
author = ["authors/jenna.md"]
categories = "Review"
date = 2020-01-18T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1579388901/media/2020/01/sqPhilWinterreise_zy6evc.jpg"
primary_image_credit = ""
related_articles = []
related_companies = []
related_people = []
short_description = "It was Canadian bass-baritone Philippe Sly, backed by Le Chimera Project - the unusual-for-Lieder band of clarinet, trombone, accordion, and violin - staged by director Roy Rallo. The group of artists seem to have come together precisely to develop this take on Schubert's Winterreise, and to do so from as blank an artistic slate as possible."
slug = "things-we-didnt-ask-for-winterreise-at-21c"
title = "Things we didn't ask for: Winterreise at 21C"
youtube_url = ""

+++
It wouldn't be a 21st-century music festival without something baffling on the line-up, right?

I was indeed a bit baffled by Friday night's item for this year's 21C Festival, the annual series curated by The Royal Conservatory of Music and dedicated to music from this century. _Winterreise 2020_ was its name, a title that's fairly self-explanatory to anyone who knows of Franz Schubert and his famed 1828 song cycle on poems by Wilhelm Müller.

It was Canadian bass-baritone Philippe Sly, backed by the unusual-for-Lieder band of clarinet, trombone, accordion, and violin, and staged by director Roy Rallo. The group of artists, collectively dubbed Le Chimera Project, seem to have come together precisely to develop this take on Schubert's _Winterreise_, and to do so from as blank an artistic slate as possible.

> But to present what I assume is new meaning, or at least new layers of meaning, without giving us the source material, amounts to inexplicable artistic indulgence.

I can get behind the motivating theme. _Winterreise_, famously studied and performed and recorded and re-studied, is one of those pieces from the classical canon that is heavily laden with what are essentially opinions. Between Schubert putting the cycle to paper and today, it seems as though a revolving door of interpreters have unofficially written in the margins of the score, suggesting - maybe even dictating - how it should sound, what it should mean, and how it should make an audience feel. With _Winterreise 2020_, Sly and Rallo attempt to present Schubert's work from the rare vantage point of someone utterly naïve to the composer, the piece, and any stylistic baggage it might have collected since 1828.

Rallo writes in his director's notes, "We asked ourselves how this music would sound if it were interpreted by a stranger to that tradition, a kind of outsider, knowing that for us this was no longer possible."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1579379217/media/2020/01/PhilippeSly_crpovz.jpg){{% /md %}}

<figcaption>Philippe Sly, bass-baritone.</figcaption>

</figure>

Fast-forward to Sly collecting four musicians who would become Le Chimera Project, and two weeks of development at Domaine Forget in Québec, and _Winterreise 2020_ is born. Essentially, it's a new arrangement of the score for these unlikely instruments; left intact are Müller's poetry and most of Schubert's vocal writing. Added are Rallo's staging and design by Doey Lüthi, which visually echo the musical deconstruction of Schubert.

Yet the whole thing seemed to answer a question that was entirely nonsensical. Asking, "How would this sound to people who had never heard it before?" feels a bit akin to asking, "When was Austria yellow?" If you'll excuse my unimaginative harumphing for a moment: the piece exists with all the tools needed for an outsider. Words, sheet music; that's the essence of it, no matter who you ask. What _Winterreise 2020_ does, in the guise of "paring everything down to essentials," is just as stylistically suggestive as the recordings by Dietrich Fischer-Dieskau. 

> It all makes me feel so pitifully old.

Perhaps moreso; the stage was littered with trends and isms which, for all their purporting of newness and essentialism, have alarmingly little to do with Müller's words. Harsh side-stage lighting, random placement of people dressed in black (but not orchestra black, like faded black jeans and other too-cool-for-Schubert garb), mysterious physical outbursts from Sly, an ASMR moment with a microphone, and the most hipster of instruments: a hurdy-gurdy. (To be fair, this addition at least had roots in the text.)

Speaking of the text, the whole thing was done with no translations, neither printed nor projected. That's not inherently bad, since great music and great singers can communicate clearly even with a language barrier in place. But to present what I assume is new meaning, or at least new layers of meaning, without giving us the source material, amounts to inexplicable artistic indulgence. I heard moments of text interpretation, too; a coloured word from Sly, a cheeky slide from the clarinet, these are clues that _Winterreise 2020_ is not wholly untethered to the poetry that Schubert himself deemed the essential thing to his work. But these were fluke moments of catching a whiff of meaning; for the rest of it, I was wandering in the dark.

It all makes me feel so pitifully old.