+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = 2019-09-24T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "If you have a true story of harassment, abuse, or assault within the opera and classical music industries, and you want to talk about it, send it my way at [jenna@schmopera.com](mailto:jenna@schmopera.com)."
preamble = "This is one part in a series of personal accounts of harassment, abuse, and assault in the opera and classical music industries. These stories are published as told to me, with some names and details withheld or changed at the author's request."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1571942266/media/2019/10/TheStories6-resized_jie50l.jpg"
primary_image_credit = ""
related_articles = ["articles/thestories-part-15.md", "articles/thestories-part-14.md", "articles/thestories-part-13.md", "articles/thestories-part-12.md", "articles/thestories-part-10-1.md", "articles/thestories-part-10-2.md", "articles/thestories-part-9.md", "articles/thestories-part-8.md", "articles/thestories-part-10.md", "articles/thestories-part-6.md", "articles/thestories-part-5.md", "articles/thestories-part-4.md", "articles/thestories-part-3.md", "articles/thestories-part-2.md", "articles/thestories-part-i.md", "articles/metoo-intro.md"]
related_companies = []
related_people = []
short_description = "\"Later that day, he sent me an email, in which he again referenced my 'innocence and negativity', and once again attempted to coerce me to meet with him alone at his home. I responded to this email with a reply, in which I clearly laid out my boundaries, and made requests for the parameters of our professional relationship going forward.\""
slug = "thestories-part-5"
title = "#TheStories, part 5"
youtube_url = ""

+++
Since I first met him during an audition for a Canadian opera company (during which he cupped his hand around the back of my neck, unwelcomed), until he ultimately fired me from my duties as a member of a church choir, a prominent figure in the opera and concert scenes frequently sexually harassed me.

Because he alone has unilateral power over hiring and firing choir members, I felt myself in constant need of circumnavigating his sexual advances such that he wasn't too upset to fire me, but also such that his advanced not develop into an actual sexual encounter.

As a conductor and company leader, knew he was in a position of power over me (in that he had control over a large part of my income), and he abused that power.

> He then responded by making it very clear that he was making sexual references, by saying "I was hoping you'd get the double entendre in my message".

His inappropriate behaviour manifested itself in many ways, including regular invitations to visit his home alone, as well as unwelcomed sexual innuendos both in person and in writing. He sent me a text message after a Sunday morning church service, in which he made reference to gay sexual positions ("top" and "bottom").

In response to his message, and in accordance with my aim to maintain the delicate balance I mentioned above, I responded in a way that I hoped would show me as "friendly and easy to get along with" but that would stop the conversation, while at the same time not upsetting him (which I feared would lead to him firing me from my position with the church choir).

He then responded by making it very clear that he was making sexual references, by saying "I was hoping you'd get the double entendre in my message".

The following year, on the afternoon of May 4, 2015, I had agreed to do a private musical coaching with him, to take place in the sanctuary of the church. I had an upcoming musical performance about which I was feeling nervous and in need of some guidance, and he offered to help me, at a reduced rate compared to other coaches in the city.

I knew that meeting with him meant risking that he would make further sexual harassment attempts, but I was comforted by the fact that I would be meeting him in the church, in the afternoon, amidst other church staff members. So, I proceeded with the coaching session.

During that coaching session, he referenced an "innocence within me" and attempted to convince me that there was also "a darkness" within me, that he felt compelled to help me with.

> His touch lasted for far longer than would have necessary than if he were he simply trying to teach or demonstrate something.

During this coaching session, under the pretense of "teaching", he laid his hands on my chest without my consent. In musical coachings (as in any situation), one does not have consent to touch another person's body without first getting their permission.

I understand that a male's chest is not an erogenous area. However, given that he had display a sexual interest in me, by sending inappropriate text messages and making invitations to his home, I believe this action carried great consequence with it. His touch lasted for far longer than would have necessary than if he were he simply trying to teach or demonstrate something, for the sake of the coaching session. It was extremely distressing.

Later that day, he sent me an email, in which he again referenced my "innocence and negativity", and once again attempted to coerce me to meet with him alone at his home. I responded to this email with a reply, in which I clearly laid out my boundaries, and made requests for the parameters of our professional relationship going forward.

He responded with an email suggesting that I should decide whether or not I should continue to sing at the church.

I responded saying I would definitely like to continue to sing with the church choir, and asked for confirmation of the schedule, to see when I could next join the choir. To this email, I never received a response.

> This happened as a direct result of my politely and assertively setting boundaries by refusing is sexual overtures.

Later that summer, on July 17, 2015, I sang in an "ad hoc" choir for summer music festival (assembled for this occasion only), which was conducted by this man. This was my first opportunity to meet with him since the email exchange on May 12, 2015. I did not approach him, nor did I exchange words with him outside of some brief exchanges about how to present the music that evening.

> He made the decision to fire me.

I felt that, because he was in the position of power in our relationship, and because I'd demonstrated a wish to reconcile and continue singing with the choir, that he was the one who would have to choose how to talk next.

At 2:07am the next morning, he sent the following email, suggesting that "those who don't accept the heat of his passion simply go away." In this email, he alone decided that I was "growing away from" the choir. I had never shared that sentiment. In all my communication, including my response to his 2:07am email, I made it clear that I wanted to remain in the choir.

He made the decision to fire me. This happened as a direct result of my politely and assertively setting boundaries by refusing is sexual overtures.

As a working artist, I relied heavily on the average $400 in monthly income that came from singing with this choir. This man fired me without just cause.

> He demonstrates a pattern of predatory behaviour which will continue, if left unaddressed.

In the months following, when I met members of the church choir, they shared with me that he had announced that I alone had chosen to leave the choir. In doing so, he had erased the entire storyline. Because he is well liked by choir members, I felt unable to correct such choir member when I was speaking with them, due to a strong cognitive dissonance (to "not make a pleasant conversation suddenly very serious and unpleasant").

Indeed, I imagine that if you surveyed the list of past male, openly gay members of this choir – especially those who quickly disappeared "because they'd grown apart from the choir" – you'd find similar stories of power abuse and ultimate dismissal.

I am aware that other sexual harassment allegations have been made against this man in the past. He demonstrates a pattern of predatory behaviour which will continue, if left unaddressed.

\---

_Editor's note: the author has submitted a formal complaint to the church in question, and the church has begun an investigation._