+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-12-22T19:22:00-05:00"
lastmod = "2015-12-28T11:23:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1451315235708/2015-12-28---Netflix.jpg.jpg"
publishDate = "2015-12-28T10:45:00-05:00"
related_articles = ["articles/netflix-why-not-opera.md","articles/online-music-is-obscuring-opera.md","articles/a-tale-of-two-audiences.md","articles/yes-please-jonas-kaufmann-on-the-big-screen.md","articles/great-ideas-a-streamable-opera-miniseries.md","articles/pavarottis-nessun-dorma-the-trump-campaign.md","articles/the-brief-history-of-madefortv-opera.md"]
short_description = "The idea that companies are teasing, luring new opera lovers to their theatres with a taste of Verdi online, is outdated. Opera will begin to be consumed in video form only; purists can argue all they want that this is a lesser experience (and I&#039;d agree with them), but the argument won&#039;t persuade people who aren&#039;t already into opera. "
slug = "theres-still-no-opera-on-netflix"
title = "There&#039;s still no opera on Netflix"
+++

Over a year ago, we published an [article](/netflix-why-not-opera/) about the dearth of opera available on Netflix. The research for the piece took little time, and produced results that weren't surprising.

Since fall of 2014, that same article has been a consistent source of traffic on Schmopera. Likely, people are landing on the page because they're doing a Google search something like "netflix opera". Unfortunately, that search brings up our bad-news report on the streaming giant's opera library.

It's not about having opera specifically on Netflix, but we are certainly missing an unbiased, large-scale online collection of filmed productions. People would pay for their online opera, for sure; we know this from subscription services like the [Metropolitan Opera](http://www.metopera.org/Season/On-Demand/)'s On Demand service, or the streaming collections from [Teatro Real](https://www.palcodigital.com/videoteca-palco/#) or the [Wiener Staatsoper](http://www.staatsoperlive.com/en/subscription/#produkt-vod). PBS has its [Great Performances](http://www.pbs.org/wnet/gperf/topic/opera/) series, but they're not exactly available on demand; [The Opera Platform](http://www.theoperaplatform.eu/en/opera/verdi-aida) has a few titles available to watch at your leisure, but the collection is teeny tiny.

Composer Neil Shaw Cohen puts it beautifully in his [great article](http://www.newmusicbox.org/articles/we-need-more-on-demand-films-of-new-operas/) for *New Music Box*: "Imagine the possible impact of a subscription streaming service that included a substantial library of contemporary operas—ideally, aggregated across multiple opera companies to offer quantity and variety. How might such a service expand audiences for new opera? Generate interest in staging new productions of existing works? Further the artistic development of this field, in which even composers and librettists only rarely have opportunities to see the master works of our age?"

There are exceptions, of course. Cohen points out Jake Heggie's *Moby-Dick*, which was filmed for PBS' *Great Performances*; it's [available to watch online](http://www.pbs.org/video/2365112413/) at no cost. Kevin Puts' [*Silent Night*](http://www.pbs.org/video/2365132185/) was broadcast on *Great Performances*, but it's no longer available for Canadians, and apparently for Cohen as well. "How is it that an opera can win the Pulitzer Prize, receive a production by one of the country’s largest opera companies (Minnesota Opera), and be filmed and broadcast on public media — a triumph by any measure — and yet the public cannot presently access this film through any medium?"

Opera has been vying for public attention for a long time already, and people under 30 have begun to consume little that's not available online. The Met's HD Broadcast series seems to be something that audiences enjoy, but not everyone agrees that it's a good use of the Met's money. The broadcasts require a whole new team of directors and technicians, and there are added fees for union member artists and stage workers. 

I'm going to assume that the cost is what keeps opera companies from broadcasting videos of productions in large quantities. It's a fair excuse, of course. Financial limitations will affect how opera is produced, both in its live and filmed forms. Perhaps, though, there needs to be active prioritization of certain content, specifically made to be consumed online; in these cases the assumption should be that paying audiences will never buy a ticket for the real deal.

The concept of streaming operas online is still quite new, and perhaps that's why it seems that the public availability of a live or archival performance is a *bonus*, an add-on feature to the main event on the live stage. It's understandable that they're prioritizing live shows, since that's their business; but it's unrealistic to think that young audiences (meaning potential future donors, perhaps) can be persuaded to see something unfamiliar, for more money, oustide of the comfort of their homes, *all season long*.

The idea that companies are teasing, luring new opera lovers to their theatres with a taste of Verdi online, is outdated. Opera will begin to be consumed in video form only; purists can argue all they want that this is a lesser experience (and I'd agree with them), but the argument won't persuade people who aren't already into opera. Watching the Met's *Ring Cycle* on demand may get an opera newbie to buy a ticket to see Wagner live, but companies need to be prepared for these newbies to "limit" their viewing to what else is available online.

Then comes the artistic responsibility that we all purport to carry. The young audience members, the future donors, the kids who will play Mozart recordings for *their* kids, they need to know what's so great about opera, old and new. It could be *so easy* to consume lots of opera, hear singers from big houses and small houses, note the differences in style between Germany and Spain, all the factoids that make an afficionado out of a vaguely interested listener. Without more pickings, the next generation of opera lovers will be peeking at a massive art form through a keyhole. Improving the availability of historical and contemporary productions, which are a part of opera as the repertoire itself, falls under this umbrella of artistic responsibility.
