+++
author = ["authors/blanche-isral.md"]
categories = "Op-ed"
date = "2018-04-15T21:52:00-04:00"
lastmod = "2018-04-18T10:28:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523844008776/sqCast.jpg.jpg"
primary_image_credit = "Alexandre Thériault (top left) and his castmates, before the fatal car crash one year ago."
publishDate = "2018-04-16T11:11:00-04:00"
related_articles = ["articles/when-opera-companies-protect-abusers.md"]
short_description = "It&#039;s the question that crosses any touring performer&#039;s mind when the stage manager misses a stop sign or forgets to check their blind spot. You grip the armrests and wonder, &quot;what if we crashed?&quot; A year ago today, the members of one Canadian production found out. "
slug = "theatre-company-responsible-for-canadian-singers-death-goes-bankrupt"
title = "Theatre company responsible for Canadian singer&#039;s death goes bankrupt"
+++

>"It's nice to have some closure." - Robbie Fenton, cast member who survived the crash.

Just shy of the anniversary of a fatal road accident caused by poor, non-union working conditions, TBOS & Co has filed for bankruptcy. After changing its name last year in an attempt to conceal its identity following [damning press](http://plus.lapresse.ca/screens/659f4577-2122-4a38-966b-d2b4e92127ba%7C4F98wzQRuh5_.html) - the company operated under more than a dozen aliases, including Tohu-Bohu Productions and TBOS Live, according to one source - as of last week the Montréal-based commercial musical theatre company and its non-union affiliate TBOS & Co have taken down social media and web pages, fired all staff, and quietly ceased to exist.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523894652040/Screen%20Shot%202018-04-15%20at%2018.24.32.png)
<figcaption>The cast of *A Forever Frozen Story* in transit, with Alexandre Thériault seated in the centre. Photo: Holly McCourt.</figcaption>
</figure>

### TRAGEDY ON TOUR

It's the question that crosses any touring performer's mind when the stage manager misses a stop sign or forgets to check their blind spot. You grip the armrests and wonder, "what if we crashed?" A year ago today, the members of one Canadian production found out. 

After 18 days of the third leg of a cross-Canada tour and operating on just 6 hours of sleep, the cast and crew of *A Forever Frozen Story* set off for a 350km drive from Lloydminster to Athabasca, Alberta. Exhausted, all seven members of the cast are fast asleep in the van while an overworked, underslept stage manager is behind the wheel. Three hours into the drive, the stage manager dozes off. She wakes up to a cast member screaming her name and tries to swerve out of danger, but the van strikes the production’s set truck ahead and rolls over twice before crumpling into a ditch. The van is totalled. 28-year-old performing artist Alexandre Thériault is pinned under the van, consumed with pain but still conscious. He is airlifted to the University of Alberta Hospital in Edmonton, ostensibly for a leg injury, but he dies of cardiac arrest before reaching the hospital.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523894666990/FentonPics.jpg.jpg)
<figcaption>Images of the accident. Photo: Robbie Fenton.</figcaption>
</figure>

### "IT COULD HAVE BEEN AVOIDED"

Robbie Fenton, a castmate of Thériault's who was seated next to him at the time of the crash, was deeply affected by the accident. He turned that trauma into advocacy, vowing to share Thériault's story with as many performing artists and touring companies as possible. "This particular accident could have been avoided," writes Fenton in an open letter. "The driver was not a professional driver, worked during our show, helped set up and tear down our set and on the day of the accident did not have enough rest time in between driving."

The company routinely enforced schedules that would be patently unacceptable by any standard. The schedule for a similar TBOS & Co production that toured in July 2016 shows a 36-hour period that called for a 10:30 a.m. start to a two-performance day in Abbotsford, B.C. ending at 10 p.m., followed by a 4-hour drive to a hotel in Kelowna, 330 km away. Cast and crew, including the stage manager required to do all the driving, were scheduled to arrive at the hotel at 2 a.m. where they were then required to be on the road again by 6:45 a.m. for a three-performance day that would go until 10:45 p.m. 

### CONCERNS DISMISSED

Just days before the accident and with uncanny foreshadowing, the cast had e-mailed Tour Manager Hubert L'Ecuyer with concerns about the stage manager's driving. Issues had arisen from the fact that she was required to check Facebook, texts and e-mails on her phone while driving in order to stay up to date and communicate with the set truck. "This has become a huge issue and we feel very unsafe when she is on her phone or following the truck too closely," the e-mail reads. "We've briefly mentioned these points to her, but they need to be taken more seriously for our safety."

On the day of the accident, L'Ecuyer, who had already been in an accident with one of the company's touring productions resulting in a hospitalization the previous year, brought these concerns to upper management. He tried to impart to the booking agent and executive producer just how overworked the crew was, recalls Catherine Savoie, former artistic director of TBOS. "They were going to be working for 20 hours straight, and then get behind the wheel again the next morning. The booking agent couldn't care less, and the executive producer said something to the effect of 'well, it's already booked, nothing can be done. Work is work.'" In an article that appeared in *La Presse* some weeks later, TBOS President Yoann Desrosiers states that his team had never fielded any concerns from below to the effect that tour schedules were unsustainable. "That is patently untrue," says Savoie. "Many employees were there and were well aware that [L'Ecuyer] was uncomfortable with this schedule. So when the crew got behind the wheel that morning, they were exhausted. In my opinion, this most certainly contributed to the accident."

### LEGAL ENTANGLEMENT

Possibly the most shocking part of the tragedy, however, was the way in which TBOS & Co chose to handle the aftermath of the situation. "I have rarely encountered such a lack of empathy and professionalism," says Savoie. They asked members of the cast to resume touring just six days after the accident, seemingly ignoring the fact that one actor was dead, another had a broken arm, and almost all were concussed and visibly bruised. "I was horrified," recalls Savoie. "I could not believe they were continuing this tour."

The cast's refusal was skillfully wielded against them by the (evidently lawyered-up) company as breach of contract. As Savoie points out, Desrosiers "always treated employees as expendable, especially performers. There was no room for negotiation. His attitude was, 'if you don't like the contract, I'll find someone else'." (This made Savoie's job as the artistic director difficult - performers talk, and few wanted to return to TBOS by the time she started working there.)

After the accident, no effort was made to check in on the cast members' mental state, payment was withheld for months in one actor's case, and another who did wish to stay on the tour was replaced without notice. And when touring resumed - because it did, just two weeks later - conditions did not improve. "The new tour manager had the same concerns: schedules too tight, insufficient rest time for the crew. The attitude hadn't changed," says Savoie, who herself worked 60 days straight during that period last year, often up to 20 hours a day without overtime.

TBOS & Co was not unionized - it specifically existed as a non-union branch of Tohu-Bohu Productions (also known as TBOS Live). Still, many feel that the conditions it imposed were simply not legal, nevermind to union standards. "I am sick of there being absolutely no standard for non-union work," says Fenton. "Too many illegal things are happening, and the artists are the ones who pay the price."

While the cast members were eventually given a plane ticket home, the crew were not so lucky. The three crew members, including the stage manager who had been behind the wheel at the time of the accident, were, I kid you not, asked to take care of returning the set truck from Alberta to Montreal - a 3,700 km drive. The crew, unfit to drive such long distances after the ordeal, refused, stating psychological and medical trauma. But they had to go so far as to obtain psychological and medical evaluations before the company finally sent them home, not on a plane but on a torturous, 3-day coach bus in order to save the company a couple bucks.

Today, TBOS has finally bitten off more than it could chew. A French-language production currently touring through Europe has been upended, a mix of Canadian and French performers sent home. At least one European production has been transferred into the hands of another company, where the actors and the show still tour. For many past employees and contractors of the nightmare company, this is welcome news. Fenton learned of the company's quiet exit on Thursday, just days before the anniversary of the accident. "The world feels less heavy today," he says. "Alex would be happy to hear this."

### REMEMBERING ALEXANDRE THÉRIAULT

A memorial donation page was set up to honour Thériault’s passion: helping kids with special needs. His partner, Gaétan St-Cyr, says that although Thériault loved performing, what he really wanted to do was become a teacher. It's what he talked about in the weeks before his death. A memorial page launched by his castmate is aiming to raise $2,000 for Autisme Montréal, a charity Thériault was passionate about. To learn more about Thériault and to donate, click [here](https://www.youcaring.com/autismemontreal-966350).

>Note: this article has been corrected, to note that not all of TBOS' productions have been cancelled.
