+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-02-16T17:06:00+00:00"
lastmod = "2017-02-17T11:00:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487328950083/2017-02-18---Diva.jpg.jpg"
publishDate = "2017-02-17T11:00:00+00:00"
short_description = "This paragraph seems dangerously presumptuous, and more than a little insulting to Meyers. It&#039;s quite a thing to say, that a director was entirely uninvolved in a singer&#039;s performance, and to credit a singer with being the saving grace of a production. It&#039;s a simple case of problematic journalism: how does Jorden know that Damrau&#039;s performance wasn&#039;t guided by Meyers?"
slug = "the-weird-mystery-of-the-mets-diva-directors"
title = "The weird mystery of the Met&#039;s &quot;diva directors&quot;"
+++

We came across a weird [article for *The Observer*](https://cdn.ampproject.org/c/observer.com/2017/02/met-review-opera-i-puritani/amp/) today by James Jorden, entitled, "At the Met, the Diva is the Director". Referring first to the Met's current production of *I Puritani*, starring [Javier Camarena](/scene/people/javier-camarena/) and [Diana Damrau](/scene/people/diana-damrau/), Jorden writes of the star soprano, "In a sense, she outshone even Camarena, because she not only sang the difficult leading role, she also directed the opera."

Jorden was quick to clarify what he meant: "No, that last part's not literally true, of course. Officially credited as 'stage director' in the program was Sarah Ina Meyers, but her contribution to the proceedings seemed to amount to little more than trooping the chorus on and off and grouping them in Rembrandt-inspired tableaux. So in a practical sense whatever happened dramatically in this *Puritani* was driven by Damrau's aggressive physicality, darting and swooping and twitching to express the heroine's incipient madness."

This paragraph seems dangerously presumptuous, and more than a little insulting to Meyers. It's quite a thing to say, that a director was entirely uninvolved in a singer's performance, and to credit a singer with being the saving grace of a production. It's a simple case of problematic journalism: how does Jorden know that Damrau's performance wasn't guided by Meyers?

Jorden also cites another example in [Kristine Opolais](/scene/people/kristine-opolais/)' performance in the Met's *Rusalka*:

"Similary [sic], in Mary Zimmerman's virtually unstaged production of Dvorak's *Rusalka* (I can only imagine the director spent the entire rehearsal period lecturing her cast on 'Tendencies and Trends in Modern Drama'), the only shred of a through-line was provided by Kristine Opolais in the title role. Unfortunately, she seemed to have brought her dour, weepy interpretation to the Met ready-made, the way divas used to travel from theater to theater with trunks of their own costumes. (Her glassy-eyed take on the part fit much more plausibly into the creepy Martin Kusej staging of this work she headlined in Munich in 2010.)"

Though we haven't yet seen Zimmerman's *Rusalka*, Jorden's comments beg the question: even if she really did provide that "shred of a through-line," why does a singer like Opolais deserve credit for inserting her interpretation of Rusalka into a production in which it clearly didn't fit?

We won't be naïve and claim that directors always hit their mark with their production concepts. But to say that singers like Damrau and Opolais carried a production with their performances - in spite of the director - seems grossly misinformed. 

What Jorden means to say is that he *enjoyed* these singers' performances very much, moreso than the production as a whole. In many cases, and particularly at major houses with famous singers, staging rehearsals are done with haste. Often the headlining singer is the last to arrive during the rehearsal process, leaving them little choice but to do an educated version of "winging it". We've seen carefully rehearsed shows turn into near improv with the late arrival of an artist (often they're the headlining names); in those cases, the star singers are not "directing" the production, but instead making the best out of something that's under-rehearsed. 

That's not a good situation, and it's neither the fault of the director, nor the singer.

At a house that produces as many shows per season as the Met, under-rehearsed productions with famous singers are a normal occurrence. It's interesting to read Jorden's article, because at the heart of it, he's saying that these productions are not cohesive. He's right: they're not organic, and there's an element about them - be it an artist or a director's concept - that sticks out. Jorden sees it as a flawed idea from a director, saved by a great artist. From where we're sitting, a flawed production is a real possibility; but we can't ignore the simple fact that stage directors at major opera houses often don't have the rehearsal time (or even the presence of their main cast) to make their ideas come to fruition.

We're champions of singers, let there be no doubt about it. Yet it's discouraging to see big-name artists, who are making opera house rounds with their signature roles, who seem to plop "their" versions of Rusalka or Mimì or whoever into a new production, in which their interpretation may no longer fit. What can a director do to create cohesion in their production when the headlining singer has only arrived in time for the *Sitzprobe*?

Who knows? Maybe Damrau really did do the grunt work for Meyers' *I Puritani*, and maybe Opolais carries Zimmerman's *Rusalka*. But it's disrespectful, and even a bit ignorant - perhaps benevolently so, despite there being a hint of scorn in Jorden's writing - to suggest that it's a director who leaves loose ends that only a great singer can tie together.

And frankly, if a singer brings greatness to the rehearsal room, what director would shut it down? 

>Readers (ideally those of you who have seen either of the Met productions in question), what say you? 
