+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-08-31T14:30:00-04:00"
lastmod = "2017-09-07T21:39:00-04:00"
preamble = "Since 2013, American baritone Mitchell Hutchings has discovered that \"the success of my students was more important to me than my own.\" In his own singing career, he has sung the title roles in *Sweeney Todd: The Demon Barber of Fleet Street* and *Gianni Schicchi*, Michele in *Il tabarro*, Escamillo in *La tragédie de Carmen*, and Tarquinius in *The Rape of Lucretia*. Hutchings is a quarter-finalist for the [2018 GRAMMY Music Educator Award](https://www.grammy.com/recording-academy/press-release/197-quarterfinalists-announced-for-2018-music-educator-award), and he maintains a private studio in upstate New York.\n\nContinuing our interview series with voice instructors, we spoke with Hutchings about the teamwork between teacher and coach, and how he identifies \"good singing\"."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1504204317926/2017-08-31---Mitchell-Hutchings-Schmopera.jpg.jpg"
publishDate = "2017-09-07T21:39:00-04:00"
related_people = ["scene/people/mitchell-hutchings.md"]
short_description = "&quot;It may sound cliché, but, even if a student has a natural talent, the best results come from a healthy work ethic. You can see this at various schools, conservatories, and independent voice studios everywhere. Those that are the most motivated and have the greatest amount of perseverance gain the most from this career.&quot;"
slug = "the-voice-teacher-series-mitchell-hutchings"
title = "The voice teacher series: Mitchell Hutchings"
+++

## What do you enjoy most about teaching voice?

I enjoy collaboration with students. I love to watch a student have a breakthrough, but I also enjoy having an ongoing dialogue about voice. I am interested in knowing what singer(s) a given student is listening to. I am also a very goal-oriented person. I love working together to establish goals and putting in the work to achieve them.

## What is the difference between a voice teacher and a voice coach?

Like a voice teacher, a coach is a vital part of the success of a singer. I would be nowhere without the coaching sessions I have had with Laurie Rogers, Stephen Carey, Shelby Rhoades, Jerry Shannon, Douglas Fisher, Benton Hess, Russell Miller, or Lisa Hasson. The list could go on, but I cannot emphasize the importance of a great coach in one's corner. A coach helps you unearth the musical nuances that really make a piece interesting and beautiful. If you need a new perspective on interpretation of text or where one’s music is presented in the context of an entire story, a coach is the best person for this.

What a coach usually steers clear of is directly addressing technical issues. A voice teacher can work on many of the same things as a coach, but often it is a better use of time and of his/her talents to strengthen the voice overall or within specific musical passages.

Both a great vocal coach and voice teacher should be a part of an aspiring singer’s "team."
 
## Can you describe what you hear when you feel you are hearing "good singing"?

I get a specific sensation when I hear singing that I enjoy. It happens when certain harmonics are appropriately amplified by the resonator, creating consistent and congruous formants. I call it the "halo;" when the fundamental pitch and the vocal tract are "in tune."

"Good singing" however doesn't stop in the voice studio. During a performance, there are times when I am so captivated by an individual's interpretation that I choose to turn off the voice teacher-brain and enjoy the performance for what it is. The first example of this that jumps out to me is Natalie Dessay’s performance of the Mad Scene from *Hamlet*. Ambroise Thomas wrote a compelling score, and Dessay's interpretation of Ophelia is incredible.

In the end, "good singing" is "good communication." Often singers communicate best with beauty of tone, but one can steal a show in other ways. It is most important that a performer is singing as healthily as possible within a given genre. That is what I try to focus on as a voice teacher: healthy singing as a foundation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1504547848566/Mitchell%20Hutchings%20Voice%20Lessons%201%20.jpg.jpg)
<figcaption>Mitchell Hutchings (left) in studio with Alessio Tranchell.</figcaption>
</figure>
 
## What is a healthy way of teaching the topic of breath support?

I think all voice teachers can agree that when singers inhale, we need to embrace expansion. Some teachers focus on belly breathing, others on lower back, others on upper back. Most teachers talk about expansion of the ribs. I personally encourage a low 360-degree approach to expansion during inhalation, an upward and outward lift of the rib cage, and an open chest. When I ask most new students to describe breathing, they often detail the process of inhalation relatively well and then skip exhalation and the process of phonation.

I believe that if a student is taught to completely "relax" their body during phonation, what often occurs is immediate tension at the laryngeal level. Yes, the larynx should have a free, relaxed, and relatively low position to accommodate an open throat, but this is difficult to maintain when the muscles of the abdomen are not engaged during phonation. Of course, "engaged" does not mean stiff or locked. The abdominal muscles should be able to exhibit an elevated level of elasticity. 

I love what Giovanni Battista Lamperti explained:

"It is a mistake to breathe in just one part of the body…If singing does not feel like releasing energy to sustain the voice, some important muscle is being held rigid…Rigidity or relaxation destroys the tonicity of this muscular unit, and imperils the control of the voice." Giovanni Battista Lamperti, *Vocal Wisdom* [lessons from 1891-1893], 1957, pages 43-44.

I should state that some students are limited in their ability to breathe. I had a student once who experience some paresis after abdominal surgery. Obviously, a textbook definition of breathing for singing is not going to work for her. Teachers must adapt to the needs of students.
 
## How do you decide on appropriate repertoire recommendations for your students?

This is usually another area of collaboration, except for inexperienced students. I often have certain pieces in mind, but students will also come to me asking if they can perform a specific work. We discuss why the piece might be good or not so good, and we come to an informed conclusion.

What I find works well for a more advanced student is when the student is also working with a coach. I love coaches who offer advice on repertoire. I see it as an opportunity to learn and grow myself. If a student gives me a piece I have not studied before, I examine it and listen to a few passages, and we decide. This process seems to work out well.
                
The selection process also depends on the age and level of the student. I do not typically give an aria to an inexperienced voice student. However, advanced students should always have at least 5 arias ready to ago at any given time.

## What trends have you noticed in the vocal writing of 21st-century music? What does it demand of singers?

I have noticed that there is really no limit to what 21st-century music can provide. Much of what I see is rather demanding. But, there are composers whose music is well-suited for even young singers. A lot of my students ask for pieces written by my spouse, [Sarah Hutchings](http://www.sdhutchings.com/). It gives them the opportunity to work one on one with the composer. They seem to really enjoy that.

## Do you feel that you have a responsibility to assess a singer's future potential? How might you discuss it?

I think encouragement is always a good thing. But, it is important to be honest. J. Harry Wheeler was spot on about encouragement:

"Some pupils need encouragement, the good teacher will judicially give it. A pupil of this kind will advance far more rapidly by this mode of instruction, than by being constantly found fault with, without one uplifting word of hope and commendation. Then there is the impatient, impetuous pupil. To get angry with such a pupil would only 'add fuel to the flames.' The good teacher would never do this. A calm, straight-forward demeanor, would be a far more rational and successful mode of dealing with such an absurd peculiarity." - J. Harry Wheeler, "Some Characteristics of a Good Vocal Teacher," *The Etude*, April 1910, page 270.

It may sound cliché, but, even if a student has a natural talent, the best results come from a healthy work ethic. You can see this at various schools, conservatories, and independent voice studios everywhere. Those that are the most motivated and have the greatest amount of perseverance gain the most from this career. I often tell my students, "hard work beats talent when talent doesn't work hard." -Tim Notke

>Readers, do you know a voice teacher who would make a great addition to our interview series? Let us know, at [hello@schmopera.com.](mailto:hello@schmopera.com)
