+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-04-18T16:55:00-04:00"
lastmod = "2018-04-30T21:41:00-04:00"
preamble = "A student of renowned voice technician Richard Miller (*The Structure of Singing*) and a busy soprano performing worldwide, [**Jennifer Casey Cabot**](https://www.jennifercaseycabot.com/) is a teacher who practices what she preaches. \n\nCabot is on the [voice faculty of the Potomac Voice Instutite](https://www.potomacvocal.com/voice-faculty#), and we had the chance to talk with her about wearing three hats at work, and the feeling of being \"enveloped\" by good singing."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524862656671/sqCabot.jpg.jpg"
primary_image_credit = "Photo: Alexander Vasiljev Photography."
publishDate = "2018-04-30T21:41:00-04:00"
related_articles = ["articles/the-voice-teacher-series-betsy-bishop.md","articles/the-voice-teacher-series-edith-wiens.md"]
short_description = "&quot;Breath support is the foundation of everything we do as singers, so it is a constant focus in my studio to understand and integrate buoyancy, appoggio and breath pacing mastery.&quot;"
slug = "the-voice-teacher-series-jennifer-casey-cabot"
title = "The voice teacher series: Jennifer Casey Cabot"
+++

## What do you enjoy most about teaching voice?

It is immensely satisfying to work one on one with a singer to achieve greater understanding of the singing voice. I consider it my job to diagnose what is working and what is not working vocally for a student.  It is also my job to provide technical information and exercises that rebuild and rethink some of the habits that are perhaps getting in the way.  On a good day, I feel like I am an amalgamation of at least three people at one time: A keen observer (scientist), a sympathetic listener (counselor) and a motivational speaker (mentor).  I like the challenges that come with this kind of complexity. Add to this that we are dealing with music and you get a dream job for me! 

## What is the difference between a voice teacher and a voice coach?

A voice teacher addresses the total package pertaining to singing.  Technique, expression, diction, musicianship.  The coach is integral in the singers team and is more of a specialist in regards to style, diction, and performance practice.  In my career I worked with coaches according to what I needed most at the time (a particular language or style, someone who has a conductor's background, someone who understood the role I was working on, or experience with the particular cycle or opera I was working on). I encourage my students to work with coaches regularly.

## Can you describe what you hear when you feel you are hearing "good singing"?

When I hear "good singing" I feel drawn in to what the performer is doing.  I sense their connection to the music and the text and I am no longer aware of the difficulty of it.  In the presence of "good singing" I feel enveloped in the singer's voice and at ease.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524862696559/headshot%20sitting%20in%20chair%20JCC.jpg.jpg)
<figcaption>Photo: Alexander Vasiljev Photography.</figcaption>
</figure>

## What is a healthy way of teaching the topic of breath support?

Breath support is the foundation of everything we do as singers, so it is a constant focus in my studio to understand and integrate buoyancy, appoggio and breath pacing mastery.  If there is no real appoggio or breath pacing mastery, a student often has throat tightening, and or jaw/tongue tension that can only be released if they master their breath support. 

## How do you decide on appropriate repertoire recommendations for your students?

I believe that too hard too fast is a recipe for a shaky foundation (a half-baked cake,) so I work hard at finding ease with the repertoire.  Sometimes that means limiting the range or the size of the intervals, or sometimes that means simpler legato passages (i.e. downwards instead of upwards melodies), or less slow moving if the singer has not learned how to release a steady tone yet.  Most important is for the repertoire not to be leading the singer to retain fear-induced, overly muscled phonation memories.  All my students work on exercises that involve vowels alone, then consonant combinations, and then simple texts in Italian. If a student has trouble with certain types of songs/arias or passages within them we analyze the technical feat that is at the root of the problem and work on training that weakness.  

I also feel comfortable relaxing around the topic of Fach.  I feel that there is premature urgency around categorizing young singers before their technique is formed enough for their voice to have evolved.  A good technique reveals what Fach you are with time, discipline and experimentation.  I also feel that premature Fach categorizing leads to a light-voiced singer not being required to sing with ample support (poor legato and a less relaxed throat) just as a heavier voice being told that they don't need to worry about agility because they won't have to sing that much in their Fach.  It leads to limiting overall vocal technical prowess. 

## What trends have you noticed in the vocal writing of 21st-century music? What does it demand of singers?

Some of my favorite roles and songs have come from the 21st century music. I find good writing to be in abundance in the 21st century, but I can't generalize about trends in vocal writing of 21st-century music except that it often involves stronger musicianship skills and therefore more time is needed to achieve mastery.   I have found that singing contemporary music in your own language can bring a student forward in their expression.  

## Do you feel that you have a responsibility to assess a singer's future potential? How might you discuss it?

This is done in a very individual way.  And it takes time to really assess someone's future potential.  I have seen students who need a lot more time to develop and some who just need a few nods and prods.   I have found that some people study singing because they like the art form but do not enjoy the act of singing so much.  A true singer above all needs to sing.  From this sense of urgency is born the joy and energy that singing well requires.  A singer is also first and foremost a musician, who requires discipline.  I have found that many people like to sing but don't love the discipline that it requires.  So when you work one on one with students, you must examine with them those questions and lead them to make their own conclusions about where they belong. 

>Readers, do you know a teacher worthy of some spotlight? Send your nominations for our Voice Teachers interview series to [hello@schmopera.com](mailto:hello@schmopera.com).
