+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-10-16T13:46:00-04:00"
lastmod = "2017-10-30T20:01:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508453904034/2017-10-19---Jane-Eaglen.jpg.jpg"
publishDate = "2017-10-30T20:01:00-04:00"
related_articles = ["articles/the-voice-teacher-series-elizabeth-mcdonald.md","articles/the-voice-teacher-series-betsy-bishop.md"]
short_description = "Eaglen has noticed that in some circles, opinions on breath support are so varied that the conversation can even make it a &quot;dirty word&quot; of sorts. Still, &quot;I don&#039;t see how you can talk about singing and not talk about support,&quot; she says."
slug = "the-voice-teacher-series-jane-eaglen"
title = "The voice teacher series: Jane Eaglen"
+++

"I think it's almost unique for someone who's had a career as long as I've had," says English dramatic soprano Jane Eaglen, "that I've literally had one voice teacher since I was 17 years old." Her work with [Joseph Ward](https://goo.gl/nFyBBR) - who created roles like Sid in *Albert Herring* and Starveling in *A Midsummer Night's Dream* - preceded Eaglen's first professional seasons at English National Opera, and continued throughout her enviable career singing signature roles like Brünnhilde (*Ring Cycle*), Norma (*Norma*), Isolde (*Tristan und Isolde*), and Donna Anna (*Don Giovanni*). "He's completely like family to me because of the journey we've gone on. I trusted him immediately and believed he was right, even when I was young and knew nothing." 

Teaching has filled Eaglen's schedule more and more over the past decade, and she is currently on faculty at the [New England Conservatory](https://necmusic.edu/faculty/jane-eaglen). Her relationship with Ward is part of what drives her as an educator. "His way of teaching was very important to me. Having experienced that from being really young, that was something that I wanted to pass on."

Even in her early career, Eaglen was always interested in voices and the diagnostic puzzles that come with teaching singing. "I really enjoy the challenge of figuring out what people need, because every voice is different, and everybody has different challenges and things they need to work on."

"I really enjoy figuring out how to fix problems, basically."

## What's the difference between a voice teacher and a coach?

"I think a voice teacher should deal with technical issues," says Eaglen, drawing a similar boundary observed by many teachers and coaches. "A voice coach should be able to hear technical issues, but doesn't necessarily know how to solve them."

It's a tricky line to understand, especially when coaches spend much of their days in voices lessons; before long, an attentive coach can spot patterns of technical problems and their common solutions. "Of course they pick up a lot of things, and some of them can be helpful," says Eaglen. "But it's not quite the same as really knowing exactly technically what you need to tell someone to do to fix something."

The best coaches Eaglen remembers working with were always capable of saying, "'Hmm, that doesn't sound like it's quite in the right place, do you know how to fix that?' And my answer would be, 'Yes, I do,' or, 'I'll take it to my teacher.'"

What a coach does solve - and may have more time to address - are issues concerning style, language, and phrasing.  "Style is something that is so difficult to teach, in a sense; it's something that has to come over a period of time." Of course, it's also something that is inevitably tied to a secure vocal technique; Eaglen's own experience with "contrasting" roles - Isolde versus Donna Anna, say - has taught her this well. "People have often said to me, 'when you're singing Wagner or when you're singing Donna Anna, how is it different?' Well it's not, it's the same voice. You interpret them differently because of the style of the composer, but the voice is the same. It's the same technique."

## What does it mean to hear "good singing?"

It's decidedly tough to define "good singing", yet Eaglen refers the question to what she listens for in student auditions at the New England Conservatory. "We hear 17 year-olds, and you have to try and make out if they actually have an intstrument that's going to develop," she says. At that age, so much is subject to change that it's almost a guessing game to predict vocal development; more concrete is the search to find "if they have something to say through their music."

"My job is to give a singer the technique to allow them to become the artist they want to be; if they want to interpret in a certain way, they have the technical ability to do so." Eaglen resists teaching by demonstration, preferring to offer tools instead of a model to imitate. "I'd like to know what *you* think about that phrase," she says. "Good technique allows a student to musically say something about what they're singing that's important to them."

"Sometimes a student will come in and sing a cadenza, and I'll say, 'You know, it's not my taste, but convince me I'm wrong.' And if they can do it with conviction and really mean it, I'll say, 'OK, that's great, I completely believe that. It's not what I would have done, but that's great, it doesn't need to be. It just needs to be true.'"

And what about an issue like breath support, which seems as scientific as it does nebulous?

Eaglen has noticed that in some circles, opinions on breath support are so varied that the conversation can even make it a "dirty word" of sorts. Still, "I don't see how you can talk about singing and not talk about support," she says. 

"I always say to someone, 'tell me about your support,' partly because I'm interested in how people actually describe it or think of it." Most young singers know support is vital; yet they often get stuck on the over-simplified idea that more effort yields better results. "The bearing-down thing is something that a lot of stronger girls and a lot of men do," she says. "When they get it right, a lot of them say, 'I don't feel I'm doing anything.'"

She points out that the term "breath support" refers to two tasks: breath, and support. "As far as I'm concerned, you take a breath, and then you support that breath."

"What I use a lot is 'buoyancy'," Eaglen says of her own pedagogy on the topic. "I think the support needs to allow the breath to move freely." She empathises with the singer's struggle to employ tension in the right way while leaving room for freedom. "Most singers are control freaks; they want to control [the breath] until the last possible second," she laughs. "And you have to say, 'let it go.'"

## How do you assess a student's professional potential?

The singer's life may look different, but success still takes a certain level of drive, skill, and even good timing. "It's definitely a teacher's job to advise in all aspects of a singer's career," says Eaglen, including in that statement the conversation about a student's professional readiness. "I think you have to be honest with people up to a point, and say, 'I'm not sure that this is really going to be the right career for you,' if that's what you think. People in colleges are spending a lot of money, and I think it's important not to give people false hope."

Honesty is valuable, but it doesn't have to come at the expense of optimism. "I'd never say never," Eaglen says, almost eager to be proven wrong about her hunches. "You just never know. If you work hard enough, you've got a good chance of progressing on."

Eaglen is well aware that the career looks different today than it did in her early years. "This business is getting harder and harder by the second," she says. Her time with [English National Opera](/scene/companies/english-national-opera/), where she had her professional debut singing small roles, was similar to the training programmes of 2017. "It was sort of like an young artist programme, to some extent, and they sent me to my voice lessons every week, and waited for me to get older." It's that last piece of the puzzle, the patience and long-term investment in a singer, that is much more rare among opera companies today.

"I think it's much harder these days, particularly for bigger voices," Eaglen adds, "because people are less inclined to hire them to sing Berta [in *The Barber of Seville*], or whatever, to give them the chance to get the experience. You have to learn somehow, and I think there are fewer opportunities for that now."

>Do you know a teacher who should be a part of our interview series? Get in touch at [hello@schmopera.com](mailto:hello@schmopera.com).
