+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-01-24T20:35:00-05:00"
lastmod = "2018-01-25T21:19:00-05:00"
preamble = "Canadian soprano [Elizabeth McDonald](/scene/people/elizabeth-mcdonald/) has quickly made a name for herself as a voice educator. She is a past-president of the Ontario chapter of the National Association of Teachers of Singing (NATS), an adjudicator of major voice festivals Canada-wide, and she is currently on the voice faculty at the University of Toronto.\n\nPragmatic in her teaching style and a champion of individualism in her students, McDonald spoke with us about empowering singers, the elusive idea of \"support\", and her systematic approach to selecting repertoire."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516843657433/McDonald-Headshot-Large.jpg.jpg"
publishDate = "2018-01-25T20:00:00-05:00"
related_articles = ["articles/the-voice-teacher-series-jane-eaglen.md","articles/the-voice-teacher-series-edith-wiens.md"]
related_companies = ["scene/companies/university-of-toronto-opera.md"]
related_people = ["scene/people/elizabeth-mcdonald.md"]
short_description = "&quot;For me, breath is the genesis of everything in life, and therefore singing, and I am a very demanding teacher when it comes to breath, especially for singers at the beginning stages of training.&quot;"
slug = "the-voice-teacher-series-elizabeth-mcdonald"
title = "The voice teacher series: Elizabeth McDonald"
+++

## What do you enjoy most about teaching voice?

I love the visceral experience of hearing the human voice in live performance or in a lesson; the unique vocal quality of each singer, coupled with their personality on stage or in the studio, never gets boring to me.  The idea that as humans we can create sounds from within our bodies that have the potential to stimulate an emotional response from our listeners is hugely powerful.  To help a singer discover their voice and their "power", especially at the early stages of their training as I do at the university level, is like having a window into that singer's heart and mind.  It is an honour to watch young singers discover themselves - who they are, how they enter the world, what they want to say. It makes me grateful each day that my students trust me with this very intimate and personal process.

## What is the difference between a voice teacher and a voice coach?

A voice teacher deals with the mechanics of singing - how the body functions efficiently to create the most beautiful sound that singer is capable of, so they can express the music and text in a clear manner.  In my studio, that is about the function and management of the breath, the efficiency and clarity of vowel production, and the quality of the vocal sound. The majority of the time I do this by making very specific suggestions about how the physiology of the body needs to function to produce efficient resonance and how the singer can recreate these sensations consistently.

A voice coach deals with the music and the text (and drama as a result) - what do they hear from that singer with regards to diction of the text, musical accuracy (are they singing what is on the page?), and musical phrasing and dramatic intention? From there, they can offer a wide range of tools and suggestions to help the singer balance their technical needs with the musical and dramatic needs of the repertoire.  

## Can you describe what you hear when you feel you are hearing "good singing"?

I feel as much as hear when I hear good singing.  There is this incredible physical/kinesthetic reaction to singing that I have found in my teaching that helps me diagnosis various points of tension, etc.  When I hear good singing, my sensations are quiet, there is a lack of sensation, and the sound is just pleasure.  I spend my whole day dissecting sound to attempt to make it "better" so when I hear excellent singing, my inner judges turn off and I experience what could be likened as an inner calm and a very direct and intimate connection to the emotion of the music.

## What is a healthy way of teaching the topic of breath support?

For me, breath is the genesis of everything in life, and therefore singing, and I am a very demanding teacher when it comes to breath, especially for singers at the beginning stages of training.

I think first, one needs to talk about how we actually breath outside of singing …how does the body work? It is important to locate the muscles of inhalation and exhalation and understand the concepts of coordination. I always ask "where does the air go when you inhale?"  It's important that we understand the difference between where the air ACTUALLY goes (into the lungs) and where you might feel an expansion as a result of that inhalation (read: air does not go into your belly!).

It is also important to understand how a student learns - do they need to feel it? Do they need to talk about it? Do they need to see it?  Do they need to hear it? From there we work to experience the physical expansion for the breath by seeing/feeling/doing so they can replicate this on their own.  Breathing is muscle memory and just needs to be drilled like any athlete drills a skill.  The basics of breathing are not artistic, but just physiological, so the work can be quite boring; I always feel that being able to lock yourself in a practice room and do the boring work separates those that will have a career and those that will not. You have to be able to do the "boring" work every single day and find a purpose in that as its own part of the process.

## How do you decide on appropriate repertoire recommendations for your students?

Repertoire is always so exciting to consider for singers!  I have been a collector of vocal scores from the time I started my university training, and have always been interested in why certain music is easier than others for different voices.  Over the years, I have made notes in my scores about things I like, issues that can be tricky, voice type, etc.  I keep pretty detailed records of what my singers have sung from year to year, so I can always refer back to those when I hear a voice now that might be similar to one I taught in years past. 

I have also had some wonderful mentors at UofT and Eastman who have always been willing to share their thoughts and experience with repertoire selection.  Recently I was gifted a large portion of the vocal library of my late teacher from Eastman, Dr. William McIver and I can see all of his notes in the music as well as obtaining many of his lists of repertoire that worked for various voice types at various stages of development. This has been hugely valuable and interesting to me!

With respect to the nuts and bolts of choosing, I keep a shared Google Doc with all my singers for the whole time they are studying with me.  This allows me to see at any given moment the overall arch of repertoire selection and evolution and keep accurate records of composers, languages, and styles.  I consider voice type, range, musical challenges with the abilities and/or experience of the singer in combination with the singer's age and year in school.  Additionally, I consider what I want to spend time listening to over and over, and what the studio as a whole can and "should" be exposed to. I have "managed" anywhere form 20-30 singers a week in the past number of years in both university and private studios and I never want to listen to the same 10 songs and arias (unless its Mozart, and them I am NEVER bored). 

And finally, I always pay attention to my gut instinct…. sometimes it's not about all the lists and academic considerations but just a basic gut instinct that tells me a singer could sing something and sound brilliant or discover something new in their technique.

## What trends have you noticed in the vocal writing of 21st-century music? What does it demand of singers?

The biggest trend that I see, especially after having singers in the finals of the last two Eckhardt-Gramatté voice competitions, is that anything goes. I am hearing everything from what I call soundscape singing (voice as a colour and instrument rather than just a delivery method of text) to being managers of technology while one is singing, to having to sing what might be considered a standard lyrical line.  

As we see more contemporary music on all of the opera stages, including the Met and the COC and the Royal Opera, the demand that you be a smart singer *and* have a stunning instrument is hugely important. Looking at someone like [Barbara Hannigan](/scene/people/barbara-hannigan/), the current it-girl of contemporary music, is a great example of someone with a beautiful instrument who can sing Mozart with the best of them, but then can knock it out of the park in Berg and Ligeti and George Benjamin, who looks like a goddess and can move like a dancer.

## Do you feel that you have a responsibility to assess a singer's future potential? How might you discuss it?

OH! This is a question full of potential trouble!  Singing is so personal and one has to tread carefully sometimes when speaking the truth.  My answer to this is always evolving and totally based on the singer in front of me - what are their goals, and how do they talk about them?  Are they grounded in reality? Do they have a good sense of themselves and their singing?  Have they gone out and had any success at all? Do they have the discipline to work at the highest level? Do they think outside the box? 

My experience at the undergraduate level is that singers in my studio usually discover their path by their fourth year and by then are actively pursuing either singing or something completely different (anything from politics and business to law and teaching!). Sometimes this is a result of a conversation we have had in third year about their potential and life goals, and sometimes it just happens organically.  I also teach a second-year performance class for singers and I am always amazed at how self-aware many of them are about the industry and their personal goals and what they feel their place might be. 

That doesn't mean they don't struggle, however; through their process of exploring and learning, often they have figured out their place (or at least a next step) by the time they graduate.

When working with pre-professional singers, I really feel strongly that if someone is willing to put in the work and they have some potential, and they really think they want to be a singer, then they should go for it.  Far better to have tried their best, than to give up before they have really tested themselves.  As a teacher of voice and an independent consultant, I feel my job is to offer strategies for being a better singer. What they do with that is their responsibility and I feel strongly that the singing market is a great equalizer - it may not seem fair to some, but like all industries, an individual has the opportunity to choose how and when then enter that market, and when they make their exit. 

>Readers, if you know a voice teacher deserving of a little spotlight, let us know. Get in touch at [hello@schmopera.com](mailto:hellO@schmopera.com).
