+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-08-31T14:40:00-04:00"
lastmod = "2017-09-04T21:31:00-04:00"
preamble = "The professional career of Canadian soprano [Edith Wiens](/scene/people/edith-wiens/) is one that's truly all-encompassing. She is an Officer of the Order of Canada, a Grammy Award-winner, a lead specialist in the performance and recording of Lieder, and her concert and operatic appearances have taken her to the stages of La Scala, the Santa Fe Opera, the Glyndebourne Festival, the Salzburg Festival, and London's Wigmore Hall.\n\nAs an educator, Wiens is a faculty member at the Juilliard School, and she teaches regularly at The Metropolitan Opera's Lindemann Young Artist Development Program. She is in demand among the students of the Guildhall School of Music and Drama and the Royal College of Music in London, and she has been invited to work with the studios of the Bayerische Staatsoper, Oper Frankfurt, the Zürich Opernhaus, and the Norwegian National Opera. Wiens is the Artistic Director of the [International Meistersinger Akademie](https://meistersingerakademie.com/), which pairs emerging artists with valuable professional contacts.\n\nTo kick off our new interview series focusing on voice teachers, we spoke with Edith Wiens about all things voice: breath support, repertoire choice, and the important link between a student's present and future."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1504205235380/2017-08-31---Edith-Wiens.jpg.jpg"
publishDate = "2017-09-04T20:51:00-04:00"
related_articles = ["articles/talking-with-voice-docs-dr-paul-e-kwak.md","articles/the-voice-teacher-series-elizabeth-mcdonald.md","articles/the-voice-teacher-series-betsy-bishop.md","articles/the-voice-teacher-series-jennifer-casey-cabot.md"]
related_companies = ["scene/companies/bayerische-staatsoper.md","scene/companies/the-juilliard-school.md","scene/companies/the-metropolitan-opera.md","scene/companies/glyndebourne.md","scene/companies/the-santa-fe-opera.md","scene/companies/salzburg-festival.md","scene/companies/opernhaus-zurich.md"]
related_people = ["scene/people/edith-wiens.md"]
short_description = "&quot;&#039;Good singing&#039; is when I hear someone who is passionate in communication, who has something to say, and is true to him- or herself.  It is excellent singing when this is coupled with technical ease.&quot;"
slug = "the-voice-teacher-series-edith-wiens"
title = "The voice teacher series: Edith Wiens"
+++

## What do you enjoy most about teaching voice?

I love teaching voice in all its many facets. The process of diagnosing what needs to change, coupled with the clarity and specificity of technical solutions, leads to freedom of artistry and personhood for the student. This is thrilling to me.  

## What is the difference between a voice teacher and a voice coach?

The voice teacher takes full responsibility, together with the singer, for technical development and know-how.  A good voice teacher should also be a good musician, so that the singer learns to deal with issues of style, language, phrasing, and expression, without losing sight of the technical foundation.  For me a good voice coach often has a particular expertise (for example, German repertoire, *bel canto*, French opera), on top of the general musicianship that benefits the singer.  The voice coach is certainly an important part of the team.
  
## Can you describe what you hear when you feel you are hearing "good singing"?

"Good singing" is when I hear someone who is passionate in communication, who has something to say, and is true to him- or herself.  It is excellent singing when this is coupled with technical ease.  

## What is a healthy way of teaching the topic of breath support?

Breath management remains the center and crux of everything we do as singers. I teach a low breath, reminding the singer that during the intake of air, the pharyngeal cavity must stay open, and the sides of the soft palate are slightly lifted.  In exhaling, *appoggio* is maintained in a buoyant way. When the phrase is finished, the body releases low, so that the release becomes the new breath.  

Of course, the tongue and jaw play a big role in attaining freedom in the breath; breathing for high notes has its own demands, breath management in the *passaggio* is again addressed slightly differently, and a singer also learns to instinctually breathe for the length of phrase at hand. And yet it all must feel as natural and organic as possible — this is truly why a singer needs years of  study!

## How do you decide on appropriate repertoire recommendations for your students?

Appropriate repertoire is absolutely key to good development.  With the mature singer, it is so much fun to strategize the package of audition arias, making sure the *Fach* is clear, different languages and styles are represented, and the singer feels they can show their personality and artistry in all the pieces. 

For the beginner, of course we look for songs that suit the singer's temperament and ability, beginning with lighter arias — often Handel, then moving to Mozart. I like it very much when singers bring in suggestions of what they love — if it is way too hard, I will veto it, but I think independence in the choices is marvellous.  After all, they have to love what they do! I also rely on experienced colleagues to discuss repertoire — Matthew Epstein and Matthew Horner have been particularly helpful — and the entire team at Juilliard is amazing at this, as well.

## What trends have you noticed in the vocal writing of 21st-century music? What does it demand of singers?

My own experience as a performer was with late 20th-century music, which is often very demanding in range and rhythm, with great dynamic extremes.  Beauty of tone isn't always paramount as it is in Mozart, for example, though there is no difference in the complete commitment one must bring to the message.  

It seems to me that in the vocal writing of the 21st-century, melody is playing a larger role again.  Very often the orchestration is huge, meaning that the singer must be very solid technically to survive.  What I love about cutting-edge music is that the artist must find their own truth and depth in it; with no recordings to listen to, the singer must rely on their own instinct and musicality to make it work.  How exciting that is, and what a wonderful opportunity this gives the singer!   

## Do you feel that you have a responsibility to assess a singer's future potential? How might you discuss it?

In my studio, it is a given to me that I also mentor the singers into the appropriate career path.  I am interested in seeing my students move into the profession, and it is my responsibility to teach them in such a way that this can happen.  Along the way, of course we speak of the future, but always from the perspective of what the singer and I are doing in the present to make it happen.  The definition of the future is little steps happening every day.  

In masterclasses and in my teaching at the various young artist programs, I prefer to discuss the issues at hand with the singers I work with, and will address their future potential only when asked.  Adding to this, I created a summer program in Germany seven years ago called the [Internationale Meistersinger Akademie](https://meistersingerakademie.com/), where 30 agents, opera directors, casting directors and conductors come to assess and hire the young talented singers.  This is, of course, the moment of truth.  And - touch wood - so far the "proof" has been overwhelmingly positive.

>Readers, do you know a voice teacher who would make a great addition to our interview series? Let us know, at [hello@schmopera.com.](mailto:hello@schmopera.com)
