+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-04-18T21:01:00-04:00"
lastmod = "2018-05-04T21:43:00-04:00"
preamble = "American soprano [**Arianna Zukerman**](/scene/people/arianna-zukerman/)'s international performing career takes her from New York to Tel Aviv, singing everything from staged opera to chamber concerts. \n\nZukerman is in-demand as a masterclass technician and private teacher. She is Associate Director and Faculty Member of the [Potomac Vocal Institute](https://www.potomacvocal.com/voice-faculty#), and she is is the Chair of Vocal Studies at the Wintergreen Music Festival and Academy and is the Festival’s Advisor for Vocal Programming. \n\nIn the final of our three-part conversation with the voice faculty at PVI, Zukerman chats with us about the \"privilege\" of teaching singing, and her surprising revelation about breath support."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524876155468/sqZukerman.jpg.jpg"
publishDate = "2018-05-04T21:43:00-04:00"
related_people = ["scene/people/arianna-zukerman.md"]
short_description = "&quot;I won&#039;t give anyone false hope - there are those singers who don&#039;t have what it takes but it&#039;s not for me to tell those people.  That&#039;s a very hard-won lesson that sometimes only comes from putting yourself &quot;out there&quot; and seeing where you stack up.&quot;"
slug = "the-voice-teacher-series-arianna-zukerman"
title = "The voice teacher series: Arianna Zukerman"
+++

## What do you enjoy most about teaching voice?

In teaching voice, you never get to see the mechanism - the thing that's making the noise - and so it's a little like putting together a puzzle.  Which muscles are moving, which are impeding freedom of sound; it's fascinating.  I enjoy helping my students figure out what their bodies are doing so that they can improve.  Helping someone sing in a way that is new to them but allows them to express themselves better is a privilege.  Watching that unfold in the studio is endlessly invigorating.

## What is the difference between a voice teacher and a voice coach?

I think the easiest way to understand the difference is in an analogy to figure skating.  Ice skaters are judged on technical elements and artistic elements.  I think a teacher deals more with the technical nuts and bolts of singing and a coach helps more with artistry once the technical foundation is in place.  As a teacher I'm always talking about artistry and musicality and phrasing because often those choices aid in good technique but it's my job to get the brass-tacks of it done. 

##	Can you describe what you hear when you feel you are hearing "good singing"?

Good singing is not subjective.  I don't have to like it but I know it when I hear it.  There's an ease of phrasing, consistency of tone through the range, good use of language and good stylistic choices.  I mean it though when I say I don't have to like it.  I can disagree with the choices, I can feel phrases should go differently, but when things are being executed well and there is a freedom in the tone it's obvious and exciting.

## What is a healthy way of teaching the topic of breath support?

My aim in teaching is to help singers find clear physical sensations that correspond to what they're doing.  I don't like guess-work.  If you have a high note, you should know what your body needs to do to make it happen.  It always comes back to breath.  When a tone is "supported" you have to know how you did it. 

My last teacher, Conrad Osborne, has a quiz he gives new students.  One of the questions he asks is, how is breathing for singing different than breathing for normal respiration?  I was kind of flabbergasted when I saw that question because I had never thought about support as different than normal breathing.  I just kind of thought it was bigger.  And to be fair, it is bigger.  I have come to understand the answer to be that in addition to the expansion in the body that is beyond "normal" respiration, it is the rate of intake of air versus the rate of the release of air that makes a tone supported.  You can feel air coming in and you can feel it going out. 

That very clear, very physical sensation is so important especially to younger singers.  Once they feel it, the controlled release of air is a clear goal and what ultimately leads to good "breath support".

## How do you decide on appropriate repertoire recommendations for your students?  

Some young singers don't have much exposure to the vast repertoire they have to choose from.  I encourage singers to be curious and listen a lot so that their tastes guide the repertoire choices we make in the studio. In young singers, I focus on lieder and art song that helps enforce good use of language and good legato.  I like to stay away from arias at the beginning especially if there's an aria I know a singer could use for years. Muscle memory is a powerful thing and so learning arias before one's technique is in place just means more work in the future to work in those good, new habits. 

Once a singer is ready to start auditioning there are certain composers and styles that are expected of them.  I want to choose repertoire that shows genuine proficiency in technique and style.  I highly recommend that a student at this level also have a regular coach.  It's helpful to me as a teacher as I then am privy to that person's ears and experience.  It's important to have a team.

## What trends have you noticed in the vocal writing of 21st-century music? What does it demand of singers?

I have found that 21st-century music is generally more singer-friendly in that there's a renewed ease of melody.  I'm a melody girl so it speaks to me.  The demands are as they have always been when a piece is new.  If it's a premiere, no one knows how it's supposed to go.  No one can tell you where the pitfalls are, or where you have to save your stamina.  For me that's always what is most difficult with new works.

## Do you feel that you have a responsibility to assess a singer's future potential? How might you discuss it?

If a student asks me about their potential, I will address the positive aspects of what they do first.  I also will be realistic about repertoire - if someone wants to sing Wagner heroines and it's clear they should be singing comprimario roles, I try to lay that out.  But as for potential in the business? The business has changed, and continues to change at an extraordinary rate.  I truly believe that potential has more to do with hard work and connections than anything else.  

I won't give anyone false hope - there are those singers who don't have what it takes but it's not for me to tell those people.  That's a very hard-won lesson that sometimes only comes from putting yourself "out there" and seeing where you stack up.  Mostly, I work to empower my students to understand that hard work comes first and after that it's really anyone's game.

>Readers, do you know a teacher worthy of some spotlight? Send your nominations for our Voice Teachers interview series to [hello@schmopera.com](mailto:hello@schmopera.com).
