+++
author = ["authors/colleen-maybin.md"]
categories = "Op-ed"
date = "2017-07-21T14:57:00-04:00"
lastmod = "2017-10-27T11:46:00-04:00"
preamble = "New contributor [Colleen Maybin](/authors/colleen-maybin/) is the Director of Education and Community Engagement at Vancouver Opera. She curates the all of the community programs and public events during the Vancouver Opera Festival, and she was excited to send us the following submission in response to Vancouver Opera's inaugural New Works Project."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1500851588678/2017-07-23---Workshop.jpg.jpg"
publishDate = "2017-07-28T09:14:00-04:00"
related_articles = ["articles/the-future-of-opera-is-indie.md"]
related_companies = ["scene/companies/vancouver-opera.md"]
short_description = "&quot;I appreciated that we weren&#039;t the focus of the project; we were the vessel for it. Everything in the experience was about making the art better and it was our job to the best performance possible. In any opera, the music comes from the libretto and every note means something. To have that be the full focus of the project meant that was a different musical experience for me.&quot;"
slug = "the-value-of-creating-new-work-for-singers"
title = "The value of creating new work for singers"
+++

In the creation of new opera, the focus is on the composer and librettist who have been brought together. The journey to opening night is a long one that takes years as the work is shaped and reworked into its final form. As the opera moves from sketches to workshops through to staging and opening night, singers present the work to audiences large and small at each stage of its development.

In Canada, [Tapestry Opera](/scene/companies/tapestry-opera/) has created the [Composer-Librettist Laboratory](https://tapestryopera.com/composer-librettist-laboratory/) project (colloqually known as the LibLab) that provides emerging composers and librettists with an opportunity to develop new work in an intense yet supported environment. In May of this year, Tapestry premiered *Oksana G.* by composer [Aaron Gervais](/talking-with-composers-aaron-gervais/) and librettist Colleen Murphy, an opera which had its origins in the Composer-Librettist Laboratory. Many different singers were involved in the workshop process, and some of those singers were in the premiere production.  Through this process, the singers helped to shape the final production through their individual interpretations. But how do these workshop experiences impact these singers?

Inspired by the Composer-Librettist Laboratory at Tapestry Opera and the work done by Artistic Director [Michael Mori](/scene/people/michael-mori/), [Vancouver Opera](/scene/companies/vancouver-opera/) created the New Works Project in the spring of 2017. The project was developed in partnership with the University Of British Columbia's School Of Music and Creative Writing Program, and the intent was to provide an opportunity for recent graduates to work within the opera art form under the guidance of more established artists. 

Composer Benton Roark and director Rachel Peake worked with librettists Heather Ramsay and Zoe Mix and composers Carolyn Quick and Katerina (Kit) Gimon, who brought together with the goal to write four new scenes in three weeks. It was a bit like speed dating, but with the requirement to collaborate from the initial meeting. The project took place during the Vancouver Opera Festival with workshops and feedback sessions open to the public. The community were able to follow the process from initial sketches through to a fully staged performance on the closing weekend of the festival.

Baritone Geoff Schellenberg and soprano Tamar Simon, both recent graduates of the UBC Opera Masters program, took on the task of performing the new work as it developed. Tamar and Geoff are at the beginning of their professional careers, and I was curious as to how their participation in this type of program might impact their practice.

How did this impact the singers who participated in the project? What did in mean to them to perform new material on an almost daily basis in front of an audience?  What would
they take away from this experience? 

After the rush of the festival was over, I sat down with Geoff and Tamar to learn more about their experience with the project.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1500851625185/2017-07-21---GeoffTamar.jpg.jpg)
<figcaption>Geoff Schellenberg, baritone, and Tamar Simon, soprano. Photos courtesy of Vancouver Opera.</figcaption>
</figure>

### Can you describe your experience with VO's New Works Project.

**Geoff**: I appreciated that we weren't the focus of the project; we were the vessel for it. Everything in the experience was about making the art better and it was our job to the best performance possible. In any opera, the music comes from the libretto and every note means something. To have that be the full focus of the project meant that was a different musical experience for me.

**Tamar**: When we get the music we are focused on the performance aspect of it. We are focused on how we are going to perform, what it's going to look like and sound like. With this project it wasn't about us. We wanted to interpret it the way they wrote it.

## What role did the coaches, Benton Roark and Rachel Peake, play in the process?

**Tamar**: Benton worked with the composers really closely. However, he listened to us closely and would use any issues with diction or pitches as an opportunity to provide feedback to the composers.

**Geoff**: Rachel, in her role as dramaturge, ensured that the librettists words were really communicating what they wanted to say. Sometimes I wouldn't understand why I was struggling with a piece of text; she always seemed to know before anyone else and would explore the potential program to ensure clarity.

**Tamar**: It always went back to why it was written in this specific way and how we could ensure the meaning was clear to the audience.

## What aspects of the project have had the most impact on your practice?

**Tamar**: I am looking at repertoire in a new way. My focus has deepened on the intent of the composers and librettists regardless of when the work was written. Why did these composers make these choices? Why did they use this chord, this tempo marking, this indication? Indications have more meaning for me now. If they wrote "mysteriously", how does that impact me as a singer? I have experienced the care that is put into markings, everything that is included is important.

**Geoff**: We have been told this 100 times by coaches and teachers but this experience helped us to fully understand. In seeing the creative process from the inside, you are seeing it from a different perspective. It adds to the meaning of the music.

**Tamar**: It was also a lot of hard work! You have to go in with a really positive attitude and an openness to make mistakes. The sight reading was a huge aspect of it. I reviewed the music every night with the understanding that in the morning I would received revisions. I looked at the music constantly – after rehearsal, in the morning. It never really stops.

**Geoff**: It was really busy. The hardest part for us was the sight reading – it's not something opera singers really have to do. I am used to arriving with the music fully memorized. I learned more music during this time than I am preparing for my upcoming role. I had to be prepared to be uncomfortable.

**Tamar**: The sight reading! Our musicianship improved over night. However, I now have more confidence in myself. I can learn music faster than I thought and I have more trust in the decisions I make in the moment.

**Geoff**: The program filled a void in many ways. It was intense and operatic! These kinds of opportunities are rare and it is an important part of moving the art form forward.
***
Vancouver Opera's New Works Project will return as part of the [2018 Vancouver Opera Festival](http://www.vancouveropera.ca/2017-2018-Season-and-Festival).
