+++
author = ["authors/greg.md"]
categories = "Review"
date = "2017-10-20T11:05:00-04:00"
lastmod = "2017-10-20T11:25:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508512595663/2017-10-20---square---Susan-Platts%2C-Peter-Oundjian-Jag-Gundu.jpg.jpg"
primary_image_credit = "Susan Platts, mezzo-soprano, and Peter Oundjian, Music Director, with the Toronto Symphony Orchestra. Photo: Jag Gundu."
publishDate = "2017-10-20T11:19:00-04:00"
related_companies = ["scene/companies/toronto-symphony-orchestra.md"]
related_people = ["scene/people/michael-schade.md","scene/people/susan-platts.md"]
short_description = "Forrester became known for her interpretations of Mahler and for her professional relationship with the composer&#039;s protegé Bruno Walter, so it&#039;s no surprise to find the composer on the program. After the intermission, German-Canadian tenor Michael Schade joined Ms. Platts for Mahler&#039;s Das Lied von der Erde (The Song of the Earth), one of the composer&#039;s best loved works."
slug = "the-tso-pays-homage-to-maureen-forrester"
title = "The TSO pays homage to Maureen Forrester"
+++

G'day Schmop-Tops!

My first offering from the Toronto Symphony Orchestra (TSO) for this season was on Tuesday at Toronto's beloved Roy Thomson Hall. The night's program was a tribute to Maureen Forrester hosted by Canada's opera superstar Ben Heppner (#BigBen, #OGTripleSwoonTimesInfinity). The night's program featured mezzo [Susan Platts](/scene/people/susan-platts/) and tenor [Michael Schade](/scene/people/michael-schade/) with the TSO's Peter Oundjian on the podium. 

The night featured two world premieres: *Start: Sesquie for Canada's 150th* by John Abram, commissioned by the TSO as part of their Canada Mosaic, and *L'Aube* by Academy Award Winner Howard Shore (*The Lord of the Rings*). Mr. Schade joined Ms. Platts and the TSO to end the night with a nod to Ms. Forrester by performing Mahler's *Das Lied von der Erde* (*The Song of the Earth*).

Opening the evening, which was held bilingually (a nice and overdue treat), was the TSO commission by John Abrams. The composer described the piece as a prelude to a listening experience. His program notes were the length of a tweet and mentioned how long program notes shouldn't be. 

The piece itself was a lot of fun. Cinematic and theatrical, the score made heavy use of pedal tones through its short duration with rhythmic statements flaring from the core of the orchestra's tone. Complex rhythms and meters gave the piece a sense of urgency that pulled you in further. It was an entirely engaging prelude. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508512667559/2017-10-20---Howard-Shore%2C-Ben-Heppner-Jag-Gundu.jpg.jpg)
<figcaption>Howard Shore and Ben Heppner. Photo: Jag Gundu.</figcaption>
</figure>

*L'Aube* (*Dawn*) followed the Abrams and a short yet charming interlude with Mr. Heppner where he offered the audience a glimpse into "the people's diva." I'm sure Forrester would have loved seeing it on the program, as she was a champion of new Canadian music, from singing it herself to being named chair of the Canada Council for the Arts. Composed by the 4-time (!) Academy Award-winner for his work in the blockbuster *Lord of the Rings* trilogy of films\* (you may have heard of them), Shore's piece was commissioned by the TSO to celebrate #Canada150 it is described by the composer and librettist (Elizabeth Cotnoir) as "a humble prayer of forgiveness to our planet and to each other."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508512684192/2017-10-20---Howard-Shore%2C-Elizabeth-Cotnoir%2C-Susan-Platts%2C-Peter-Oundjian-Jag-Gundu-2.jpg.jpg)
<figcaption>Howard Shore, Elizabeth Cotnoir, Susan Platts, and Peter Oundjian. Photo: Jag Gundu.</figcaption>
</figure>

Mezzo Susan Platts does not disappoint. Her voice was creamy and rich yet vibrant with a quick action and soulful production. There was a reverence to her delivery that was charming and created a sense of intimacy in the vast expanse that is Roy Thomson Hall. Her voice seemed to weave in and out of Shore's sometimes cellular and ostinato-laden score more like an instrument of the orchestra itself rather than a solo voice accompanied by an orchestra. 

Forrester became known for her interpretations of Mahler and for her professional relationship with the composer's protegé Bruno Walter, so it's no surprise to find the composer on the program. After the intermission, German-Canadian tenor Michael Schade joined Ms. Platts for Mahler's *Das Lied von der Erde* (*The Song of the Earth*), one of the composer's best loved works. 

Alternating between each movement, Schade opened the piece and Platts ended it. I found this piece to be a bit disappointing. The orchestra's robust sound (which is gorgeous, I'll have you know) was just too much for a hall like RTH that is so unforgiving to sing in. The acoustics are phenomenal for symphonic music, the human voice tends to get gobbled-up in the brutalist architecture. I found Schade struggled with this the most and I felt as though he was reading the score pretty hard and that brought a disconnect between him and the audience. Platts was more suited to the task, but not without its challenges. I feel like her background in art song helped her greatly here in a hall that devours consonants. Everyone played and sang the work incredibly well it was just plagued by balance issues. The final movement, "Der Abschied", was breathtaking.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508512712375/2017-10-20---Michael-Schade%2C-Peter-Oundjian-Jag-Gundu.jpg.jpg)
<figcaption>Michael Schade and Peter Oundjian. Photo: Jag Gundu.</figcaption>
</figure>

Oundjian conducted the whole evening with class and panache. The TSO's malleable dynamics in both the Shore and the Mahler were incredible and shout out to that bomb oboe playing. The oboe has been one of my favourite instruments since I first heard the "Bring Him Home" solo on the [*Les Misérables* 10th Anniversary Concert](https://www.youtube.com/watch?v=W54DzMTzLvs); last night reaffirmed why.

The TSO will be presenting this program (sans the Abram piece, I'm afraid) again on October 20, 2017 and you can get your [tickets here](https://www.tso.ca/concert/tribute-maureen-forrester?gclid=EAIaIQobChMI3cbp1r7_1gIVylmGCh3x9QS2EAAYASAAEgLYqvD_BwE). 

\*Disclaimer: I am a Tolkien junkie and spent a period of my life reading the trilogy once a year (because I read the Christopher Lee who plays Saruman did that) and I do not regret a moment of it. Also, I was called back for the role of Gimli in the LOTR "musical" here in TO.
